<#assign userId = 'BaseSecurityUtil.getUser().getId()'>
<#assign deptId = 'BaseSecurityUtil.getUser().getDeptId()'>
<#assign userName = 'BaseSecurityUtil.getUser().getUserName()'>
<#assign deptName = 'BaseSecurityUtil.getUser().getDeptName()'>
<#assign insertFillFields>
    <#list table.fields! as field>
        <#if field.fill??>
            <#switch field.fill>
            <#-- 创建人-->
                <#case 'createUser'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(
                    <#if field.type == 'string'>
                        String.valueOf(${userId})
                    <#elseif field.type == 'long'>
                        ${userId}
                    <#else>
                        (${field.propertyType!}) ${userId}
                    </#if>);
                    <#break>
                <#-- 所属人-->
                <#case 'dataHolder'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(
                    <#if field.type == 'string'>
                        String.valueOf(${userId})
                    <#elseif field.type == 'long'>
                        ${userId}
                    <#else>
                        (${field.propertyType!}) ${userId}
                    </#if>);
                    <#break>
                <#-- 所属部门-->
                <#case 'dataOrgan'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(
                    <#if field.type == 'string'>
                        String.valueOf(${deptId})
                    <#elseif field.type == 'long'>
                        ${deptId}
                    <#else>
                        (${field.propertyType!}) ${deptId}
                    </#if>);
                    <#break>
                <#-- 创建时间-->
                <#case 'createTime'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(
                    <#if field.type == 'date'>
                        LocalDateTime.now()
                    <#elseif field.type == 'string'>
                        org.apache.commons.lang3.time.DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss")
                    <#else>
                        (${field.propertyType!}) LocalDateTime.now()
                    </#if>);
                    <#break>
                <#-- 修改人-->
                <#case 'updateUser'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(
                    <#if field.type == 'string'>
                        String.valueOf(${userId})
                    <#elseif field.type == 'long'>
                        ${userId}
                    <#else>
                        (${field.propertyType!}) ${userId}
                    </#if>);
                    <#break>
                <#-- 修改时间-->
                <#case 'updateTime'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(<#if field.type == 'date'>LocalDateTime.now()<#elseif field.type == 'string'>org.apache.commons.lang3.time.DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss")<#else>(${field.propertyType!}) LocalDateTime.now()</#if>);
                    <#break>
                <#--  删除标识-->
                <#case 'delDefFlag'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}("0");
                    <#break>
                <#--  流水号-->
                <#case 'serialNumber'>
                    CodePlusDto codePlusDto = new CodePlusDto();
                    codePlusDto.setRuleCode("${codeRule!}");
                    codePlusDto.setLevel("0");
                    Map<String, Object> variableMap = new HashMap<>();
                    <#list variables! as variable>
                        <#if variable == "departmentName">
                            variableMap.put("departmentName", ${deptName});
                        <#elseif variable == "userId">
                            variableMap.put("userId", ${userId});
                        <#elseif variable == "userName">
                            variableMap.put("userName", ${userName});
                        <#elseif variable == "departmentId">
                            variableMap.put("departmentId", ${deptId} == null ? "" : ${deptId});
                        <#else>
                            <#list table.fields! as field>
                                <#if field.id = variable>
                                    <#if field.propertyType == "Boolean">
                                        variableMap.put("${variable!}", ${table.entityName?uncap_first}.is${field.capitalName!}()  == null ? "" : ${table.entityName?uncap_first}.is${field.capitalName!}());
                                    <#else>
                                        variableMap.put("${variable!}", ${table.entityName?uncap_first}.get${field.capitalName!}() == null ? "" : ${table.entityName?uncap_first}.get${field.capitalName!}());
                                    </#if>
                                </#if>
                            </#list>
                        </#if>
                    </#list>
                    codePlusDto.setVariableMap(variableMap);
                    ${table.entityName?uncap_first}.set${field.capitalName!}(this.iSysCodeRuleService.getCurrentCode(codePlusDto));
                    <#break>
                <#default>
                <#-- 其他为空-->
            </#switch>
        </#if>
    </#list>
</#assign>
<#assign updateFillFields>
    <#list table.fields! as field>
        <#if field.fill??>
            <#switch field.fill>
            <#-- 修改人-->
                <#case 'updateUser'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(
                    <#if field.type == 'string'>
                        String.valueOf(${userId})
                    <#elseif field.type == 'long'>
                        ${userId}
                    <#else>
                        (${field.propertyType!}) ${userId}
                    </#if>);
                    <#break>
                <#-- 修改时间-->
                <#case 'updateTime'>
                    ${table.entityName?uncap_first}.set${field.capitalName!}(<#if field.type == 'date'>LocalDateTime.now()<#elseif field.type == 'string'>org.apache.commons.lang3.time.DateFormatUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss")<#else>(${field.propertyType!}) LocalDateTime.now()</#if>);
                    <#break>
                <#default>
                <#-- 其他为空-->
            </#switch>
        </#if>
    </#list>
</#assign>
<#--判断是否有主键-->
<#if table.keyField?? && table.keyField.capitalName??>
    <#assign isPrimary = true>
    <#assign primaryField = table.keyField.capitalName!>
</#if>
<#-- 新增填充 -->
<#if insertFill?? && insertFill!>
<#-- 判断是否是修改-->
    <#if isPrimary?? && isPrimary!>
        if (${table.entityName?uncap_first}.get${primaryField!}() == null || <#if serviceEnName??>${serviceEnName!}<#else>this</#if>.getById(${table.entityName?uncap_first}.get${primaryField!}()) == null) {
        ${insertFillFields!}
        }
    <#--  如果有新增填充并且有修改填充 -->
        <#if updateFill?? && updateFill!>
            else {
            ${updateFillFields!}
            }
        </#if>
    <#else>
    <#--  无主键只有新增填充-->
        ${insertFillFields!}
    </#if>
<#elseif isPrimary?? && isPrimary!>
<#--  无新增填充 但是有修改填充 -->
    <#if updateFill?? && updateFill!>
    <#--  判断是否是修改-->
        if (${table.entityName?uncap_first}.get${primaryField!}() != null && <#if serviceEnName??>${serviceEnName!}<#else>this</#if>.getById(${table.entityName?uncap_first}.get${primaryField!}()) != null) {
        ${updateFillFields!}
        }
    </#if>
</#if>
