/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.masterslaveflow.util.DmFlowMsUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOW_MASTER_SLAVEFlowFormSaveStart")
public class DmMsFlowFormSaveStartVisitor
implements DmOperationVisitor<DmFlowMsDataModel, DmFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsFlowFormSaveStartVisitor.class);
    public static final String OPERATION_NAME = "DMFLOW_MASTER_SLAVEFlowFormSaveStart";

    @Override
    public void visit(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmFlowMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        DmDataModelFieldDto keyField = useDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> params = this.initParams(dataModelOperation, useDataModelDTO, backCtx);
        String masterId = backCtx.getUseDataModelBase().getMasterTable().getId();
        DmFlowMsDataModelDTO dmFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(masterId);
        if (dmFlowMsDataModelDTO == null) {
            useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().ifPresent(fieldDto -> params.put("securityLevel", fieldDto.getCapitalName()));
        } else {
            dmFlowMsDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().ifPresent(fieldDto -> params.put("securityLevel", fieldDto.getCapitalName()));
        }
        String controllerPath = "template/dm/flowbackcode/masterslaveflowbackcode/addorupdate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/dm/flowbackcode/masterslaveflowbackcode/addorupdate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        String serviceImplPath = "template/dm/flowbackcode/masterslaveflowbackcode/addorupdate/service_impl.ftl";
        params.put("isRemote", VfgModeTool.isRemote());
        params.put("primaryField", keyField.getCapitalName());
        DmFlowMsUtil.renderMsInsertOrUpdate(params, backCtx);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        this.renderImport(backCtx, modelId, useDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6d41\u7a0b\u8868\u5355\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, String modelId, DmFlowMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.Map");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmFlowMsDataModelDTO dmFlowDataModelDTO, DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", dmFlowDataModelDTO);
        params.put("dataSourceAnnotation", DmDataSourceUtil.getMethodDataSourceAnnotation());
        params.put("parameter", dmFlowDataModelDTO.getQueryDtoMap().get(dmFlowDataModelDTO.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dmFlowDataModelDTO.getComment() + "\u4fdd\u5b58\u6d41\u7a0b\u8868\u5355");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        DmFlowMsUtil.generateIncrementDTO(dmFlowDataModelDTO, backCtx, dataModelOperation);
        return params;
    }
}

