/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmEnclosure;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmFlowMsDataModel
extends DmMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(DmFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<DmDataModelField> flowFields;

    public List<DmDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<DmDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"DM.FLOW_MASTER_SLAVE", DmFlowMsDataModel.class);
    }

    @Override
    public DmFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        DmFlowMsDataModel dmFlowMsDataModel;
        try {
            ArrayList<DmDataModelField> fieldList = new ArrayList<DmDataModelField>();
            dmFlowMsDataModel = (DmFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), DmFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                DmDataModelBase master = DmDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(dmFlowMsDataModel.getName() + "Master");
                dmFlowMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<DmDataModelBase> slaveTables = new ArrayList<DmDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    DmDataModelBase slaveTable = DmDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (DmRelationshipBase relationship : dmFlowMsDataModel.getRelationships()) {
                    DmDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(DmBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    DmDataModelField DMDataModelField = new DmDataModelField();
                    DMDataModelField.setId(UUID.randomUUID().toString());
                    DMDataModelField.setName(dataModelBase.getName());
                    DMDataModelField.setComment(dataModelBase.getComment());
                    DMDataModelField.setSourceDataModelId(dataModelBase.getId());
                    DMDataModelField.setDataType("array");
                    fieldList.add(DMDataModelField);
                }
                dmFlowMsDataModel.setSlaveTables(slaveTables);
            }
            dmFlowMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dmFlowMsDataModel;
    }

    @Override
    public DmEnclosure<DmDataModelBase> enclosure() throws LcdpException {
        return DmModelBeanUtil.getEnclosureBean("DM", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public DmRender<DmDataModelBase, DmDataModelBaseDTO> render() throws LcdpException {
        return DmModelBeanUtil.getRenderBean("DM", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<DmDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<DmDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<DmDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<DmDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<DmDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<DmDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

