/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.task.DmTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.dm.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.dm.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMTASK_MASTER_SLAVEDataDisplay")
public class DmMsTaskDataDisplayVisitor
implements DmOperationVisitor<DmTaskMsDataModel, DmTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsTaskDataDisplayVisitor.class);
    public static final String OPERATION_NAME = "DMTASK_MASTER_SLAVEDataDisplay";

    @Override
    public void visit(DmBackCtx<DmTaskMsDataModel, DmTaskMsDataModelDTO> taskBackCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        DmFlowMsDataModelDTO dataModelBaseDTO = (DmFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        DmFlowMsDataModel useDataModelBase = (DmFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx = new DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(useDataModelBase);
        HashMap<String, DmFlowMsDataModelDTO> map = new HashMap<String, DmFlowMsDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        Map<String, String> aliasMap = useDataModelBase.getModelAliasName();
        Map<String, Object> params = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, useDataModelBase, dataModelBaseDTO, params);
        String relateFieldName = String.valueOf(params.get("relateField"));
        String relateField = dataModelBaseDTO.getFieldCapitalName(relateFieldName);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, params);
        String controllertempPath = "template/dm/masterslavebackcode/datadisplay/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllertempPath, params));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSelectCondition);
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        logger.debug("\u751f\u6210service\u6267\u884c\u5f00\u59cb");
        String servicePath = "template/dm/masterslavebackcode/datadisplay/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        logger.debug("\u751f\u6210serviceImpl\u6267\u884c\u5f00\u59cb");
        String serviceImplPath = "template/dm/masterslavebackcode/datadisplay/service_impl.ftl";
        params.put("capitalRelateField", relateField);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/dm/masterslavebackcode/datadisplay/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, params));
        String xmlPath = "template/dm/masterslavebackcode/datadisplay/xml.ftl";
        Map<String, DmDataModelBase> dataModelBaseMap = dataModelBaseDTO.getDataModelBaseMap();
        String finalReturn = SqlReturnUtil.renderReturn(useDataModelBase, aliasMap);
        params.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(useDataModelBase, dataModelBaseMap);
        params.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, params));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", isSelectCondition ? "postJson" : "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u5c55\u793a");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderPageVo(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, String modelId, DmFlowMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmDataModelUtil.addQueryPageMsVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + DmDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private void renderImport(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, String modelId, DmFlowMsDataModelDTO dataModelBaseDTO, boolean isSelectCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.annotations.AuditLog");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "java.util.Arrays");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        } else {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
            backCtx.addControllerImport(modelId, "java.util.Arrays");
            backCtx.addServiceImport(modelId, "java.util.List");
        }
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmDataModelBaseDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", dataModelBaseDTO);
        params.put("returnValue", dataModelBaseDTO.getEntityName());
        params.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        params.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6570\u636e\u5c55\u793a");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        return params;
    }

    private boolean renderSelect(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, DmFlowMsDataModel useDataModelBase, DmFlowMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        Map<String, String> aliasMap = useDataModelBase.getModelAliasName();
        String inValuesSql = this.getInValuesSql(useDataModelBase, dataModelOperation, aliasMap, selectConditionName);
        boolean isSelectCondition = false;
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            DmQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (DmQueryConditionField queryConditionField : queryCondition.getFields()) {
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(DmQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                String logicallyFlag = "";
                if (isLogicallyDelete) {
                    DmDataModelField DMDataModelField = useDataModelBase.getDeleteFlag();
                    QueryConditionUtil.addLogicallyFlag(queryCondition, DMDataModelField.getName(), useDataModelBase.getMasterTable().getId());
                    logicallyFlag = DMDataModelField.getSourceFieldName();
                }
                DmQueryDTO queryDTO = DmDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
                dataModelBaseDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, aliasMap, useDataModelBase, logicallyFlag);
                if (useDataModelBase.isLogicallyDelete()) {
                    QueryConditionUtil.deleteLogicallyFlag(queryCondition);
                }
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", DmConstUtil.TRUE);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        } else {
            controllerParams.put("whereSql", inValuesSql);
        }
        return isSelectCondition;
    }

    private String getInValuesSql(DmFlowMsDataModel useDataModelBase, DmDataModelOperation dataModelOperation, Map<String, String> aliasMap, String selectConditionName) {
        DmDataModelField realFieldBase;
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        if (ToolUtil.isNotEmpty((Object)entityAttr) && ToolUtil.isNotEmpty((Object)((Object)(realFieldBase = useDataModelBase.getFields().stream().filter(field -> entityAttr.equals(field.getName())).findAny().orElseGet(DmDataModelField::new))))) {
            String alias = aliasMap.get(realFieldBase.getSourceDataModelId());
            String sourceFieldName = realFieldBase.getSourceFieldName();
            if (useDataModelBase.isLogicallyDelete() && !StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                template = template + "AND (" + logicallyFlag + " != '1' or " + logicallyFlag + " IS NULL)";
            }
            return template.replace("${T_ALIAS}", alias).replace("${REAL_FIELD}", sourceFieldName);
        }
        return "";
    }
}

