/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.translate.DmTranslate;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.translate.DmTranslateCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.translate.DmTranslateField;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmPublicEnclosure;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DmTranslateUtil {
    public static void translateMsEnclosure(List<DmTranslate> translates, DmMsDataModel dataModelBase, DmDataModelBaseDTO dataModelBaseDTO) throws LcdpException {
        if (ToolUtil.isNotEmpty(translates)) {
            List<Map<String, Object>> translateAnnotations;
            ArrayList<DataModelFieldBase> rightFields = new ArrayList<DataModelFieldBase>();
            rightFields.addAll(dataModelBase.getMasterTable().getFields());
            if (ToolUtil.isNotEmpty(dataModelBase.getSlaveTables())) {
                List<DmDataModelBase> slaveTables = dataModelBase.getSlaveTables();
                for (DmDataModelBase slaveTable : slaveTables) {
                    rightFields.addAll(slaveTable.getFields());
                }
            }
            if (ToolUtil.isNotEmpty(translateAnnotations = DmTranslateUtil.translate(translates, rightFields))) {
                List<DmDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                List<DmDataModelFieldDto> voFields = dataModelBaseDTO.getVoGeneratorInfo().getFields();
                DmTranslateUtil.setFieldAnnotations(translateAnnotations, fields);
                DmTranslateUtil.setFieldAnnotations(translateAnnotations, voFields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<DmDataModelFieldDto> translateShowFields = DmTranslateUtil.getTranslateShowFields(translates);
            for (DmDataModelFieldDto translateShowField : translateShowFields) {
                if (null == translateShowField.getColumnType() || null == translateShowField.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(translateShowField.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
    }

    private static void setFieldAnnotations(List<Map<String, Object>> translateAnnotations, List<DmDataModelFieldDto> fields) {
        block0: for (Map<String, Object> translateAnnotation : translateAnnotations) {
            if (!ToolUtil.isNotEmpty(translateAnnotation) || !ToolUtil.isNotEmpty((Object)translateAnnotation.get("fieldId"))) continue;
            for (DmDataModelFieldDto field : fields) {
                if (!field.getId().equals(translateAnnotation.get("fieldId").toString())) continue;
                field.setFieldAnnotation(translateAnnotation.get("fieldAnnotation").toString());
                continue block0;
            }
        }
    }

    public static List<DmDataModelFieldDto> getTranslateShowFields(List<DmTranslate> translateConfigs) {
        ArrayList<DmDataModelFieldDto> showFields = new ArrayList<DmDataModelFieldDto>();
        for (DmTranslate translateConfig : translateConfigs) {
            if (!ToolUtil.isNotEmpty(translateConfig.getTranslateFields())) continue;
            List<DmTranslateField> translateFields = translateConfig.getTranslateFields();
            for (DmTranslateField translateField : translateFields) {
                if (!ToolUtil.isNotEmpty((Object)translateField) || !ToolUtil.isNotEmpty((Object)translateField.getName())) continue;
                DmDataModelFieldDto dataModelFieldDto = new DmDataModelFieldDto();
                dataModelFieldDto.setId(translateField.getId());
                dataModelFieldDto.setPropertyName(translateField.getName());
                dataModelFieldDto.setComment(translateField.getComment());
                dataModelFieldDto.setType(translateField.getDataType());
                dataModelFieldDto.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)translateField.getDataType()));
                showFields.add(dataModelFieldDto);
            }
        }
        return showFields;
    }

    public static List<Map<String, Object>> translate(List<DmTranslate> translateConfigs, List<DataModelFieldBase> rightFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty(translateConfigs)) {
            for (DmTranslate translate : translateConfigs) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (ToolUtil.isNotEmpty((Object)translate.getSourceFieldId()) && ToolUtil.isNotEmpty((Object)translate.getTranslateType())) {
                    map.put("fieldId", translate.getSourceFieldId());
                    switch (translate.getTranslateType()) {
                        case "dictTranslate": {
                            map.put("fieldAnnotation", DmTranslateUtil.dictTranslate(translate));
                            break;
                        }
                        case "userTranslate": {
                            map.put("fieldAnnotation", DmTranslateUtil.userTranslate(translate));
                            break;
                        }
                        case "organTranslate": {
                            map.put("fieldAnnotation", DmTranslateUtil.organTranslate(translate));
                            break;
                        }
                        case "modelTranslate": {
                            map.put("fieldAnnotation", DmTranslateUtil.modelTranslate(translate, rightFields));
                            break;
                        }
                    }
                }
                list.add(map);
            }
        }
        return list;
    }

    private static String dictTranslate(DmTranslate translate) {
        List<DmTranslateField> translateFields = translate.getTranslateFields();
        String label = translateFields.get(0).getName();
        String key = translate.getSourceId();
        String annotation = "@Trans(type = TransType.FIELD_TRANS, queryFields = { \"value\", \"type\" }, namespace = \"TranslateDict\", key = \"" + key + "\", ref = \"";
        annotation = annotation + label + "#label\" )";
        return annotation;
    }

    private static String userTranslate(DmTranslate translate) {
        List<DmTranslateField> translateFields = translate.getTranslateFields();
        String annotation = "@Trans(type = TransType.ID_TRANS, namespace = \"TranslateUser\", refs = {";
        String refs = "";
        for (int i = 0; i < translateFields.size(); ++i) {
            if (i == translateFields.size() - 1) {
                refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\"} )";
                break;
            }
            refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\",";
        }
        annotation = annotation + refs;
        return annotation;
    }

    private static String organTranslate(DmTranslate translate) {
        List<DmTranslateField> translateFields = translate.getTranslateFields();
        String annotation = "@Trans(type = TransType.ID_TRANS, namespace = \"TranslateOrganization\", refs = {";
        String refs = "";
        for (int i = 0; i < translateFields.size(); ++i) {
            if (i == translateFields.size() - 1) {
                refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\"} )";
                break;
            }
            refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\",";
        }
        annotation = annotation + refs;
        return annotation;
    }

    private static String modelTranslate(DmTranslate translate, List<DataModelFieldBase> rightFields) {
        String sourceId = translate.getSourceId();
        try {
            JSONObject dataModelBase = DataModelUtil.getDataModelJson((String)sourceId);
            DmModelFunction currentFunction = DmModelBeanUtil.getFunctionModelVisitorBean(String.valueOf(dataModelBase.get((Object)"functionType")));
            DmDataModelBase currentModelBase = DmDataModelUtil.transfer(dataModelBase);
            DmDataModelBaseDTO dataModelDto = new DmDataModelBaseDTO();
            DmPublicEnclosure.enclosure(currentModelBase, dataModelDto);
            String modulePath = dataModelDto.getTablePath().toLowerCase();
            String namespace = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
            List<DmDataModelFieldDto> leftFields = dataModelDto.getFields();
            List<DmTranslateCondition> dataModelCondition = translate.getDataModelCondition();
            ArrayList<String> queryFields = new ArrayList<String>();
            ArrayList<String> keyRefs = new ArrayList<String>();
            String queryField = "";
            String keyRef = "";
            if (ToolUtil.isNotEmpty(dataModelCondition)) {
                for (DmTranslateCondition translateCondition : dataModelCondition) {
                    String goalsRowId = translateCondition.getGoalsRowId();
                    String fromModelField = translateCondition.getFromModelField();
                    if (!ToolUtil.isNotEmpty((Object)goalsRowId) || !ToolUtil.isNotEmpty((Object)fromModelField)) continue;
                    DmDataModelFieldDto leftDataModelFieldDto = leftFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)goalsRowId)).findFirst().orElseGet(DmDataModelFieldDto::new);
                    queryFields.add(leftDataModelFieldDto.getPropertyName());
                    DataModelFieldBase dataModelFieldBase = rightFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)fromModelField)).findFirst().orElseGet(DataModelFieldBase::new);
                    keyRefs.add(dataModelFieldBase.getName());
                }
                if (queryFields.size() > 1) {
                    for (int i = 0; i < queryFields.size(); ++i) {
                        if (i == 0) {
                            queryField = queryField + "{ \"" + (String)queryFields.get(i) + "\",";
                            continue;
                        }
                        if (i == queryFields.size() - 1) {
                            queryField = queryField + " \"" + (String)queryFields.get(i) + "\" }";
                            break;
                        }
                        queryField = queryField + " \"" + (String)queryFields.get(i) + "\",";
                    }
                } else {
                    queryField = "{ \"" + (String)queryFields.get(0) + "\" }";
                }
                if (keyRefs.size() > 2) {
                    for (int i = 1; i < keyRefs.size(); ++i) {
                        if (i == 1) {
                            keyRef = keyRef + "keyRef = { \"" + (String)keyRefs.get(i) + "\",";
                            continue;
                        }
                        if (i == keyRefs.size() - 1) {
                            keyRef = keyRef + " \"" + (String)keyRefs.get(i) + "\" },";
                            break;
                        }
                        keyRef = keyRef + " \"" + (String)keyRefs.get(i) + "\",";
                    }
                } else {
                    keyRef = keyRefs.size() == 2 ? "keyRef = { \"" + (String)keyRefs.get(1) + "\" }," : "";
                }
            }
            List<DmTranslateField> translateFields = translate.getTranslateFields();
            ArrayList<String> refs = new ArrayList<String>();
            if (ToolUtil.isNotEmpty(translateFields)) {
                for (DmTranslateField translateField : translateFields) {
                    String rightTranslateSource = translateField.getTranslateSource();
                    if (!ToolUtil.isNotEmpty((Object)rightTranslateSource)) continue;
                    DmDataModelFieldDto rightDataModelFieldDto = leftFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)rightTranslateSource)).findFirst().orElseGet(DmDataModelFieldDto::new);
                    refs.add(translateField.getName() + "#" + rightDataModelFieldDto.getPropertyName());
                }
            }
            String ref = "";
            if (refs.size() > 1) {
                for (int i = 0; i < refs.size(); ++i) {
                    if (i == 0) {
                        ref = ref + "{ \"" + (String)refs.get(i) + "\",";
                        continue;
                    }
                    if (i == refs.size() - 1) {
                        ref = ref + " \"" + (String)refs.get(i) + "\" }";
                        break;
                    }
                    ref = ref + " \"" + (String)refs.get(i) + "\",";
                }
            } else {
                ref = "{ \"" + (String)refs.get(0) + "\" }";
            }
            String annotation = "@Trans(type = TransType.FIELD_TRANS, queryFields = ";
            annotation = annotation + queryField + ", namespace = \"" + namespace + "\", " + keyRef + " refs = " + ref + " )";
            return annotation;
        }
        catch (LcdpException | CloneNotSupportedException e) {
            throw new HussarException();
        }
    }
}

