/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.base;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMBASEAsyncVerify")
public class DmAsyncVerifyVisitor
implements DmOperationVisitor<DmBaseDataModel, DmBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "DMBASEAsyncVerify";

    @Override
    public void visit(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = backCtx.getUseDataModelBase().getId();
        DmBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u5f02\u6b65\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        controllerParams.put("entityName", dataModelBaseDTO.getEntityName());
        controllerParams.put("table", table);
        String controllerPath = "template/dm/backcode/asyncverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/backcode/asyncverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/backcode/asyncverify/service_impl.ftl";
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        List<DmDataModelField> fieldList = useDataModelBase.getFields();
        for (Object field : fieldList) {
            if (!ToolUtil.isNotEmpty((Object)field) || !field.isChkUnique()) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("columnName", (Object)field.getName());
            ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
            if (field.isChkUnique()) {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)"unique");
                obj.put("sourceFieldName", (Object)field.getSourceFieldName());
                obj.put("errorMsg", (Object)(field.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
                Map<String, Object> params = dataModelOperation.getParams();
                List asyncVerifyParams = (List)params.get("asyncVerifyParams");
                for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                    if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(field.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                    List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                    for (JSONObject paramRule : paramRules) {
                        if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                        obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                    }
                }
                rulesList.add(obj);
            }
            jsonObject.put("rules", rulesList);
            columnList.add(jsonObject);
        }
        controllerParams.put("columnList", columnList);
        List<DmDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        for (DmDataModelFieldDto field : fields) {
            if (!field.isKeyFlag()) continue;
            if ("Boolean".equals(field.getPropertyType())) {
                controllerParams.put("getPrimaryMethod", "is" + field.getCapitalName());
                break;
            }
            controllerParams.put("getPrimaryMethod", "get" + field.getCapitalName());
            break;
        }
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            DmDataModelField logicallyField = useDataModelBase.getDeleteFlag();
            for (DmDataModelFieldDto field : fields) {
                if (!field.getId().equals(logicallyField.getId())) continue;
                controllerParams.put("logicallyFlag", field.getCapitalName());
                break;
            }
        }
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5f02\u6b65\u6821\u9a8c");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, String modelId, DmBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
    }
}

