/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DmPublicEnclosure {
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);

    public static void enclosure(DmDataModelBase dataModelBase, DmDataModelBaseDTO dataModelBaseDTO) throws CloneNotSupportedException, LcdpException {
        boolean ignoreStrategy = false;
        dataModelBaseDTO.setDataSourceName(dataModelBase.getDataSourceName());
        dataModelBaseDTO.setId(dataModelBase.getId());
        dataModelBaseDTO.setName(dataModelBase.getName());
        dataModelBaseDTO.setComment(dataModelBase.getComment());
        dataModelBaseDTO.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setVoName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelBaseDTO.getName() + "VO"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setMapperName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setXmlName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setServiceName(dataModelBaseDTO.getEntityName() + "Service");
        dataModelBaseDTO.setServiceImplName(dataModelBaseDTO.getEntityName() + "ServiceImpl");
        dataModelBaseDTO.setControllerName(dataModelBaseDTO.getEntityName() + "Controller");
        dataModelBaseDTO.setModuleName(dataModelBase.getModelPath().replace("/", "."));
        dataModelBaseDTO.setDictName(dataModelBaseDTO.getEntityName() + NamingStrategy.capitalFirst((String)"dict"));
        dataModelBaseDTO.setTablePath(dataModelBase.getModelPath() + "/" + dataModelBase.getName());
        List<DmDataModelField> dataModelFieldBases = dataModelBase.getFields();
        ArrayList<DmDataModelFieldDto> tableFields = new ArrayList<DmDataModelFieldDto>();
        for (DmDataModelField dataModelFieldBase : dataModelFieldBases) {
            DmDataModelFieldDto tableField = new DmDataModelFieldDto();
            tableField.setKeyFlag("primary".equals(dataModelFieldBase.getUsage()));
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setId(dataModelFieldBase.getId());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (!Objects.equals(Optional.of(dataModelFieldBase).map(DmDataModelField::getUpdateStrategy).orElse(null), "not_null")) {
                ignoreStrategy = true;
            }
            if ("date".equals(dataModelFieldBase.getDataType())) {
                ignoreStrategy = true;
            }
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFields(tableFields);
        if (ignoreStrategy) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.FieldStrategy;");
        }
        if (dataModelBaseDTO.isUseMybatisPlus()) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.TableName");
        }
        Map packageInfo = EnclosureUtil.getPackageInfo((String)formDesignProperties.getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        dataModelBaseDTO.setPackageInfo(packageInfo);
        Map<String, String> importInfo = DmPublicEnclosure.getImportInfo(packageInfo, dataModelBaseDTO);
        dataModelBaseDTO.setImportInfo(importInfo);
        ArrayList<DmDataModelFieldDto> voFields = new ArrayList<DmDataModelFieldDto>();
        for (DmDataModelFieldDto tableField : tableFields) {
            voFields.add(tableField.clone());
        }
        VoGeneratorInfo voGeneratorInfo = new VoGeneratorInfo();
        voGeneratorInfo.setFields(voFields);
        dataModelBaseDTO.setVoGeneratorInfo(voGeneratorInfo);
    }

    public static Map<String, String> getImportInfo(Map<String, String> packageInfo, DmDataModelBaseDTO dataModelDto) {
        HashMap<String, String> importInfo = new HashMap<String, String>();
        importInfo.put("Entity", packageInfo.get("Entity") + "." + dataModelDto.getEntityName());
        importInfo.put("Mapper", packageInfo.get("Mapper") + "." + dataModelDto.getMapperName());
        importInfo.put("Xml", packageInfo.get("Xml") + "." + dataModelDto.getXmlName());
        importInfo.put("Service", packageInfo.get("Service") + "." + dataModelDto.getServiceName());
        importInfo.put("ServiceImpl", packageInfo.get("ServiceImpl") + "." + dataModelDto.getServiceImplName());
        importInfo.put("Controller", packageInfo.get("Controller") + "." + dataModelDto.getControllerName());
        importInfo.put("dict", packageInfo.get("dict") + "." + dataModelDto.getDictName());
        importInfo.put("dto", packageInfo.get("dto") + "." + dataModelDto.getEntityName() + "Qo");
        importInfo.put("VO", packageInfo.get("VO") + "." + dataModelDto.getVoName());
        return importInfo;
    }
}

