/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.result.DmCodeResult;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class DmCodeMergeUtil {
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
    private static MicroAppInfoService microAppInfoService = (MicroAppInfoService)SpringContextUtil.getBean(MicroAppInfoService.class);
    private static ResourcePathService resourcePathService = (ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class);
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private static CodeMergeService codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class);
    private static final String CLIENT_TYPE = "publishIds";

    public static List<DmCodeResult> mergeBack(List<DmCodeGenerateInfo> codeGenerateInfos, DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx) throws IOException, LcdpException {
        ArrayList<DmCodeResult> results = new ArrayList<DmCodeResult>();
        if (ToolUtil.isNotEmpty(codeGenerateInfos)) {
            List<Object> publishIds = new ArrayList();
            if (null != Optional.ofNullable(backCtx.getParams()).orElseGet(HashMap::new).get(CLIENT_TYPE)) {
                publishIds = Arrays.asList(backCtx.getParams().get(CLIENT_TYPE).toString().split(","));
            }
            for (DmCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                if ("js".equals(codeGenerateInfo.getFileType()) && ToolUtil.isNotEmpty(publishIds)) {
                    for (String string : publishIds) {
                        results.add(DmCodeMergeUtil.mergeBackCode(codeGenerateInfo, string, backCtx));
                    }
                    continue;
                }
                results.add(DmCodeMergeUtil.mergeBackCode(codeGenerateInfo, "", backCtx));
            }
        }
        return results;
    }

    private static DmCodeResult mergeBackCode(DmCodeGenerateInfo codeGenerateInfo, String publishId, DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx) throws IOException, LcdpException {
        BaseFile baseFile = HussarUtils.isNotEmpty((Object)backCtx.getBaseFile()) ? backCtx.getBaseFile() : new BaseFile();
        String absolutePath = resourcePathService.backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
        DmCodeResult genCodeResult = new DmCodeResult();
        genCodeResult.setResultType(ResultBeanEnum.DM_RESULT);
        DmCodeMergeUtil.formatCode(codeGenerateInfo);
        if (!codeGenerateInfo.isCodeFormatSucceed()) {
            genCodeResult.setId(baseFile.getId());
            genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
            genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
            genCodeResult.setCodeFormatMessages(codeGenerateInfo.getCodeFormatMessages());
            genCodeResult.setCodeFormatMsg(codeGenerateInfo.getCodeFormatMsg());
            genCodeResult.setCodeFormatSucceed(codeGenerateInfo.isCodeFormatSucceed());
            return genCodeResult;
        }
        String mergeCode = "";
        if (!(baseFile instanceof PageInfo)) {
            baseFile.setId(backCtx.getUseDataModelBase().getId());
        }
        String dataId = DmCodeMergeUtil.getVersionFileKey(codeGenerateInfo);
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            String writeFile;
            Optional<String> currentCode;
            if ("js".equals(codeGenerateInfo.getFileType())) {
                String jsPath = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(baseFile.getType())).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(jsPath));
            } else {
                String currentPath = resourcePathService.backProjectJava(new String[]{AppContextUtil.getAppBackCodePrefix(), codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(currentPath));
            }
            Optional<String> versionCode = Optional.ofNullable(versionManageService.getAncestorCodeById(dataId));
            String lastFileCode = versionManageService.getLastFileCode(dataId);
            if (currentCode.isPresent() && versionCode.isPresent()) {
                String jsPath = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(baseFile.getType())).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath();
                MergeResult mergeResult = codeMergeService.structuralMerge(jsPath, ExtractFileType.JS, versionCode.get(), currentCode.get(), codeGenerateInfo.getFileContent(), lastFileCode, false);
                if (mergeResult.isConflict()) {
                    genCodeResult.setExistConflict(true);
                    genCodeResult.setMergeCode(mergeResult.getMergedCode());
                    genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                    genCodeResult.setOriginCode(currentCode.get());
                    genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
                    genCodeResult.setLastPublish(mergeResult.getLastPublish());
                    genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                    genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                    genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                } else {
                    mergeCode = mergeResult.getMergedCode();
                }
                switch (codeGenerateInfo.getFileType()) {
                    case "controller": 
                    case "entity": 
                    case "service": 
                    case "serviceImpl": {
                        genCodeResult.setType("java");
                        break;
                    }
                    case "mapper": 
                    case "xml": {
                        genCodeResult.setType("xml");
                        break;
                    }
                    case "js": {
                        genCodeResult.setType("javascript");
                        break;
                    }
                }
            }
            String string = writeFile = ToolUtil.isEmpty((Object)mergeCode) ? codeGenerateInfo.getFileContent() : mergeCode;
            absolutePath = !genCodeResult.isExistConflict() ? DmCodeMergeUtil.writeNoConflictCode(codeGenerateInfo, baseFile, dataId, writeFile) : ("js".equals(codeGenerateInfo.getFileType()) ? FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(baseFile.getType())).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath() : resourcePathService.backProjectJava(new String[]{AppContextUtil.getAppBackCodePrefix(), codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath());
        }
        genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
        genCodeResult.setDataId(dataId);
        genCodeResult.setId(baseFile.getId());
        return genCodeResult;
    }

    private static void formatCode(DmCodeGenerateInfo codeGenerateInfo) {
        String fileType = codeGenerateInfo.getFileType();
        if (ToolUtil.isNotEmpty((Object)fileType) && ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity") || fileType.equals("vo")) {
                codeGenerateInfo.setFileContent(JavaCodeFormatUtil.format((String)codeGenerateInfo.getFileContent()));
            }
            if (fileType.equals("js")) {
                CodeFormatResult codeFormatResult = CodeFormatter.formatterHtml((String)codeGenerateInfo.getFileContent(), (String)"typescript");
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMsg(codeFormatResult.getMsg());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("xml")) {
                codeGenerateInfo.setFileContent(CodeSplitUtil.setEndOnlyLine((String)codeGenerateInfo.getFileContent()));
            }
        }
    }

    public static String writeNoConflictCode(DmCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String dataId, String writeFile) throws LcdpException, IOException {
        String absolutePath = "js".equals(codeGenerateInfo.getFileType()) ? filePublishService.writeApiCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId()) : filePublishService.writeMVCCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId());
        versionManageService.saveCacheLastPublishCode(dataId, codeGenerateInfo.getFileContent(), baseFile.getId());
        versionManageService.saveCacheLastFileCode(dataId, writeFile, baseFile.getId());
        return absolutePath;
    }

    private static String getVersionFileKey(DmCodeGenerateInfo codeGenerateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(codeGenerateInfo.getFileId());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getPageType()) && !"WebPage".equals(codeGenerateInfo.getPageType()) && !"MobilePage".equals(codeGenerateInfo.getPageType())) {
            stringBuilder.append(codeGenerateInfo.getPageType());
        }
        stringBuilder.append(codeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileName())) {
            stringBuilder.append(codeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }
}

