/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.provider;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FormDesignStringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.service.DmWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(DmModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"DM", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + FormDesignStringUtil.underlineToHump((String)dataModelBase.getName());
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        DmDataModelBase lrDataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(DmDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        DmDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (DmDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId) throws LcdpException, IOException, CloneNotSupportedException {
        return new DmWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        DmModelFunction modelFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        DmDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> dmDataModelFields = new ArrayList<DataModelFieldBase>();
        List<DmDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            dmDataModelFields.addAll(fields);
        } else {
            List<DmDataModelBase> slaveTables = null;
            DmDataModelBase masterTable = new DmBaseDataModel();
            if (modelFunction instanceof DmFlowMsDataModel) {
                slaveTables = ((DmFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((DmFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof DmMsDataModel) {
                slaveTables = ((DmMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((DmFlowMsDataModel)dataModelBase).getMasterTable();
            }
            dmDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (DmDataModelBase slaveTable : slaveTables) {
                    dmDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        return dmDataModelFields;
    }

    public void delete(String modelId) throws LcdpException {
    }
}

