/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.util;

import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.dm.function.DmEnclosure;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class DmModelBeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(DmModelBeanUtil.class);

    public static DmOperationVisitor<DmDataModelBase, DmDataModelBaseDTO> getVisitorBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u65b9\u6cd5\u8bbf\u95ee\u8005\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u65b9\u6cd5\u8bbf\u95ee\u8005\u5931\u8d25");
        }
        return (DmOperationVisitor)fromObj;
    }

    public static DmModelFunction getFunctionModelVisitorBean(String functionModelName) throws LcdpException {
        Object fromObj;
        try {
            fromObj = FunctionModelFactory.obtainFunction((String)("DM." + functionModelName)).newInstance();
            if (ObjectUtils.isEmpty(fromObj)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, fromObj + "\uff1a\u529f\u80fd\u6a21\u578b\u672a\u6ce8\u518c");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, functionModelName + "\uff1a\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25");
        }
        return (DmModelFunction)fromObj;
    }

    public static DmRender<DmDataModelBase, DmDataModelBaseDTO> getRenderBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (DmRender)fromObj;
    }

    public static DmEnclosure<DmDataModelBase> getEnclosureBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (DmEnclosure)fromObj;
    }
}

