/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.processor;

import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmModelFunction;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortConditionField;
import com.jxdinfo.hussar.formdesign.dm.result.DmCodeResult;
import com.jxdinfo.hussar.formdesign.dm.util.DmCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmModelProcessor
implements DataModelProcessor<DmCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(DmModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"DM", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<DmCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx = this.getDMBackCtx(publishCtx);
        DmModelProcessor.init(backCtx, dataModelBase);
        DmModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> getDMBackCtx(PublishCtx<DmCodeResult> publishCtx) {
        DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx = new DmBackCtx<DmDataModelBase, DmDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        return backCtx;
    }

    public static void init(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        DmModelFunction currentFunction = DmModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        DmDataModelBase currentModelBase = DmDataModelUtil.transfer(dataModelBase);
        List<DmSortCondition> sortConditions = currentModelBase.getSortCondition();
        if (HussarUtils.isNotEmpty(sortConditions)) {
            for (DmSortCondition sortCondition : sortConditions) {
                List<DmSortConditionField> sortConditionFields = sortCondition.getFields();
                for (DmSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
        }
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, DmDataModelBaseDTO> useDtoMap = new HashMap<String, DmDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, PublishCtx<DmCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DmModelProcessor.visit(backCtx);
        DmModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DmDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        DmDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        for (DmDataModelOperation operation : useDataModelBase.getOperations()) {
            DmOperationVisitor<DmDataModelBase, DmDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("DM", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            backCtx.getModelFunction().accept(visitor, backCtx, operation);
            backCtx.addApiResources(ApiResourceAcceptor.of((String)useDataModelBase.getId(), (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
    }

    public static void render(DmBackCtx<DmDataModelBase, DmDataModelBaseDTO> backCtx, PublishCtx<DmCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DmRender<DmDataModelBase, DmDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<DmCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(DmCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
    }
}

