/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.relationship.DmRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBase;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.constant.DmConstUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMMASTER_SLAVEFormSave")
public class DmMsFormSaveVisitor
implements DmOperationVisitor<DmMsDataModel, DmMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsFormSaveVisitor.class);
    public static final String OPERATION_NAME = "DMMASTER_SLAVEFormSave";

    @Override
    public void visit(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, DmDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO DMMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = DMMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        DmDataModelFieldDto keyField = DMMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", DMMsDataModelDTO);
        controllerParams.put("returnValue", DMMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        DmDataModelBaseDTO masterBaseDto = DMMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", masterBaseDto);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(DMMsDataModelDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/dm/masterslavebackcode/addorupdate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, DMMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, DMMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, DMMsDataModelDTO.getServiceName());
        String servicePath = "template/dm/masterslavebackcode/addorupdate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        String serviceImplPath = "template/dm/masterslavebackcode/addorupdate/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(DmBackCtx<DmMsDataModel, DmMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmMsDataModelDTO DMMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<DmRelationshipDTO> relationshipDtoList = DMMsDataModelDTO.getRelationshipDtoList();
        DmDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, DmDataModelBaseDTO> dataModelDtoMap = DMMsDataModelDTO.getDataModelDtoMap();
        DmDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(mainDataModelDto, DMMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            for (DmRelationshipDTO dmRelationshipDTO : relationshipDtoList) {
                List<DmRelationshipFieldDTO> dmRelationshipFieldDTOS;
                String slaveTableId = dmRelationshipDTO.getSlaveTableId();
                String relateModelType = dmRelationshipDTO.getRelateModelType();
                DmDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(slaveModelDto, DMMsDataModelDTO, false, mainDataModelDto);
                if (slaveFillCode != null) {
                    dmRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(dmRelationshipFieldDTOS = dmRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(DmDataModelBaseDTO dataModelBaseDTO, DmMsDataModelDTO msDataModelDTO, boolean isMs, DmDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (DmDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", DmConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", DmConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", DmConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/dm/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

