/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.masterslave.DmMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.masterslaveflow.util.DmFlowMsUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOW_MASTER_SLAVEFreeReject")
public class DmMsFlowFreeRejectCodeVisitor
implements DmOperationVisitor<DmFlowMsDataModel, DmFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmMsFlowFreeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "DMFLOW_MASTER_SLAVEFreeReject";

    @Override
    public void visit(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, DmDataModelOperation operation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        DmMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        DmFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = flowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        DmDataModelFieldDto keyField = flowMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", flowMsDataModelDTO);
        controllerParams.put("returnValue", flowMsDataModelDTO.getEntityName());
        controllerParams.put("flowDatasourceName", DmDataSourceUtil.getDefaultDataSourceName());
        controllerParams.put("parameter", flowMsDataModelDTO.getQueryDtoMap().get(flowMsDataModelDTO.getName()).getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(flowMsDataModelDTO.getComment() + "\u81ea\u7531\u9a73\u56de");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/dm/flowbackcode/masterslaveflowbackcode/freereject/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, flowMsDataModelDTO.getServiceName());
        String servicePath = "template/dm/flowbackcode/masterslaveflowbackcode/freereject/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        controllerParams.put("primaryField", keyField.getCapitalName());
        DmFlowMsUtil.renderMsInsertOrUpdate(controllerParams, backCtx);
        String serviceImplPath = "template/dm/flowbackcode/masterslaveflowbackcode/freereject/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, flowMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u81ea\u7531\u9a73\u56de");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmFlowMsDataModel, DmFlowMsDataModelDTO> backCtx, String modelId, DmMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
    }
}

