@Override
@HussarTransactional
public ApiResponse<String> ${name!}(String id){
    try{
        //调用操作业务数据的方法
        <#assign isSave = -1>
        <#assign idType ="id">
        <#assign getId ="Collections.singletonList(id)">
        <#include "../../../saveordel/saveordel.ftl">
        ${saveOrDel!}
        return ((${table.serviceName}) AopContext.currentProxy()).deleteProcessInstance(id);
    } catch(Exception e){
        throw new HussarException(e.getMessage());
    }

}

@Override
@HussarTransactional
public ApiResponse<String> ${name!}UnStart(String id){
    // 验证流程状态
    BpmResponseResult validateResult;
    try {
        validateResult = ((${table.serviceName}) AopContext.currentProxy()).getValidateResult(id);
        if (BpmConstant.SUCCESS_CODE.equals(validateResult.getCode())) {
            String state = validateResult.getResult().get(0) == null ? "" : validateResult.getResult().get(0).toString();
            switch (state) {
                //1 代表流程已经启动，并且节点处于第一节点，可以删除业务数据和流程数据
                case BpmConstant.SUCCESS_CODE:
                    // 删除业务数据
                    <#assign isSave = -1>
                    <#assign idType ="id">
                    <#assign getId ="Collections.singletonList(id)">
                    <#include "../../../saveordel/saveordel.ftl">
                    ${saveOrDel!}
                    // 删除流程数据
                    return ((${table.serviceName}) AopContext.currentProxy()).deleteProcessInstance(id);
                //2 代表流程已经启动，并且节点不处于第一节点，不可以删除业务数据和流程数据
                case "2":
                //3 代表流程已经结束，不可以删除业务数据和流程数据
                case "3":
                    <#--只有抛出异常才能阻止审计日志记录-->
                    <#--return ApiResponse.fail(validateResult.getMsg());-->
                    throw new HussarException(validateResult.getMsg());
                //0 代表流程没有启动，可以删除业务数据，不需要删除流程数据
                case "0":
                    // 删除业务数据
                    <#assign isSave = -1>
                    <#assign idType ="id">
                    <#assign getId ="Collections.singletonList(id)">
                    <#include "../../../saveordel/saveordel.ftl">
                    ${saveOrDel!}
                    return ApiResponse.success("");
                default:
                    return ApiResponse.fail("删除失败！");
            }
        }
        return ApiResponse.fail("删除失败！");
    } catch(Exception e) {
        throw new HussarException(e.getMessage());
    }
}

@Override
@HussarTransactional
@HussarDs("${flowDatasourceName!}")
public BpmResponseResult getValidateResult(String id) {
    ProcessStatusCheckDto processStatusCheckDto = new ProcessStatusCheckDto();
    processStatusCheckDto.setBusinessId(String.valueOf(id));
    processStatusCheckDto.setProcessInsId(null);
    BpmResponseResult bpmResponseResult =  standardInstanceEngineApiService.checkProcessStatus(processStatusCheckDto);
    return bpmResponseResult;
}

@Override
@HussarTransactional
@HussarDs("${flowDatasourceName!}")
public ApiResponse<String> deleteProcessInstance(String id) {
    BpmResponseResult bpmResponseResult;
    try {
        ProcessInstDeleteDto processInstDeleteDto = new ProcessInstDeleteDto();
        processInstDeleteDto.setProcessInsId(null);
        processInstDeleteDto.setBusinessId(String.valueOf(id));
        processInstDeleteDto.setReason(null);
        processInstDeleteDto.setIsFinish(false);
        bpmResponseResult =  standardInstanceEngineApiService.deleteProcessInstance(processInstDeleteDto);
        if (BpmConstant.SUCCESS_CODE.equals(bpmResponseResult.getCode())){
            return ApiResponse.success("");
        }
        throw new HussarException(bpmResponseResult.getMsg());
    } catch(Exception e){
        throw new HussarException(e.getMessage());
    }

}