/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.flow.DmFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.field.DmDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.visitor.flow.baseflow.util.DmFlowBaseUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMFLOWFreeReject")
public class DmFlowFreeRejectCodeVisitor
implements DmOperationVisitor<DmFlowDataModel, DmFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmFlowFreeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "DMFLOWFreeReject";

    @Override
    public void visit(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        DmDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        String controllerPath = "template/dm/flowbackcode/baseflowbackcode/freereject/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/flowbackcode/baseflowbackcode/freereject/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String fillCode = DmFlowBaseUtil.renderFillCode(dataModelBaseDTO);
        if (fillCode != null) {
            controllerParams.put("fillCode", fillCode);
        }
        String serviceImplPath = "template/dm/flowbackcode/baseflowbackcode/freereject/service_impl.ftl";
        backCtx.addServiceImplInversion(modelId, "StandardTaskEngineApiService");
        controllerParams.put("primaryField", keyField.getCapitalName());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u81ea\u7531\u9a73\u56de");
        backCtx.addApi(modelId, DmBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(DmBackCtx<DmFlowDataModel, DmFlowDataModelDTO> backCtx, String modelId, DmFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.upgrade.StandardTaskEngineApiService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("flowDatasourceName", DmDataSourceUtil.getDefaultDataSourceName());
        controllerParams.put("parameter", dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u81ea\u7531\u9a73\u56de");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

