/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.visitor.base;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.dm.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmOperationVisitor;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModel;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.DmQueryDTO;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.operation.DmDataModelOperation;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.querycondition.DmQueryConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortCondition;
import com.jxdinfo.hussar.formdesign.dm.function.modelentity.sortcondition.DmSortConditionField;
import com.jxdinfo.hussar.formdesign.dm.function.render.DmBaseRender;
import com.jxdinfo.hussar.formdesign.dm.util.DmDataModelUtil;
import com.jxdinfo.hussar.formdesign.dm.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.dm.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMBASETableQuery")
public class DmTableQueryVisitor
implements DmOperationVisitor<DmBaseDataModel, DmBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmTableQueryVisitor.class);
    public static final String OPERATION_NAME = "DMBASETableQuery";

    @Override
    public void visit(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, DmDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        DmBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        DmBaseDataModel dmBaseDataModel = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = dmBaseDataModel.getLogicallyDelete();
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isSortOverall")));
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, dmBaseDataModel, isSortOverall);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", dataModelBaseDTO.getFieldCapitalName(dmBaseDataModel.getDeleteFlag().getName()));
            controllerParams.put("deleteFlagName", dmBaseDataModel.getDeleteFlag().getSourceFieldName());
        }
        String controllerPath = "template/dm/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/dm/backcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/dm/backcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/dm/backcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/dm/backcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isLogicallyDelete, isSortOverall);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(controllerParams.get("name").toString(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + controllerParams.get("name").toString(), "\u67e5\u8be2");
        backCtx.addApi(modelId, DmBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, String modelId, DmBaseDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isLogicallyDelete, boolean isSortOverall) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else if (isSortCondition) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortCondition) {
            if (isPagination) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(DmDataModelOperation dataModelOperation, DmBaseDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelect(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, DmBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmBaseDataModel dmBaseDataModel = backCtx.getUseDataModelBase();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        DmQueryCondition queryCondition = dmBaseDataModel.getQuConBaseByName(selectConditionName);
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (DmQueryConditionField queryConditionField : queryCondition.getFields()) {
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(DmQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        controllerParams.put("isSelectCondition", true);
        DataSet dataSet = dmBaseDataModel.getDataSetById(queryCondition.getFromDataSet());
        if (dmBaseDataModel.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, dmBaseDataModel.getDeleteFlag().getName(), dmBaseDataModel.getId());
        }
        DmQueryDTO queryDTO = DmDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = "";
        finalWhereSql = dmBaseDataModel.getLogicallyDelete() ? QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>(), dmBaseDataModel.getDeleteFlag().getSourceFieldName()) : QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>());
        if (dmBaseDataModel.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("whereSql", finalWhereSql);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private boolean renderSort(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, DmDataModelOperation dataModelOperation, String modelId, Map<String, Object> templateParams, DmBaseDataModel useDataModelBase, boolean isSortOverall) throws LcdpException {
        DmSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(DmSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            if (!isSortOverall) {
                List<DmSortConditionField> sortConditionFields = sortCondition.getFields();
                for (DmSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            }
            templateParams.put("sortConditionObj", sortCondition);
            templateParams.put("isSortCondition", true);
            return true;
        }
        return false;
    }

    private void renderPageVo(DmBackCtx<DmBaseDataModel, DmBaseDataModelDTO> backCtx, String modelId, DmBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        DmDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + DmDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

