/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.dm.function.render;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.dm.code.DmCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.dm.ctx.DmBackCtx;
import com.jxdinfo.hussar.formdesign.dm.function.DmRender;
import com.jxdinfo.hussar.formdesign.dm.function.element.base.DmBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.dm.function.element.baseapi.DmBaseApiDataModel;
import com.jxdinfo.hussar.formdesign.dm.util.DmBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DMBASE_APIRENDER")
public class DmBaseApiRender
implements DmRender<DmBaseApiDataModel, DmBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DmBaseApiRender.class);
    public static final String RENDER = "DMBASE_APIRENDER";

    @Override
    public List<DmCodeGenerateInfo> renderCode(DmBackCtx<DmBaseApiDataModel, DmBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<DmCodeGenerateInfo> DmCodeGenerateInfos = new ArrayList<DmCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        DmBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        DmCodeGenerateInfos.add(this.genApiCode(dataModelBaseDTO, baseFile));
        return DmCodeGenerateInfos;
    }

    private DmCodeGenerateInfo genApiCode(DmBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = HussarUtils.isNotEmpty((Object)baseFile) && HussarUtils.equals((Object)"MobilePage", (Object)baseFile.getType()) ? "template/preview/api/api-mobile-file.ftl" : "template/preview/api/api-file.ftl";
        String newCode = DmBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DmCodeGenerateInfo codeGenerateInfo = new DmCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }
}

