/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.api.processor;

import com.google.common.collect.ImmutableList;
import com.jxdinfo.hussar.formdesign.api.code.ApiCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.api.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.api.function.model.ApiDataModelDTO;
import com.jxdinfo.hussar.formdesign.api.result.ApiCodeResult;
import com.jxdinfo.hussar.formdesign.api.util.ApiCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.api.util.ApiPublicEnclosure;
import com.jxdinfo.hussar.formdesign.api.util.ApiRenderUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModel;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModelOperation;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class ApiModelProcessor
implements DataModelProcessor<ApiCodeResult> {
    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"API", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<ApiCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException {
        ApiDataModelDTO dataModelDTO = this.buildParamsForGenerateApiCode(dataModelBase);
        ApiCodeGenerateInfo generateInfo = this.generateApiCode(dataModelDTO, publishCtx.getBaseFile());
        List<ApiCodeResult> mergeResult = this.merge(generateInfo, publishCtx.getBaseFile(), publishCtx.getParams());
        publishCtx.addCodeResults(mergeResult);
    }

    private ApiDataModelDTO buildParamsForGenerateApiCode(DataModelBase dataModelBase) throws LcdpException {
        ApiDataModel apiDataModel = (ApiDataModel)DataModelUtil.getDataModelObject((String)dataModelBase.getId(), ApiDataModel.class);
        ApiDataModelDTO dataModelDTO = ApiPublicEnclosure.enclosure(apiDataModel);
        dataModelDTO.setApis(this.generateApiRequestMethod(apiDataModel));
        dataModelDTO.setUrlPrefix(apiDataModel.getUrlPrefix());
        return dataModelDTO;
    }

    private List<String> generateApiRequestMethod(ApiDataModel dataModel) throws LcdpException {
        ArrayList<String> codes = new ArrayList<String>();
        for (ApiDataModelOperation operation : dataModel.getOperations()) {
            String prefix = "${PREFIX.name}";
            if (AppContextUtil.isExtension() && !dataModel.isExtension()) {
                prefix = "${PREFIX.standardName}";
            }
            ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", operation.getRequestMode(), operation.getUrl(), operation.getComment(), prefix);
            codes.add(ApiRenderUtil.renderTemplate(apiGenerateInfo));
        }
        return codes;
    }

    private ApiCodeGenerateInfo generateApiCode(ApiDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String requestCode = ApiRenderUtil.renderTemplate(dataModelDto, baseFile);
        return this.buildApiCodeGenerateInfo(dataModelDto.getId(), dataModelDto.getJsFilePath(), dataModelDto.getJsFileName(), requestCode);
    }

    private ApiCodeGenerateInfo buildApiCodeGenerateInfo(String modelId, String writePath, String fileName, String requestCode) {
        ApiCodeGenerateInfo codeGenerateInfo = new ApiCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(requestCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(modelId);
        codeGenerateInfo.setFileName(fileName);
        return codeGenerateInfo;
    }

    private List<ApiCodeResult> merge(ApiCodeGenerateInfo generateInfo, BaseFile baseFile, Map<String, Object> map) throws IOException, LcdpException {
        return ApiCodeMergeUtil.mergeBack((List<ApiCodeGenerateInfo>)ImmutableList.of((Object)((Object)generateInfo)), baseFile, map);
    }
}

