/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.api.util;

import com.jxdinfo.hussar.formdesign.api.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.api.function.model.ApiDataModelDTO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRenderUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ApiRenderUtil.class);

    public static String renderTemplate(ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("template/api/api-part.ftl");
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    public static String renderTemplate(String templatePath, ApiDataModelDTO dataModelDto) throws LcdpException {
        HashMap<String, ApiDataModelDTO> params = new HashMap<String, ApiDataModelDTO>(2);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    public static String renderTemplate(ApiDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String filePath = HussarUtils.isNotEmpty((Object)baseFile) && HussarUtils.equals((Object)"MobilePage", (Object)baseFile.getType()) ? "template/api/api-mobile-file.ftl" : "template/api/api-file.ftl";
        try {
            return ApiRenderUtil.renderTemplate(filePath, dataModelDto);
        }
        catch (LcdpException e) {
            LOGGER.error("\u6e32\u67d3API\uff1a{} \u5f02\u5e38", (Object)dataModelDto.getName());
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u6e32\u67d3API\u6587\u4ef6\u5f02\u5e38");
        }
    }
}

