/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.api.util;

import com.jxdinfo.hussar.formdesign.api.code.ApiCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.api.result.ApiCodeResult;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApiCodeMergeUtil {
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
    private static MicroAppInfoService microAppInfoService = (MicroAppInfoService)SpringContextUtil.getBean(MicroAppInfoService.class);
    private static ResourcePathService resourcePathService = (ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class);
    private static CodeMergeService codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class);
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private static final String CLIENT_TYPE = "publishIds";

    public static List<ApiCodeResult> mergeBack(List<ApiCodeGenerateInfo> codeGenerateInfos, BaseFile baseFile, Map<String, Object> params) throws IOException {
        ArrayList<ApiCodeResult> results = new ArrayList<ApiCodeResult>();
        if (ToolUtil.isNotEmpty(codeGenerateInfos)) {
            List<Object> publishIds = new ArrayList();
            if (null != Optional.ofNullable(params).orElseGet(HashMap::new).get(CLIENT_TYPE)) {
                publishIds = Arrays.asList(params.get(CLIENT_TYPE).toString().split(","));
            }
            for (ApiCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                if ("js".equals(codeGenerateInfo.getFileType()) && ToolUtil.isNotEmpty(publishIds)) {
                    for (String string : publishIds) {
                        results.add(ApiCodeMergeUtil.mergeBackCode(codeGenerateInfo, baseFile, string));
                    }
                    continue;
                }
                results.add(ApiCodeMergeUtil.mergeBackCode(codeGenerateInfo, baseFile, ""));
            }
        }
        return results;
    }

    private static ApiCodeResult mergeBackCode(ApiCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String publishId) throws IOException {
        PageInfo pageInfo;
        String absolutePath = resourcePathService.backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
        ApiCodeResult genCodeResult = new ApiCodeResult();
        genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
        ApiCodeMergeUtil.formatCode(codeGenerateInfo);
        if (!codeGenerateInfo.isCodeFormatSucceed()) {
            genCodeResult.setId(baseFile.getId());
            genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
            genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
            genCodeResult.setCodeFormatMessages(codeGenerateInfo.getCodeFormatMessages());
            genCodeResult.setCodeFormatMsg(codeGenerateInfo.getCodeFormatMsg());
            genCodeResult.setCodeFormatSucceed(codeGenerateInfo.isCodeFormatSucceed());
            return genCodeResult;
        }
        String mergeCode = "";
        String microAppId = "";
        if (baseFile instanceof PageInfo && ToolUtil.isNotEmpty((Object)(pageInfo = (PageInfo)baseFile)) && ToolUtil.isNotEmpty((Object)pageInfo.getMicroApp())) {
            microAppId = pageInfo.getMicroApp();
        }
        if (ToolUtil.isNotEmpty((Object)publishId) && !"WebPage".equals(publishId)) {
            microAppId = publishId;
        }
        String dataId = ApiCodeMergeUtil.getVersionFileKey(codeGenerateInfo);
        String cacheId = "";
        cacheId = HussarUtils.isNotEmpty((Object)baseFile) ? baseFile.getId() : codeGenerateInfo.getFileId();
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            String writeFile;
            Optional<String> currentCode;
            if ("js".equals(codeGenerateInfo.getFileType())) {
                String jsPath = ApiCodeMergeUtil.isWebPublish(baseFile, publishId) ? resourcePathService.webProjectApi(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath() : resourcePathService.mobileProjectApi(formDesignProperties.getMobProjectPath(), new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(jsPath));
            } else {
                String currentPath = resourcePathService.backProjectJava(new String[]{AppContextUtil.getAppBackCodePrefix(), codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(currentPath));
            }
            Optional<String> versionCode = Optional.ofNullable(versionManageService.getAncestorCodeById(dataId));
            Optional<String> lastFile = Optional.ofNullable(versionManageService.getLastFileCode(dataId));
            if (currentCode.isPresent() && versionCode.isPresent()) {
                MergeResult mergeResult = codeMergeService.textMerge(versionCode.get(), currentCode.get(), codeGenerateInfo.getFileContent(), lastFile.get(), false);
                if (mergeResult.isConflict()) {
                    genCodeResult.setExistConflict(true);
                    genCodeResult.setMergeCode(mergeResult.getMergedCode());
                    genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                    genCodeResult.setOriginCode(currentCode.get());
                    genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
                    genCodeResult.setLastPublish(mergeResult.getLastPublish());
                    genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                    genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                    genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                } else {
                    mergeCode = mergeResult.getMergedCode();
                }
                switch (codeGenerateInfo.getFileType()) {
                    case "controller": 
                    case "entity": 
                    case "service": 
                    case "serviceImpl": {
                        genCodeResult.setType("java");
                        break;
                    }
                    case "mapper": 
                    case "xml": {
                        genCodeResult.setType("xml");
                        break;
                    }
                    case "js": {
                        genCodeResult.setType("javascript");
                        break;
                    }
                }
            }
            String string = writeFile = ToolUtil.isEmpty((Object)mergeCode) ? codeGenerateInfo.getFileContent() : mergeCode;
            absolutePath = !genCodeResult.isExistConflict() ? ApiCodeMergeUtil.writeNoConflictCode(codeGenerateInfo, baseFile, publishId, absolutePath, microAppId, dataId, writeFile) : ("js".equals(codeGenerateInfo.getFileType()) ? (ApiCodeMergeUtil.isWebPublish(baseFile, publishId) ? resourcePathService.webProjectApi(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath() : resourcePathService.mobileProjectApi(formDesignProperties.getMobProjectPath(), new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath()) : resourcePathService.backProjectJava(new String[]{AppContextUtil.getAppBackCodePrefix(), codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath());
        }
        genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
        genCodeResult.setDataId(dataId);
        genCodeResult.setId(cacheId);
        return genCodeResult;
    }

    private static void formatCode(ApiCodeGenerateInfo codeGenerateInfo) {
        String fileType = codeGenerateInfo.getFileType();
        if (ToolUtil.isNotEmpty((Object)fileType) && ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity") || fileType.equals("vo")) {
                codeGenerateInfo.setFileContent(JavaCodeFormatUtil.format((String)codeGenerateInfo.getFileContent()));
            }
            if (fileType.equals("js")) {
                CodeFormatResult codeFormatResult = CodeFormatter.formatterHtml((String)codeGenerateInfo.getFileContent(), (String)"typescript");
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMsg(codeFormatResult.getMsg());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
        }
    }

    public static String writeNoConflictCode(ApiCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String publishId, String absolutePath, String microAppId, String dataId, String writeFile) throws IOException {
        String cacheId = "";
        cacheId = HussarUtils.isNotEmpty((Object)baseFile) ? baseFile.getId() : codeGenerateInfo.getFileId();
        if ("js".equals(codeGenerateInfo.getFileType())) {
            if (ApiCodeMergeUtil.isWebPublish(baseFile, publishId)) {
                absolutePath = filePublishService.writeWebApiCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), cacheId);
            } else {
                String apiPath = resourcePathService.mobileProjectApi(formDesignProperties.getMobProjectPath(), new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                absolutePath = filePublishService.writeIonicApiCode(writeFile, apiPath, cacheId);
            }
        } else {
            absolutePath = filePublishService.writeMVCCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), cacheId);
        }
        versionManageService.saveCacheLastPublishCode(dataId, codeGenerateInfo.getFileContent(), cacheId);
        versionManageService.saveCacheLastFileCode(dataId, writeFile, cacheId);
        return absolutePath;
    }

    private static boolean isWebPublish(BaseFile baseFile, String publishId) {
        String baseFileType = Optional.ofNullable(baseFile).map(BaseFile::getType).orElse("");
        return baseFile == null || "WebPage".equals(baseFile.getType()) || "Workflow".equals(baseFileType) || "WebPage".equals(publishId);
    }

    private static String getVersionFileKey(ApiCodeGenerateInfo codeGenerateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(codeGenerateInfo.getFileId());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getPageType()) && !"WebPage".equals(codeGenerateInfo.getPageType()) && !"MobilePage".equals(codeGenerateInfo.getPageType())) {
            stringBuilder.append(codeGenerateInfo.getPageType());
        }
        stringBuilder.append(codeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileName())) {
            stringBuilder.append(codeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }
}

