/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.api.function.model;

import com.jxdinfo.hussar.formdesign.api.function.model.ApiQueryDTO;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FormDesignStringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiDataModelDTO {
    private String id;
    private String name;
    private String dataSourceName;
    private String comment;
    private String desc;
    private String moduleName;
    private String modelPath;
    private String tablePath;
    private String parentTablePath;
    private String resultMapContent;
    private Map<String, DataSet> dataSetMap = new HashMap<String, DataSet>();
    private Map<String, ApiQueryDTO> queryDtoMap;
    private List<String> apis;
    private String urlPrefix;

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentTablePath() {
        return this.parentTablePath;
    }

    public void setParentTablePath(String parentTablePath) {
        this.parentTablePath = parentTablePath;
    }

    public String getResultMapContent() {
        return this.resultMapContent;
    }

    public void setResultMapContent(String resultMapContent) {
        this.resultMapContent = resultMapContent;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getModuleName() {
        return FormDesignStringUtil.underlineToCamel((String)this.moduleName);
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getTablePath() {
        return this.modelPath + "/" + this.name;
    }

    public String getJsFilePath() {
        return this.getTablePath().toLowerCase() + ".js";
    }

    public String getJsFileName() {
        return this.getName().toLowerCase() + ".js";
    }

    public String getEnName() {
        return FormDesignStringUtil.underlineToHump((String)this.name);
    }

    public String getApiPrefix() {
        String apiPrefix = this.tablePath;
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{"${PREFIX.name}", apiPrefix});
        }
        return "";
    }

    public Map<String, ApiQueryDTO> getQueryDtoMap() {
        return this.queryDtoMap;
    }

    public void setQueryDtoMap(Map<String, ApiQueryDTO> queryDtoMap) {
        this.queryDtoMap = queryDtoMap;
    }

    public void addQueryDto(ApiQueryDTO apiQueryDTO) {
        if (ToolUtil.isEmpty(this.queryDtoMap)) {
            this.queryDtoMap = new HashMap<String, ApiQueryDTO>();
        }
        this.queryDtoMap.put(apiQueryDTO.getName(), apiQueryDTO);
    }

    public void addDataSetMap(List<DataSet> dataSet) {
        if (ToolUtil.isNotEmpty(dataSet)) {
            this.dataSetMap = dataSet.stream().collect(Collectors.toMap(DataSet::getId, e -> e));
        }
    }

    public Map<String, DataSet> getDataSetMap() {
        return this.dataSetMap;
    }

    public void setDataSetMap(Map<String, DataSet> dataSetMap) {
        this.dataSetMap = dataSetMap;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public List<String> getApis() {
        return this.apis;
    }

    public void setApis(List<String> apis) {
        this.apis = apis;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public void addApi(String apiInfo) {
        if (ToolUtil.isEmpty(this.apis)) {
            this.apis = new ArrayList<String>();
        }
        this.apis.add(apiInfo);
    }

    public String toString() {
        return super.toString();
    }
}

