/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.external.facade.theme.model;

import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseFont;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseShadow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ThemeBaseConfig {
    private static final String FONT = "font";
    private static final String SHADOW = "shadow";
    private List<ThemeBaseFont> font;
    private List<ThemeBaseShadow> shadow;

    public List<ThemeBaseFont> getFont() {
        return this.font;
    }

    public void setFont(List<ThemeBaseFont> font) {
        this.font = font;
    }

    public List<ThemeBaseShadow> getShadow() {
        return this.shadow;
    }

    public void setShadow(List<ThemeBaseShadow> shadow) {
        this.shadow = shadow;
    }

    public Optional<Map<String, Object>> find(String type, String key) {
        switch (type) {
            case "font": {
                List themeBaseFonts = Optional.ofNullable(this.getFont()).orElseGet(ArrayList::new);
                for (ThemeBaseFont themeBaseFont : themeBaseFonts) {
                    Optional<Map<String, Object>> secondMatch;
                    Optional<Map<String, Object>> match = this.matchFonts(themeBaseFonts, key);
                    if (match.isPresent()) {
                        return match;
                    }
                    List<ThemeBaseFont> fieldGroups = themeBaseFont.getFontsGroup();
                    if (fieldGroups == null || fieldGroups.size() <= 0 || !(secondMatch = this.matchFonts(fieldGroups, key)).isPresent()) continue;
                    return secondMatch;
                }
                break;
            }
            case "shadow": {
                List themeBaseShadows = Optional.ofNullable(this.getShadow()).orElseGet(ArrayList::new);
                for (ThemeBaseShadow themeBaseShadow : themeBaseShadows) {
                    Optional<Map<String, Object>> secondMatch;
                    Optional<Map<String, Object>> match = this.matchShadows(themeBaseShadows, key);
                    if (match.isPresent()) {
                        return match;
                    }
                    List<ThemeBaseShadow> shadowsGroups = themeBaseShadow.getShadowsGroup();
                    if (shadowsGroups == null || shadowsGroups.size() <= 0 || !(secondMatch = this.matchShadows(shadowsGroups, key)).isPresent()) continue;
                    return secondMatch;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u5339\u914d\u5230\u5bf9\u5e94\u57fa\u7840\u6837\u5f0f\u5c5e\u6027" + type);
            }
        }
        return Optional.empty();
    }

    private Optional<Map<String, Object>> matchFonts(List<ThemeBaseFont> themeBaseFonts, String key) {
        for (ThemeBaseFont themeBaseFont : themeBaseFonts) {
            Map<String, Map<String, Object>> fonts = themeBaseFont.getFonts();
            if (fonts == null) continue;
            for (Map.Entry<String, Map<String, Object>> entry : fonts.entrySet()) {
                if (!entry.getKey().equals(key)) continue;
                return Optional.of(entry.getValue());
            }
        }
        return Optional.empty();
    }

    private Optional<Map<String, Object>> matchShadows(List<ThemeBaseShadow> themeBaseShadows, String key) {
        for (ThemeBaseShadow themeBaseShadow : themeBaseShadows) {
            Map<String, Map<String, Object>> shadows = themeBaseShadow.getShadows();
            if (shadows == null) continue;
            for (Map.Entry<String, Map<String, Object>> entry : shadows.entrySet()) {
                if (!entry.getKey().equals(key)) continue;
                return Optional.of(entry.getValue());
            }
        }
        return Optional.empty();
    }
}

