/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.external.facade.theme.model;

import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseFont;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ThemeBaseConfig {
    private static final String FONT = "font";
    private static final String SHADOW = "shadow";
    private List<ThemeBaseFont> font;

    public List<ThemeBaseFont> getFont() {
        return this.font;
    }

    public void setFont(List<ThemeBaseFont> font) {
        this.font = font;
    }

    public Optional<Map<String, Object>> find(String type, String key) {
        switch (type) {
            case "font": {
                List themeBaseFonts = Optional.ofNullable(this.getFont()).orElseGet(ArrayList::new);
                for (ThemeBaseFont themeBaseFont : themeBaseFonts) {
                    Optional<Map<String, Object>> secondMatch;
                    Optional<Map<String, Object>> match = this.match(themeBaseFonts, key);
                    if (match.isPresent()) {
                        return match;
                    }
                    List<ThemeBaseFont> fieldGroups = themeBaseFont.getFontsGroup();
                    if (fieldGroups == null || fieldGroups.size() <= 0 || !(secondMatch = this.match(fieldGroups, key)).isPresent()) continue;
                    return secondMatch;
                }
                break;
            }
            case "shadow": {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u5339\u914d\u5230\u5bf9\u5e94\u57fa\u7840\u6837\u5f0f\u5c5e\u6027" + type);
            }
        }
        return Optional.empty();
    }

    private Optional<Map<String, Object>> match(List<ThemeBaseFont> themeBaseFonts, String key) {
        for (ThemeBaseFont themeBaseFont : themeBaseFonts) {
            Map<String, Map<String, Object>> fonts = themeBaseFont.getFonts();
            if (fonts == null) continue;
            for (Map.Entry<String, Map<String, Object>> entry : fonts.entrySet()) {
                if (!entry.getKey().equals(key)) continue;
                return Optional.of(entry.getValue());
            }
        }
        return Optional.empty();
    }
}

