<el-select
        multiple
        @click.native="${instanceKey!}ClearInput"
        :class="{'is-disabled' : ${instanceKey!}Disabled}"
        @mouseenter.native="$refs.${instanceKey!}Ref.inputHovering = true" @mouseleave.native="$refs.${instanceKey!}Ref.inputHovering = false"
        <#if (isClearable?? && isClearable!)>
            clearable
        </#if>
        <#if (tabindex??)>
            tabindex="${tabindex!}"
        </#if>
        <#if (placeholder?? && placeholderType == "string")>
        placeholder="${placeholder}"
        <#elseif placeholderType == "newString">
        placeholder="${placeholderInter}"
        <#else>
        :placeholder="${placeholderInter}"
        </#if>
        <#if (allowCreate?? && allowCreate!)>
            allow-create default-first-option
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
        <#if isBlur?? && isBlur!>
            <#if select?? && multiple?? && select! && multiple!>
                @blur.native.capture="${instanceKey!}Blur"
            </#if>
        </#if>
        <#if loading?? && isBindData?? && loading! && isBindData!>
            :loading="${instanceKey!}Loading"
            :loading-text="${instanceKey!}LoadingText"
        </#if>
    >
    <div class="search-div">
        <el-input prefix-icon="el-icon-search" type="text" :placeholder="hussar_t({key: 'vfg.searchForOptions', fallbackStr: '搜索内容'})" clearable v-model="${instanceKey!}InputKey" @input="${instanceKey!}FilterSearch"></el-input>
    </div>
    <div class="search-div-empty" slot="empty" style="padding-top:5px">
        <el-input prefix-icon="el-icon-search" type="text" :placeholder="hussar_t({key: 'vfg.searchForOptions', fallbackStr: '搜索内容'})" clearable v-model="${instanceKey!}InputKey" @input="${instanceKey!}FilterSearch"></el-input>
        <p class="el-select-dropdown__empty">{{hussar_t({key: 'vfg.noDataAvailable', fallbackStr: '暂无数据'})}}</p>
    </div>
    <el-option-group
            v-for="group in ${instanceKey!}GroupOptions"
            :key="group.label"
            :label="group.label">
        <el-option v-for="option in group.options"
                   :label="option.${cusLabelToTemplate!}" :key="option.${cusValueToTemplate!}"  :value="option.${cusValueToTemplate!}" :title="option.${cusLabelToTemplate!}"></el-option>
    </el-option-group>
</el-select>
