/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.extendelement.JXDElDropdownBoxMultiSelectionSearch.value")
@Scope(value="prototype")
public class DropdownBoxMultiSelectSearchValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        Map<String, String> customParams = this.setParamValue(this.lcdpComponent);
        String customLabel = customParams.get("customLabel");
        String customValue = customParams.get("customValue");
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("label", customLabel);
        map.put("value", customValue);
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }

    public Map<String, String> setParamValue(LcdpComponent lcdpComponent) {
        Map maps = lcdpComponent.getProps();
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        String customLabel = "label";
        String customValue = "value";
        if (ToolUtil.isNotEmpty(maps.get("customLabel"))) {
            customLabel = String.valueOf(maps.get("customLabel"));
        }
        if (ToolUtil.isNotEmpty(maps.get("customValue"))) {
            customValue = String.valueOf(maps.get("customValue"));
        }
        customParams.put("customLabel", customLabel);
        customParams.put("customValue", customValue);
        return customParams;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        Map<String, String> customParams = this.setParamValue(this.lcdpComponent);
        String customLabel = customParams.get("customLabel");
        String customValue = customParams.get("customValue");
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            String relativeField = this.getRelativeDataField(dataItem, this.lcdpComponent);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getOptionData();
                }
                String data = dataItems.get(1);
                return this.getValueLabelData(data);
            }
            if ("value".equals(dataItem)) {
                return this.getValueData();
            }
            if ("checkdata".equals(dataItem)) {
                ComponentData labelData = new ComponentData();
                String valueData = this.getValueData().getRenderValue();
                labelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                labelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                String optionData = this.getOptionData().getRenderValue();
                if (dataItems.size() == 1) {
                    labelData.setRenderValue("function() {\nconst result = [];\nconst finalResult = [];\nfor (let i = 0, optionLen = " + optionData + ".length; i < optionLen; i++) { \nfor (let j = 0, valueLen = " + valueData + ".length;j < valueLen; j++) { \nif (" + optionData + "[i].value === " + valueData + "[j]) {\nresult.push(" + optionData + "[i]);\n}\n}\n}\nfor (let i = 0; i < result.length; i++) { \nfinalResult.push('{' + result[i]." + customLabel + "+ ',' + result[i]." + customValue + " + '}');\n}\nreturn finalResult; \n} ()");
                } else {
                    String dataItemValue = dataItems.get(1);
                    String relativeFieldValue = this.getRelativeDataField(dataItemValue, this.lcdpComponent);
                    if ("value".equals(dataItemValue)) {
                        return this.getValueData();
                    }
                    if ("label".equals(dataItemValue) || HussarUtils.isNotEmpty((Object)relativeFieldValue)) {
                        labelData.setRenderValue("function() {\n const result = [];\nfor(let i = 0,optionLen = " + optionData + ".length;i < optionLen;i++){\nfor(let j = 0,valueLen = " + valueData + ".length;j < valueLen;j++){\nif(" + optionData + "[i].value === " + valueData + "[j]){\nresult.push(" + optionData + "[i]." + (HussarUtils.isNotEmpty((Object)relativeFieldValue) ? relativeFieldValue : "label") + ");\n}\n}\n}\nreturn result;\n}()");
                    }
                }
                return labelData;
            }
            if ("label".equals(dataItem) || HussarUtils.isNotEmpty((Object)relativeField)) {
                ComponentData labelData = new ComponentData();
                labelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                labelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                String valueData = this.getValueData().getRenderValue();
                String optionData = this.getOptionData().getRenderValue();
                labelData.setRenderValue("function() {\n let result = [];\nfor(let i = 0,optionLen = " + optionData + ".length;i < optionLen;i++){\nfor(let j = 0,valueLen = " + valueData + ".length;j < valueLen;j++){\nif(" + optionData + "[i]." + customValue + "=== " + valueData + "[j]){\nresult.push(" + optionData + "[i]." + (HussarUtils.isNotEmpty((Object)relativeField) ? relativeField : customLabel) + ");\n}\n}\n}\nreturn result;\n}()");
                return labelData;
            }
        }
        return this.getValueData();
    }

    private String getRelativeDataField(String dataItem, LcdpComponent lcdpComponent) {
        String relativeField = "";
        JSONArray array = (JSONArray)lcdpComponent.getProps().get("relativeData");
        if (HussarUtils.isNotEmpty((Object)array)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String relativeId = String.valueOf(jsonObject.get((Object)"id"));
                if (!dataItem.equals(relativeId)) continue;
                relativeField = String.valueOf(jsonObject.get((Object)"field"));
                return relativeField;
            }
        }
        return relativeField;
    }

    public ComponentData getDefaultValueByDataItem(List<String> list) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> list) throws LcdpException {
        return null;
    }

    private ComponentData getOptionData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("data");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._OPTION.getType(), optionDataItem));
        return optionData;
    }

    private ComponentData getValueLabelData(String dataItem) throws LcdpException {
        Map<String, String> customParams = this.setParamValue(this.lcdpComponent);
        String customLabel = customParams.get("customLabel");
        String customValue = customParams.get("customValue");
        ComponentData data = new ComponentData();
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        String optionData = this.getOptionData().getRenderValue();
        if ("label".equals(dataItem)) {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i]." + customLabel + ");\n}\nreturn flag;}()");
        } else if ("value".equals(dataItem)) {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i]." + customValue + ");\n}\nreturn flag;}()");
        } else {
            String relativeField = this.getRelativeDataField(dataItem, this.lcdpComponent);
            if (ToolUtil.isNotEmpty((Object)relativeField)) {
                data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i]." + relativeField + ");\n}\nreturn flag;}()");
            }
        }
        return data;
    }

    private ComponentData getValueData() throws LcdpException {
        ComponentData valueData = new ComponentData();
        ArrayList<String> valueDataItem = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get("selectType")) && "number".equals(this.lcdpComponent.getProps().get("selectType"))) {
            valueData.setDataType(ComponentData.DataTypeEnum.INTEGER);
        } else {
            valueData.setDataType(ComponentData.DataTypeEnum.STRING);
        }
        valueDataItem.add("value");
        valueData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), valueDataItem));
        return valueData;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        QuoteBO quoteBO;
        ComponentData quoteData;
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, Collections.singletonList("value"));
        if (ComponentDataUtil.ComponentValueStatusEnum.QUOTE.equals((Object)dataItemValueStatus) && ToolUtil.isNotEmpty((Object)(quoteData = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)(quoteBO = ComponentDataUtil.getComponentDataItemQuote((LcdpComponent)this.lcdpComponent, Collections.singletonList("value"))).getComponentQuote())))) {
            return Collections.singletonList(new ComponentData(quoteData.getDataType(), ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
        }
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.ARRAY_PRIMARY, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }
}

