/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;

public class ExportImportUtil {
    public static void copyToDirectory(File srcDir, Predicate<String> filter, File destDir) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (!HussarUtils.isNotEmpty((Object)file.getPath()) || !filter.test(file.getPath())) continue;
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    public static void copyExToDirectory(File srcDir, String rootPath, Predicate<String> filter, File destDir) throws IOException {
        if (srcDir.exists() && srcDir.isDirectory()) {
            for (File file : Objects.requireNonNull(srcDir.listFiles())) {
                if (!HussarUtils.isNotEmpty((Object)file.getPath())) continue;
                if (file.isDirectory()) {
                    Object[] files = file.listFiles();
                    if (!HussarUtils.isNotEmpty((Object[])files)) continue;
                    for (Object chiLdFile : files) {
                        ExportImportUtil.copyExToDirectory((File)chiLdFile, rootPath, filter, destDir);
                    }
                    continue;
                }
                if (!filter.test(file.getPath())) continue;
                File destFile = new File(FileUtil.systemPath((String[])new String[]{destDir.getAbsolutePath()}), ExportImportUtil.subRelativePath(file.getName(), rootPath, file.getAbsolutePath()));
                FileUtils.copyFileToDirectory((File)file, (File)destFile);
            }
        } else {
            if (!srcDir.exists()) {
                return;
            }
            if (filter.test(srcDir.getPath())) {
                File destFile = new File(FileUtil.systemPath((String[])new String[]{destDir.getAbsolutePath()}), ExportImportUtil.subRelativePath(srcDir.getName(), rootPath, srcDir.getAbsolutePath()));
                FileUtils.copyFileToDirectory((File)srcDir, (File)destFile);
            }
        }
    }

    private static String subRelativePath(String fileName, String rootPath, String currentPath) {
        String path = currentPath.substring(rootPath.length());
        if (HussarUtils.isNotEmpty((Object)path)) {
            path = path.substring(0, path.length() - fileName.length());
        }
        return path;
    }
}

