/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.inducts.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.inducts.dao.InductsTableSqlMapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InductsTableSqlService {
    @Autowired
    private InductsTableSqlMapper inductsTableSqlMapper;
    @Autowired
    private SysDataSourceService sysDataSourceService;

    @HussarDs(value="#connName")
    @HussarTransactional
    public void generateSql(String connName, String sql) {
        String delFlag = "0";
        SysDataSource dataSource = (SysDataSource)this.sysDataSourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataSource::getConnName, (Object)connName)).eq(HussarDelflagEntity::getDelFlag, (Object)delFlag));
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return;
        }
        String dataSourceType = dataSource.getDriverClass();
        if (dataSourceType.equals("oracle.jdbc.OracleDriver") || dataSourceType.equals("dm.jdbc.driver.DmDriver")) {
            String[] split;
            CharSequence[] delimiters = new String[]{";\n", ";\r\n", ";", ";\r"};
            String regex = String.join((CharSequence)"|", delimiters);
            for (String s : split = sql.split(regex)) {
                if (!HussarUtils.isNotEmpty((Object)(s = s.trim()))) continue;
                this.inductsTableSqlMapper.generateSql(s);
            }
        } else {
            this.inductsTableSqlMapper.generateSql(sql);
        }
    }
}

