/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.inducts.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingCache;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.VuePathService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.datasource.FormDesignDataSource;
import com.jxdinfo.hussar.formdesign.datasource.IDataSource;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsProjectStoreService;
import com.jxdinfo.hussar.formdesign.inducts.model.ProjectStoreArgs;
import com.jxdinfo.hussar.formdesign.util.CodeRelocationUtil;
import com.jxdinfo.hussar.formdesign.util.ExportImportUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InductsProjectStoreServiceImpl
implements InductsProjectStoreService {
    @Autowired
    private IDataSource baseDataSourceService;
    @Autowired
    private PathStrategyService pathStrategy;
    @Autowired
    private H5PathStrategyService h5PathStrategyService;
    @Autowired
    private FilePublishService filePublishService;
    private static final String PREFIX_COMMON_JS = "prefixCommon.js";
    private static final String PREFIX_PATH = "/src/pages/index";

    public void handlerProjectStore(JSONObject projectStoreArgsJson) throws Exception {
        ProjectStoreArgs projectStoreArgs = (ProjectStoreArgs)JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectStoreArgsJson), ProjectStoreArgs.class);
        if (!projectStoreArgs.getAxeDir().exists()) {
            return;
        }
        ArrayList<File> publishFileList = new ArrayList<File>();
        ArrayList<File> codeFileList = new ArrayList<File>();
        this.getFiles(Objects.requireNonNull(projectStoreArgs.getAxeDir().listFiles()), "publish"::equals, publishFileList, suffix -> true);
        this.getFiles(Objects.requireNonNull(projectStoreArgs.getAxeDir().listFiles()), "code"::equals, codeFileList, suffix -> StringUtils.endsWith((CharSequence)suffix, (CharSequence)".meta"));
        CodeRelocationUtil.SourceType fileType = null;
        CodeRelocationUtil.Placement exportApp = this.getPlacement(projectStoreArgs.getExportApplicationSource().getAppName(), projectStoreArgs.getExportApplicationSource().getDsName(), projectStoreArgs.getExportApplicationSource().getJavaPath(), projectStoreArgs.getExportApplicationSource().getTenantId());
        exportApp.setDsId(Optional.ofNullable(this.baseDataSourceService.getDefaultByTenantCode(projectStoreArgs.getExportApplicationSource().getTenantId())).orElseGet(FormDesignDataSource::new).getDbId());
        CodeRelocationUtil.Placement importApp = this.getPlacement(projectStoreArgs.getImportApplicationSource().getAppName(), projectStoreArgs.getImportApplicationSource().getDsName(), projectStoreArgs.getImportApplicationSource().getJavaPath(), projectStoreArgs.getImportApplicationSource().getTenantId());
        importApp.setDsId(Optional.ofNullable(this.baseDataSourceService.getDefaultByTenantCode(projectStoreArgs.getImportApplicationSource().getTenantId())).orElseGet(FormDesignDataSource::new).getDbId());
        for (File publishFile : publishFileList) {
            CodeRelocationUtil.Result result;
            StringBuffer publishFileSuffix = new StringBuffer(publishFile.getParentFile().getName());
            fileType = StringUtils.endsWith((CharSequence)publishFileSuffix, (CharSequence)".java") || publishFile.getParentFile().getParentFile().getName().startsWith("key") ? CodeRelocationUtil.SourceType.JAVA : (StringUtils.endsWith((CharSequence)publishFileSuffix, (CharSequence)".xml") ? CodeRelocationUtil.SourceType.MAPPER : (StringUtils.endsWith((CharSequence)publishFileSuffix, (CharSequence)".js") ? CodeRelocationUtil.SourceType.JS : (publishFileSuffix.length() == 36 ? CodeRelocationUtil.SourceType.VUE : CodeRelocationUtil.SourceType.JAVA)));
            String content = FileUtils.readFileToString((File)publishFile, (Charset)StandardCharsets.UTF_8);
            if (HussarUtils.isNotEmpty((Object)projectStoreArgs.getReserveMap().get("serviceNameZip"))) {
                exportApp.setServiceName((String)projectStoreArgs.getReserveMap().get("serviceNameZip"));
                importApp.setServiceName((String)projectStoreArgs.getReserveMap().get("serviceNameZip"));
            }
            if (!(result = CodeRelocationUtil.relocate(fileType, content, exportApp, importApp, null)).isSuccess()) continue;
            PrintWriter out = new PrintWriter(publishFile.getPath());
            out.write(result.getContent().toCharArray());
            out.flush();
            out.close();
        }
        for (File codeFile : codeFileList) {
            PrintWriter out;
            File file;
            String content;
            CodeRelocationUtil.Result result;
            JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)codeFile, (Charset)StandardCharsets.UTF_8));
            if ("Workflow".equals(jsonObject.get((Object)"type")) && (result = CodeRelocationUtil.relocate(CodeRelocationUtil.SourceType.BPM_WFD, content = FileUtils.readFileToString((File)(file = new File(codeFile.getPath().replace(".meta", ""))), (Charset)StandardCharsets.UTF_8), exportApp, importApp, null)).isSuccess()) {
                out = new PrintWriter(file.getPath());
                out.write(result.getContent().toCharArray());
                out.flush();
                out.close();
            }
            if (!"DataModel".equals(jsonObject.get((Object)"type")) || !(result = CodeRelocationUtil.relocate(CodeRelocationUtil.SourceType.DBD, content = FileUtils.readFileToString((File)(file = new File(codeFile.getPath().replace(".meta", ""))), (Charset)StandardCharsets.UTF_8), exportApp, importApp, null)).isSuccess()) continue;
            out = new PrintWriter(file.getPath());
            out.write(result.getContent().toCharArray());
            out.flush();
            out.close();
        }
    }

    public void importProjectStore(String appId, String sourcePath) throws IOException {
        AppContextUtil.setAppId((String)appId);
        String rootPath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath();
        File rootFile = new File(rootPath);
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            return;
        }
        ExportImportUtil.copyToDirectory(sourceFile, path -> true, rootFile);
        FileMappingCache.fileMappingCacheEvict();
    }

    public void webPrefixCommon() {
        VuePathService vuePathService = this.pathStrategy.vuePathService();
        Map map = this.pathStrategy.vuePathService().prefixCommonParam();
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        String newCode = null;
        try {
            newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", (Map)map);
        }
        catch (LcdpException e) {
            throw new RuntimeException(e);
        }
        String filePath = this.webProject(vuePathService.posixFilePathPrefix(PREFIX_PATH, new String[]{PREFIX_COMMON_JS})).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        if (!new File(filePath).exists()) {
            this.filePublishService.writeStringToFile(newCode, filePath);
        }
    }

    public void h5PrefixCommon() {
        VuePathService vuePathService = this.pathStrategy.vuePathService();
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        map.put("name", this.h5PathStrategyService.h5PathService().getName());
        map.put("pathName", this.h5PathStrategyService.h5PathService().getPathName());
        String newCode = null;
        try {
            newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", map);
        }
        catch (LcdpException e) {
            throw new RuntimeException(e);
        }
        String filePath = this.mobileProject(vuePathService.posixFilePathPrefix(this.h5PathStrategyService.h5PathService().getFrontApiPath(), new String[]{PREFIX_COMMON_JS})).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        if (!new File(filePath).exists()) {
            this.filePublishService.writeStringToFile(newCode, filePath);
        }
    }

    private void getFiles(File[] files, Predicate<String> dirFilter, List<File> fileList, Predicate<String> fileFilter) {
        ArrayList<File> list = new ArrayList<File>();
        boolean isFind = false;
        for (File file : files) {
            if (file.isDirectory() && dirFilter.test(file.getName())) {
                this.findFile(Objects.requireNonNull(file.listFiles()), fileList, fileFilter);
                isFind = true;
                continue;
            }
            if (file.isDirectory()) {
                list.add(file);
                continue;
            }
            if (!file.isFile() || !fileFilter.test(file.getName())) continue;
            fileList.add(file);
        }
        if (list.size() > 0 && !isFind) {
            for (File f : list) {
                this.getFiles(Objects.requireNonNull(f.listFiles()), dirFilter, fileList, fileFilter);
            }
        }
    }

    private void findFile(File[] files, List<File> list, Predicate<String> fileFilter) {
        for (File file : files) {
            if (file.isDirectory()) {
                this.findFile(Objects.requireNonNull(file.listFiles()), list, fileFilter);
                continue;
            }
            if (!file.isFile() || !fileFilter.test(file.getName())) continue;
            list.add(file);
        }
    }

    private CodeRelocationUtil.Placement getPlacement(String appName, String dsName, String backPackagePrefix, String tenantCode) {
        CodeRelocationUtil.Placement placement = new CodeRelocationUtil.Placement();
        placement.setAppName(appName);
        placement.setDsName(dsName);
        placement.setBackPackagePrefix(backPackagePrefix);
        placement.setTenantCode(tenantCode);
        return placement;
    }

    private ResourcePath webProject(String ... pathSegments) {
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[0]);
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath mobileProject(String ... pathSegments) {
        String localPrefix = this.h5PathStrategyService.h5PathService().getMobileFrontProjectPath();
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

