/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.importcode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.ResourcePublishHandler;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.model.ApiResourceDTO;
import com.jxdinfo.hussar.formdesign.publish.model.ModuleNode;
import com.jxdinfo.hussar.formdesign.publish.model.PageResourceDTO;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishDataSource {
    @Autowired
    private PageInfoService pageInfoService;
    @Autowired
    private SysQuoteRelationService sysQuoteRelationService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private ResourcePublishHandler resourcePublishHandler;

    @HussarDs(value="#connName")
    public void resourceBatch(String connName, List<JSONObject> pageObjects) {
        for (JSONObject pageObject : pageObjects) {
            this.publishResource(pageObject.getString("id"));
        }
    }

    private void publishResource(String id) {
        try {
            PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
            String pageInfoDataJson = pageInfo.getData();
            JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
            boolean keepAlive = DynDataUtil.subscript((Object)pageInfoDataJsonObject, (Object[])new Object[]{"props", "isKeepAlive"}).flatMap(DynDataUtil::asBoolean).orElse(true);
            PageInfoNode pageInfoNode = this.pageInfoService.getPageInfoNodeFromPageToRoot(id);
            while (pageInfoNode.parent != null) {
                pageInfoNode = pageInfoNode.parent;
            }
            PublishDTO publishDTO = new PublishDTO();
            publishDTO.setExtensionId(AppContextUtil.getUnionPrefix());
            PageResourceDTO pageResourceDTO = new PageResourceDTO();
            pageResourceDTO.setPageId(pageInfo.getId());
            pageResourceDTO.setPageName(pageInfo.getName());
            pageResourceDTO.setPageLabel(pageInfo.getDesc());
            pageResourceDTO.setModuleNode(this.pageNodeToModule(pageInfoNode));
            publishDTO.setPage(pageResourceDTO);
            publishDTO.setApis(this.getApiResourceDTOList(pageInfo.getId()));
            Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setPublishDTO(publishDTO);
            this.resourcePublishHandler.createWebResource(pageInfo, strategy, keepAlive, publishCtx);
        }
        catch (LcdpException | IOException e) {
            e.printStackTrace();
        }
    }

    private List<ApiResourceDTO> getApiResourceDTOList(String pageId) throws LcdpException {
        ArrayList<ApiResourceDTO> apis = new ArrayList<ApiResourceDTO>();
        Optional<Object> modelIdListOpt = Optional.ofNullable(this.sysQuoteRelationService.getQuoteIdList(pageId, ToolUtil.firstToLower((String)"DataModel")).getData());
        if (modelIdListOpt.isPresent()) {
            for (String modelId : (List)modelIdListOpt.get()) {
                JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
                List operationList = ToolUtil.castListMap((Object)dataModelJson.get((Object)"operations"), String.class, Object.class);
                if (!ToolUtil.isNotEmpty((Object)operationList)) continue;
                for (Map map : operationList) {
                    ApiResourceDTO apiResourceDTO = new ApiResourceDTO();
                    apiResourceDTO.setApiId(String.valueOf(map.get("id")));
                    apis.add(apiResourceDTO);
                }
            }
        }
        return apis;
    }

    private ModuleNode pageNodeToModule(PageInfoNode pageInfoNode) {
        ModuleNode menuNode = new ModuleNode();
        menuNode.setModuleChName(pageInfoNode.cnName);
        menuNode.setModuleEnName(pageInfoNode.enName);
        menuNode.setModuleId(pageInfoNode.id);
        if (null != pageInfoNode.child) {
            menuNode.setChild(this.pageNodeToModule(pageInfoNode.child));
        }
        return menuNode;
    }
}

