/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.export.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.StorageDumpLoadService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.export.ExportProjectStoreService;
import com.jxdinfo.hussar.formdesign.util.ExportImportUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportProjectStoreServiceImpl
implements ExportProjectStoreService {
    @Autowired
    private PathStrategyService pathStrategy;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private StorageDumpLoadService storageDumpLoadService;
    private static final String ANCESTOR_STORE_RELATIVE_PATH = "/publish/version/ancestor";
    private static final String PUBLISH_RELATIVE_PATH = "/publish";

    public void export(String appId, String targetPath, boolean wpdFlag, boolean flowFlag, boolean publishFlag) throws IOException {
        AppContextUtil.setAppId((String)appId);
        String rootPath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath();
        File rootFile = new File(rootPath);
        File targetFile = new File(targetPath);
        if (!rootFile.exists()) {
            return;
        }
        String ancestorPath = FileUtil.systemPathByOldWay((String[])new String[]{rootPath, ANCESTOR_STORE_RELATIVE_PATH});
        String publishPath = FileUtil.systemPathByOldWay((String[])new String[]{rootPath, PUBLISH_RELATIVE_PATH});
        String projectCodePath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        if (publishFlag) {
            ExportImportUtil.copyToDirectory(rootFile, path -> this.checkPath((String)path, wpdFlag, flowFlag, ancestorPath, projectCodePath), targetFile);
        } else {
            ExportImportUtil.copyExToDirectory(rootFile, rootPath, path -> {
                try {
                    return this.checkExtensionPath((String)path, publishPath, projectCodePath);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, targetFile);
        }
    }

    private boolean checkPath(String path, boolean wpdFlag, boolean flowFlag, String publishPath, String projectCodePath) {
        boolean isExtend = AppContextUtil.isExtension();
        if (wpdFlag && flowFlag) {
            return path.startsWith(publishPath.substring(1)) && (isExtend || !path.contains(".ext"));
        }
        if (wpdFlag) {
            return !(path.startsWith(publishPath.substring(1)) || !isExtend && path.contains(".ext") || path.startsWith(projectCodePath.substring(1)) && !path.contains("dbd") && !path.contains("wpd") && !path.contains(".meta"));
        }
        if (flowFlag) {
            return !(!path.startsWith(publishPath.substring(1)) || !isExtend && path.contains(".ext") || path.startsWith(projectCodePath.substring(1)) && path.contains("wpd"));
        }
        return !(path.startsWith(publishPath.substring(1)) || !isExtend && path.contains(".ext") || path.startsWith(projectCodePath.substring(1)) && (!path.contains("dbd") && !path.contains("wpd") && !path.contains(".meta") || path.contains("wpd")));
    }

    private boolean checkExtensionPath(String path, String publishPath, String projectCodePath) throws IOException {
        boolean isExtend = AppContextUtil.isExtension();
        if (isExtend) {
            String content;
            JSONObject dbdObj;
            Object extension;
            boolean isExtensionDbd = false;
            File file = new File(path);
            if (file.exists() && path.endsWith(".dbd") && HussarUtils.isNotEmpty((Object)(extension = (dbdObj = JSONObject.parseObject((String)(content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8)))).get((Object)AppContextUtil.EXTENSION_SINGLE)))) {
                isExtensionDbd = (Boolean)extension;
            }
            return path.endsWith(".ext") || path.endsWith(".extend") || isExtensionDbd;
        }
        return !path.startsWith(publishPath);
    }

    public void exportOffLine(String appId, String targetPath) throws IOException {
        AppContextUtil.setAppId((String)appId);
        String rootPath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath();
        File rootFile = new File(rootPath);
        File targetFile = new File(targetPath);
        if (!rootFile.exists()) {
            return;
        }
        ExportImportUtil.copyToDirectory(rootFile, path -> true, targetFile);
    }
}

