/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.export.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.export.ExportTableService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportTableServiceImpl
implements ExportTableService {
    @Autowired
    private FileTreeService fileTreeService;
    @Autowired
    private DatasourceDataService dataSourceDataService;

    public List<JSONObject> resourceTree() throws IOException, LcdpException {
        ArrayList<JSONObject> tableStructs = new ArrayList<JSONObject>();
        this.parseTableInfo(tableStructs, new HashMap<String, String>());
        return tableStructs;
    }

    public Map<String, String> exportTables(String tableInfoStr) throws IOException, LcdpException {
        List tableInfoS = ToolUtil.stringToList((String)tableInfoStr);
        HashSet<String> tableInfoSet = new HashSet<String>(tableInfoS);
        HashMap<String, String> sourceTableMap = new HashMap<String, String>();
        this.parseTableInfo(sourceTableMap, tableInfoSet);
        return sourceTableMap;
    }

    public Map<String, String> exportTables() throws IOException, LcdpException {
        HashMap<String, String> sourceTableMap = new HashMap<String, String>();
        this.parseTableInfo(new ArrayList<JSONObject>(), sourceTableMap);
        return sourceTableMap;
    }

    public void parseTableInfo(List<JSONObject> tableStructs, Map<String, String> sourceTableMap) throws IOException, LcdpException {
        HashMap<String, Set> tableNameMap = new HashMap<String, Set>();
        FormDesignResponse fileTree = this.fileTreeService.getFileTree("#");
        List fileTreeData = (List)fileTree.getData();
        if (HussarUtils.isEmpty((Object)fileTreeData)) {
            return;
        }
        for (JSONObject fileTreeDatum : fileTreeData) {
            Object dataSourceName;
            JSONObject data;
            String functionType;
            if (!"DataModel".equals(fileTreeDatum.get((Object)"type")) || (functionType = (data = (JSONObject)fileTreeDatum.get((Object)"data")).getString("functionType")) == null || HussarUtils.isEmpty((Object)(dataSourceName = data.getString("dataSourceName")))) continue;
            ArrayList<String> tableNames = new ArrayList<String>();
            switch (functionType) {
                case "TASK": {
                    JSONObject task = (JSONObject)data.get((Object)"task");
                    String taskTableName = task.getString("sourceDataModelName");
                    tableNames.add(taskTableName);
                }
                case "BASE": 
                case "FLOW": {
                    String baseTableName = data.getString("sourceDataModelName");
                    tableNames.add(baseTableName);
                    break;
                }
                case "TASK_MASTER_SLAVE": {
                    JSONObject msTask = (JSONObject)data.get((Object)"task");
                    String msTaskTableName = msTask.getString("sourceDataModelName");
                    tableNames.add(msTaskTableName);
                }
                case "MASTER_SLAVE": 
                case "FLOW_MASTER_SLAVE": {
                    JSONObject masterTable = (JSONObject)data.get((Object)"masterTable");
                    String masterTableName = masterTable.getString("sourceDataModelName");
                    tableNames.add(masterTableName);
                    for (JSONObject slaveTable : (List)data.get((Object)"slaveTables")) {
                        String slaveTableName = slaveTable.getString("sourceDataModelName");
                        tableNames.add(slaveTableName);
                    }
                    break;
                }
            }
            Set tableNameSet = tableNameMap.computeIfAbsent((String)dataSourceName, k -> new HashSet());
            tableNameSet.addAll(tableNames);
        }
        for (String dataSourceName : tableNameMap.keySet()) {
            List<TableInfo> tableInfoList = this.getTableInfoList(dataSourceName);
            HashMap<String, TableInfo> sysTableNameMap = new HashMap<String, TableInfo>();
            for (TableInfo tableInfo : tableInfoList) {
                String name = tableInfo.getName();
                if (!HussarUtils.isNotEmpty((Object)name) || name.startsWith("SYS_")) continue;
                sysTableNameMap.put(name, tableInfo);
            }
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            for (String tableName : (Set)tableNameMap.get(dataSourceName)) {
                if (!sysTableNameMap.containsKey(tableName) && !sysTableNameMap.containsKey(tableName.toLowerCase())) continue;
                JSONObject tableStruct = new JSONObject();
                tableStruct.put("datasource", (Object)dataSourceName);
                tableStruct.put("name", (Object)tableName);
                tableStruct.put("type", (Object)"DataModel");
                tableStructs.add(tableStruct);
                tableInfos.add(ToolUtil.isNotEmpty(sysTableNameMap.get(tableName)) ? (TableInfo)sysTableNameMap.get(tableName) : (TableInfo)sysTableNameMap.get(tableName.toLowerCase()));
            }
            sourceTableMap.put(dataSourceName, JSONObject.toJSONString(tableInfos));
        }
    }

    public void parseTableInfo(Map<String, String> sourceTableMap, Set<String> tableInfoSet) throws IOException, LcdpException {
        HashMap<String, Set> tableNameMap = new HashMap<String, Set>();
        FormDesignResponse fileTree = this.fileTreeService.getFileTree("#");
        List fileTreeData = (List)fileTree.getData();
        if (HussarUtils.isEmpty((Object)fileTreeData)) {
            return;
        }
        for (JSONObject fileTreeDatum : fileTreeData) {
            Object dataSourceName;
            JSONObject data;
            String functionType;
            if (!"DataModel".equals(fileTreeDatum.get((Object)"type")) || HussarUtils.isEmpty((Object)(functionType = (data = (JSONObject)fileTreeDatum.get((Object)"data")).getString("functionType"))) || HussarUtils.isEmpty((Object)(dataSourceName = data.getString("dataSourceName")))) continue;
            ArrayList<String> tableNames = new ArrayList<String>();
            switch (functionType) {
                case "TASK": {
                    JSONObject task = (JSONObject)data.get((Object)"task");
                    String taskTableName = task.getString("sourceDataModelName");
                    tableNames.add(taskTableName);
                }
                case "BASE": 
                case "FLOW": {
                    String baseTableName = data.getString("sourceDataModelName");
                    tableNames.add(baseTableName);
                    break;
                }
                case "TASK_MASTER_SLAVE": {
                    JSONObject msTask = (JSONObject)data.get((Object)"task");
                    String msTaskTableName = msTask.getString("sourceDataModelName");
                    tableNames.add(msTaskTableName);
                }
                case "MASTER_SLAVE": 
                case "FLOW_MASTER_SLAVE": {
                    JSONObject masterTable = (JSONObject)data.get((Object)"masterTable");
                    String masterTableName = masterTable.getString("sourceDataModelName");
                    tableNames.add(masterTableName);
                    for (JSONObject slaveTable : (List)data.get((Object)"slaveTables")) {
                        String slaveTableName = slaveTable.getString("sourceDataModelName");
                        tableNames.add(slaveTableName);
                    }
                    break;
                }
            }
            Set tableNameSet = tableNameMap.computeIfAbsent((String)dataSourceName, k -> new HashSet());
            tableNameSet.addAll(tableNames);
        }
        for (String dataSourceName : tableNameMap.keySet()) {
            List<TableInfo> tableInfoList = this.getTableInfoList(dataSourceName);
            HashMap<String, TableInfo> sysTableNameMap = new HashMap<String, TableInfo>();
            for (TableInfo tableInfo : tableInfoList) {
                String name = tableInfo.getName();
                if (!HussarUtils.isNotEmpty((Object)name) || name.startsWith("sys_")) continue;
                sysTableNameMap.put(name, tableInfo);
            }
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            for (String tableName : (Set)tableNameMap.get(dataSourceName)) {
                if (!sysTableNameMap.containsKey(tableName) && !sysTableNameMap.containsKey(tableName.toLowerCase()) || !tableInfoSet.contains(tableName) && !tableInfoSet.contains(tableName.toLowerCase())) continue;
                tableInfos.add(ToolUtil.isNotEmpty(sysTableNameMap.get(tableName)) ? (TableInfo)sysTableNameMap.get(tableName) : (TableInfo)sysTableNameMap.get(tableName.toLowerCase()));
            }
            sourceTableMap.put(dataSourceName, JSONObject.toJSONString(tableInfos));
        }
    }

    private List<TableInfo> getTableInfoList(String dataSourceName) throws IOException, LcdpException {
        DatasourceConfigDTO datasourceConfigDTO = DataModelUtil.getDataSourceConfigByName((String)dataSourceName);
        if (null == datasourceConfigDTO.getId()) {
            dataSourceName = BaseSecurityUtil.getUser().getConnName();
            if (ToolUtil.isEmpty((Object)dataSourceName)) {
                dataSourceName = "master";
            }
            datasourceConfigDTO = DataModelUtil.getDataSourceConfigByName((String)dataSourceName);
        }
        return this.dataSourceDataService.getTableInfoById(datasourceConfigDTO.getId(), "BASE TABLE TASK");
    }
}

