/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.export.impl;

import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.StorageDumpLoadService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.export.ExportProjectStoreService;
import com.jxdinfo.hussar.formdesign.util.ExportImportUtil;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportProjectStoreServiceImpl
implements ExportProjectStoreService {
    @Autowired
    private PathStrategyService pathStrategy;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private StorageDumpLoadService storageDumpLoadService;
    private static final String ANCESTOR_STORE_RELATIVE_PATH = "/publish/version/ancestor";

    public void export(String appId, String targetPath, boolean wpdFlag, boolean flowFlag) throws IOException {
        AppContextUtil.setAppId((String)appId);
        String rootPath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath();
        File rootFile = new File(rootPath);
        File targetFile = new File(targetPath);
        if (!rootFile.exists()) {
            return;
        }
        String publishPath = FileUtil.systemPathByOldWay((String[])new String[]{rootPath, ANCESTOR_STORE_RELATIVE_PATH});
        String projectCodePath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
        if (wpdFlag && flowFlag) {
            ExportImportUtil.copyToDirectory(rootFile, path -> path.startsWith(publishPath.substring(1)), targetFile);
        } else if (wpdFlag) {
            ExportImportUtil.copyToDirectory(rootFile, path -> !path.startsWith(publishPath.substring(1)) && (!path.startsWith(projectCodePath.substring(1)) || path.contains("dbd") || path.contains("wpd") || path.contains(".meta")), targetFile);
        } else if (flowFlag) {
            ExportImportUtil.copyToDirectory(rootFile, path -> !path.startsWith(publishPath.substring(1)) && (!path.startsWith(projectCodePath.substring(1)) || !path.contains("wpd")), targetFile);
        } else {
            ExportImportUtil.copyToDirectory(rootFile, path -> !path.startsWith(publishPath.substring(1)) && (!path.startsWith(projectCodePath.substring(1)) || (path.contains("dbd") || path.contains("wpd") || path.contains(".meta")) && !path.contains("wpd")), targetFile);
        }
    }

    public void exportOffLine(String appId, String targetPath) throws IOException {
        AppContextUtil.setAppId((String)appId);
        String rootPath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath();
        File rootFile = new File(rootPath);
        File targetFile = new File(targetPath);
        if (!rootFile.exists()) {
            return;
        }
        ExportImportUtil.copyToDirectory(rootFile, path -> true, targetFile);
    }
}

