/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.commons.text.translate.NumericEntityEscaper;
import org.apache.commons.text.translate.UnicodeUnpairedSurrogateRemover;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public class CodeRelocationUtil {
    public static Result relocate(SourceType type, String content, Placement source, Placement target, Options options) {
        return CodeRelocationUtil.internalRelocate(type, content, source, target, options);
    }

    private static Result internalRelocate(SourceType type, String content, Placement source, Placement target, Options options) {
        if (type == null || content == null || source == null || target == null) {
            throw new NullPointerException();
        }
        if (options == null) {
            options = Options.defaultOptions();
        }
        Context ctx = new Context(type, content, source, target, options);
        try {
            Processor processor = Processor.factory(ctx);
            String relocated = processor.process(ctx);
            return ctx.result(relocated);
        }
        catch (RelocationException e) {
            ctx.printError("%s", e.getMessage());
            return ctx.result(null);
        }
    }

    private static class EscapeUtil {
        private static final String QUOTE = "\"";
        private static final String APOS = "'";
        private static final String TILDE = "`";
        private static final CharSequenceTranslator ESCAPE_JAVA;
        private static final CharSequenceTranslator ESCAPE_JS_APOS;
        private static final CharSequenceTranslator ESCAPE_JS_QUOTE;
        private static final CharSequenceTranslator ESCAPE_JS_TILDE;
        private static final CharSequenceTranslator ESCAPE_XML_ATTRIBUTE;
        private static final CharSequenceTranslator ESCAPE_XML_TEXT;

        private EscapeUtil() {
        }

        public static String jsStringUnescape(String literal) {
            String inner;
            if (literal.startsWith(APOS)) {
                if (!literal.endsWith(APOS)) {
                    throw new RelocationException("illegal javascript string: " + literal);
                }
                inner = StringUtils.removeEnd((String)StringUtils.removeStart((String)literal, (String)APOS), (String)APOS);
            } else if (literal.startsWith(QUOTE)) {
                if (!literal.endsWith(QUOTE)) {
                    throw new RelocationException("illegal javascript string: " + literal);
                }
                inner = StringUtils.removeEnd((String)StringUtils.removeStart((String)literal, (String)QUOTE), (String)QUOTE);
            } else {
                if (!literal.startsWith(TILDE) || !literal.endsWith(TILDE)) {
                    throw new RelocationException("illegal javascript string: " + literal);
                }
                inner = StringUtils.removeEnd((String)StringUtils.removeStart((String)literal, (String)TILDE), (String)TILDE);
            }
            return StringEscapeUtils.unescapeJson((String)inner);
        }

        public static String jsStringEscape(String value, boolean apos, boolean tilde) {
            if (apos) {
                return APOS + ESCAPE_JS_APOS.translate((CharSequence)value) + APOS;
            }
            if (tilde) {
                return TILDE + ESCAPE_JS_TILDE.translate((CharSequence)value) + TILDE;
            }
            return QUOTE + ESCAPE_JS_QUOTE.translate((CharSequence)value) + QUOTE;
        }

        public static String javaStringUnescape(String literal) {
            if (!literal.startsWith(QUOTE) || !literal.endsWith(QUOTE)) {
                throw new RelocationException("illegal java string: " + literal);
            }
            String inner = StringUtils.removeEnd((String)StringUtils.removeStart((String)literal, (String)QUOTE), (String)QUOTE);
            return StringEscapeUtils.unescapeJava((String)inner);
        }

        public static String javaStringEscape(String value) {
            return QUOTE + ESCAPE_JAVA.translate((CharSequence)value) + QUOTE;
        }

        public static String xmlAttributeUnescape(String literal) {
            String inner;
            if (literal.startsWith(QUOTE)) {
                if (!literal.endsWith(QUOTE)) {
                    throw new RelocationException("illegal xml attribute: " + literal);
                }
                inner = StringUtils.removeEnd((String)StringUtils.removeStart((String)literal, (String)QUOTE), (String)QUOTE);
            } else if (literal.startsWith(APOS)) {
                if (!literal.endsWith(APOS)) {
                    throw new RelocationException("illegal xml attribute: " + literal);
                }
                inner = StringUtils.removeEnd((String)StringUtils.removeStart((String)literal, (String)APOS), (String)APOS);
            } else {
                inner = literal;
            }
            return StringEscapeUtils.unescapeXml((String)inner);
        }

        public static String xmlAttributeEscape(String value) {
            return QUOTE + ESCAPE_XML_ATTRIBUTE.translate((CharSequence)value) + QUOTE;
        }

        public static String xmlTextUnescape(String literal) {
            return StringEscapeUtils.unescapeXml((String)literal);
        }

        public static String xmlTextEscape(String value) {
            return ESCAPE_XML_TEXT.translate((CharSequence)value);
        }

        static {
            HashMap<String, String> escapeJavaMap = new HashMap<String, String>();
            escapeJavaMap.put(QUOTE, "\\\"");
            escapeJavaMap.put("\\", "\\\\");
            ESCAPE_JAVA = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJavaMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.below((int)32), JavaUnicodeEscaper.between((int)127, (int)127), JavaUnicodeEscaper.between((int)128, (int)159)});
            HashMap<String, String> escapeJsAposMap = new HashMap<String, String>();
            escapeJsAposMap.put(APOS, "\\'");
            escapeJsAposMap.put("\\", "\\\\");
            ESCAPE_JS_APOS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJsAposMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.below((int)32), JavaUnicodeEscaper.between((int)127, (int)127), JavaUnicodeEscaper.between((int)128, (int)159)});
            HashMap<String, String> escapeJsQuoteMap = new HashMap<String, String>();
            escapeJsQuoteMap.put(QUOTE, "\\\"");
            escapeJsQuoteMap.put("\\", "\\\\");
            ESCAPE_JS_QUOTE = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJsQuoteMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.below((int)32), JavaUnicodeEscaper.between((int)127, (int)127), JavaUnicodeEscaper.between((int)128, (int)159)});
            HashMap<String, String> escapeJsTildeMap = new HashMap<String, String>();
            escapeJsTildeMap.put(TILDE, "\\`");
            escapeJsTildeMap.put("\\", "\\\\");
            ESCAPE_JS_TILDE = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJsTildeMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.below((int)32), JavaUnicodeEscaper.between((int)127, (int)127), JavaUnicodeEscaper.between((int)128, (int)159)});
            HashMap<String, String> escapeXmlAttributeMap = new HashMap<String, String>();
            escapeXmlAttributeMap.put(QUOTE, "&quot;");
            escapeXmlAttributeMap.put("&", "&amp;");
            escapeXmlAttributeMap.put("<", "&lt;");
            escapeXmlAttributeMap.put(">", "&gt;");
            escapeXmlAttributeMap.put("\u0000", "");
            escapeXmlAttributeMap.put("\u000b", "&#11;");
            escapeXmlAttributeMap.put("\f", "&#12;");
            escapeXmlAttributeMap.put("\ufffe", "");
            escapeXmlAttributeMap.put("\uffff", "");
            ESCAPE_XML_ATTRIBUTE = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeXmlAttributeMap)), NumericEntityEscaper.between((int)1, (int)8), NumericEntityEscaper.between((int)14, (int)31), NumericEntityEscaper.between((int)127, (int)132), NumericEntityEscaper.between((int)134, (int)159), new UnicodeUnpairedSurrogateRemover()});
            HashMap<String, String> escapeXmlTextMap = new HashMap<String, String>();
            escapeXmlTextMap.put("&", "&amp;");
            escapeXmlTextMap.put("<", "&lt;");
            escapeXmlTextMap.put(">", "&gt;");
            escapeXmlTextMap.put("\u0000", "");
            escapeXmlTextMap.put("\u000b", "&#11;");
            escapeXmlTextMap.put("\f", "&#12;");
            escapeXmlTextMap.put("\ufffe", "");
            escapeXmlTextMap.put("\uffff", "");
            ESCAPE_XML_TEXT = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeXmlTextMap)), NumericEntityEscaper.between((int)1, (int)8), NumericEntityEscaper.between((int)14, (int)31), NumericEntityEscaper.between((int)127, (int)132), NumericEntityEscaper.between((int)134, (int)159), new UnicodeUnpairedSurrogateRemover()});
        }
    }

    private static class BpmWorkflowTableJsonProcessor
    implements Processor {
        private static final String FIELD_FILE = "file";
        private static final String FIELD_TENANT_ID = "tenantId";
        private static final String FIELD_CONTENT = "content";

        private BpmWorkflowTableJsonProcessor() {
        }

        @Override
        public String process(Context ctx) {
            String original = ctx.getOriginal();
            try {
                JSONObject json = JSONObject.parseObject((String)original);
                if (json == null) {
                    return original;
                }
                if (json.get((Object)FIELD_FILE) instanceof JSONArray) {
                    JSONArray files = (JSONArray)json.get((Object)FIELD_FILE);
                    for (Object file : files) {
                        if (!(file instanceof JSONObject)) continue;
                        JSONObject record = (JSONObject)file;
                        if (record.get((Object)FIELD_TENANT_ID) instanceof String) {
                            String sourceTenantCode = this.tenantCode(ctx.getSource());
                            String targetTenantCode = this.tenantCode(ctx.getTarget());
                            if (Objects.equals(record.get((Object)FIELD_TENANT_ID), sourceTenantCode)) {
                                record.put(FIELD_TENANT_ID, (Object)targetTenantCode);
                            }
                        }
                        if (!(record.get((Object)FIELD_CONTENT) instanceof String)) continue;
                        String content = this.fromBase64((String)record.get((Object)FIELD_CONTENT));
                        Result result = CodeRelocationUtil.internalRelocate(SourceType.BPM_WFD, content, ctx.getSource(), ctx.getTarget(), ctx.getOptions());
                        if (!result.isSuccess() || result.getContent() == null) {
                            throw new RelocationException("failed to rewrite bpm wfd inside bpm workflow table json: " + result);
                        }
                        String encoded = this.toBase64(result.getContent());
                        record.put(FIELD_CONTENT, (Object)encoded);
                    }
                }
                return JSONObject.toJSONString((Object)json);
            }
            catch (JSONException e) {
                ctx.printWarn("failed to handle json when rewrite bpm workflow table json: " + (Object)((Object)e), new Object[0]);
                return original;
            }
        }

        private String tenantCode(Placement placement) {
            if (placement.getTenantCode() == null) {
                throw new RelocationException("missing tenantCode");
            }
            return placement.getTenantCode();
        }

        private String fromBase64(String content) {
            try {
                byte[] decoded = Base64.getDecoder().decode(content.getBytes(StandardCharsets.UTF_8));
                return new String(decoded, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                throw new RelocationException("invalid base64: " + e);
            }
        }

        private String toBase64(String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            byte[] encoded = Base64.getEncoder().encode(bytes);
            return new String(encoded, StandardCharsets.UTF_8);
        }
    }

    private static class BpmXmlFromKeyJsonAttributeRewriter
    implements Rewriter {
        private BpmXmlFromKeyJsonAttributeRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.BPM_FORM_KEY_ATTRIBUTE) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.xmlAttributeUnescape(literal);
                String rewrite = BpmXmlFromKeyJsonAttributeRewriter.rewriteJson(ctx, value);
                if (rewrite != null) {
                    return EscapeUtil.xmlAttributeEscape(rewrite);
                }
                return literal;
            }
            return null;
        }

        private static String rewriteJson(Context ctx, String json) {
            String sourcePrefix = BpmXmlFromKeyJsonAttributeRewriter.getPrefix(ctx.getSource());
            String targetPrefix = BpmXmlFromKeyJsonAttributeRewriter.getPrefix(ctx.getTarget());
            try {
                JSONObject formKey = JSONObject.parseObject((String)json);
                if (formKey == null) {
                    return null;
                }
                for (Map.Entry entry : formKey.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    String value = (String)entry.getValue();
                    if (value.startsWith(sourcePrefix)) {
                        entry.setValue(targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix));
                        continue;
                    }
                    if (!value.startsWith("/" + sourcePrefix)) continue;
                    entry.setValue("/" + targetPrefix + StringUtils.removeStart((String)value, (String)("/" + sourcePrefix)));
                }
                return JSONObject.toJSONString((Object)formKey);
            }
            catch (JSONException e) {
                ctx.printWarn("failed to handle json when rewrite bpm xml form key: " + (Object)((Object)e), new Object[0]);
                return null;
            }
        }

        private static String getPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName()), "/"});
        }
    }

    private static class BpmXmlFromDetailKeyJsonAttributeRewriter
    implements Rewriter {
        private BpmXmlFromDetailKeyJsonAttributeRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.BPM_FORM_DETAIL_KEY_ATTRIBUTE) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.xmlAttributeUnescape(literal);
                String rewrite = BpmXmlFromDetailKeyJsonAttributeRewriter.rewriteJson(ctx, value);
                if (rewrite != null) {
                    return EscapeUtil.xmlAttributeEscape(rewrite);
                }
                return literal;
            }
            return null;
        }

        private static String rewriteJson(Context ctx, String json) {
            String sourcePrefix = BpmXmlFromDetailKeyJsonAttributeRewriter.getPrefix(ctx.getSource());
            String targetPrefix = BpmXmlFromDetailKeyJsonAttributeRewriter.getPrefix(ctx.getTarget());
            try {
                JSONObject formKey = JSONObject.parseObject((String)json);
                if (formKey == null) {
                    return null;
                }
                for (Map.Entry entry : formKey.entrySet()) {
                    if (!(entry.getValue() instanceof JSONObject)) continue;
                    String value = (String)((JSONObject)entry.getValue()).get((Object)"url");
                    if (value.startsWith(sourcePrefix)) {
                        ((JSONObject)entry.getValue()).replace((Object)"url", (Object)(targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix)));
                        continue;
                    }
                    if (!value.startsWith("/" + sourcePrefix)) continue;
                    ((JSONObject)entry.getValue()).replace((Object)"url", (Object)("/" + targetPrefix + StringUtils.removeStart((String)value, (String)("/" + sourcePrefix))));
                }
                return JSONObject.toJSONString((Object)formKey);
            }
            catch (JSONException e) {
                ctx.printWarn("failed to handle json when rewrite bpm xml form key: " + (Object)((Object)e), new Object[0]);
                return null;
            }
        }

        private static String getPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName()), "/"});
        }
    }

    private static class WfdUrlRewriter
    implements Rewriter {
        private WfdUrlRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.BPM_WFD_URL_STRING) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourcePrefix = WfdUrlRewriter.getPrefix(ctx.getSource());
                String targetPrefix = WfdUrlRewriter.getPrefix(ctx.getTarget());
                if (value.startsWith(sourcePrefix)) {
                    value = targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix);
                    return EscapeUtil.jsStringEscape(value, false, false);
                }
                if (value.startsWith("/" + sourcePrefix)) {
                    value = "/" + targetPrefix + StringUtils.removeStart((String)value, (String)("/" + sourcePrefix));
                    return EscapeUtil.jsStringEscape(value, false, false);
                }
                return literal;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName()), "/"});
        }
    }

    private static class MapperInterpolateJavaTypeRewriter
    implements Rewriter {
        private MapperInterpolateJavaTypeRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.MAPPER_INTERPOLATE_JAVA_TYPE) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.xmlTextUnescape(literal);
                String sourcePrefix = MapperInterpolateJavaTypeRewriter.getPrefix(ctx.getSource());
                String targetPrefix = MapperInterpolateJavaTypeRewriter.getPrefix(ctx.getTarget());
                if (value.startsWith(sourcePrefix)) {
                    value = targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix);
                    return EscapeUtil.xmlTextEscape(value);
                }
                return literal;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getBackPackagePrefix() == null || placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing backPackagePrefix or tenantCode or appName");
            }
            String pkg = FileUtil.packagePath((String[])new String[]{placement.getBackPackagePrefix(), AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName())}) + ".";
            return pkg.toLowerCase();
        }
    }

    private static class MapperPackageRewriter
    implements Rewriter {
        private MapperPackageRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.MAPPER_NAMESPACE_ATTRIBUTE || segment.getKind() == Segment.Kind.MAPPER_TYPE_ATTRIBUTE) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.xmlAttributeUnescape(literal);
                String sourcePrefix = MapperPackageRewriter.getPrefix(ctx.getSource());
                String targetPrefix = MapperPackageRewriter.getPrefix(ctx.getTarget());
                if (value.startsWith(sourcePrefix)) {
                    value = targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix);
                    return EscapeUtil.xmlAttributeEscape(value);
                }
                return literal;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getBackPackagePrefix() == null || placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing backPackagePrefix or tenantCode or appName");
            }
            String pkg = FileUtil.packagePath((String[])new String[]{placement.getBackPackagePrefix(), AppContextUtil.asIdentifier((String)placement.getTenantCode()), ToolUtil.isNotEmpty((Object)placement.getServiceName()) ? AppContextUtil.asIdentifier((String)placement.getServiceName()) : "", AppContextUtil.asIdentifier((String)placement.getAppName())}) + ".";
            return pkg.toLowerCase();
        }
    }

    private static class JavaDsNameRewriter
    implements Rewriter {
        private JavaDsNameRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JAVA_DS_NAME_STRING) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.javaStringUnescape(literal);
                String sourceDsName = ctx.getSource().getDsName();
                String targetDsName = ctx.getTarget().getDsName();
                if (Objects.equals(value, sourceDsName)) {
                    return EscapeUtil.javaStringEscape(targetDsName);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JavaPluginBusRewriter
    implements Rewriter {
        private JavaPluginBusRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JAVA_PLUGIN_BUS_STRING) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.javaStringUnescape(literal);
                String sourcePrefix = JavaPluginBusRewriter.getPrefix(ctx.getSource());
                String targetPrefix = JavaPluginBusRewriter.getPrefix(ctx.getTarget());
                if (Objects.equals(value, sourcePrefix)) {
                    value = targetPrefix;
                    return EscapeUtil.javaStringEscape(value);
                }
                return literal;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getTenantCode() == null) {
                throw new RelocationException("missing tenantCode");
            }
            return placement.getTenantCode();
        }
    }

    private static class JavaRouteRewriter
    implements Rewriter {
        private JavaRouteRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JAVA_LOG_KEY_STRING || segment.getKind() == Segment.Kind.JAVA_REQUEST_MAPPING_STRING) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.javaStringUnescape(literal);
                String sourceFullPrefix = JavaRouteRewriter.getFullPrefix(ctx.getSource());
                String sourcePartialPrefix = JavaRouteRewriter.getPartialPrefix(ctx.getSource());
                String targetFullPrefix = JavaRouteRewriter.getFullPrefix(ctx.getTarget());
                if (value.startsWith(sourceFullPrefix)) {
                    value = targetFullPrefix + StringUtils.removeStart((String)value, (String)sourceFullPrefix);
                    return EscapeUtil.javaStringEscape(value);
                }
                if (value.startsWith(sourcePartialPrefix)) {
                    value = targetFullPrefix + StringUtils.removeStart((String)value, (String)sourcePartialPrefix);
                    return EscapeUtil.javaStringEscape(value);
                }
                return literal;
            }
            return null;
        }

        private static String getFullPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{"/", AppContextUtil.asIdentifier((String)placement.getTenantCode()), placement.getAppName(), "/"});
        }

        private static String getPartialPrefix(Placement placement) {
            if (placement.getTenantCode() == null) {
                throw new RelocationException("missing tenantCode");
            }
            return FileUtil.posixPath((String[])new String[]{"/", AppContextUtil.asIdentifier((String)placement.getTenantCode()), "/"});
        }
    }

    private static class JavaBeanNameRewriter
    implements Rewriter {
        private JavaBeanNameRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JAVA_BEAN_NAME_STRING) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.javaStringUnescape(literal);
                String sourcePrefix = JavaBeanNameRewriter.getPrefix(ctx.getSource());
                String targetPrefix = JavaBeanNameRewriter.getPrefix(ctx.getTarget());
                if (value.startsWith(sourcePrefix)) {
                    value = targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix);
                    return EscapeUtil.javaStringEscape(value);
                }
                return literal;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return AppContextUtil.asIdentifier((String)placement.getTenantCode()) + "." + placement.getAppName() + ".";
        }
    }

    private static class JavaPackageRewriter
    implements Rewriter {
        private JavaPackageRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JAVA_PACKAGE || segment.getKind() == Segment.Kind.JAVA_QUALIFIED) {
                String pkg = ctx.slice(segment);
                String sourcePrefix = JavaPackageRewriter.getPrefix(ctx.getSource());
                String targetPrefix = JavaPackageRewriter.getPrefix(ctx.getTarget());
                if (pkg.startsWith(sourcePrefix)) {
                    return targetPrefix + StringUtils.removeStart((String)pkg, (String)sourcePrefix);
                }
                return pkg;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getBackPackagePrefix() == null || placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing backPackagePrefix or tenantCode or appName");
            }
            String pkg = FileUtil.packagePath((String[])new String[]{placement.getBackPackagePrefix(), AppContextUtil.asIdentifier((String)placement.getTenantCode()), ToolUtil.isNotEmpty((Object)placement.getServiceName()) ? AppContextUtil.asIdentifier((String)placement.getServiceName()) : "", AppContextUtil.asIdentifier((String)placement.getAppName())}) + ".";
            return pkg.toLowerCase();
        }
    }

    private static class JsAppIdRewriter
    implements Rewriter {
        private JsAppIdRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_APP_ID_STRING) {
                String literal = ctx.slice(segment);
                boolean apos = literal.startsWith("'");
                boolean tilde = literal.startsWith("`");
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceAppId = JsAppIdRewriter.getAppId(ctx.getSource());
                String targetAppId = JsAppIdRewriter.getAppId(ctx.getTarget());
                if (value != null && value.equalsIgnoreCase(sourceAppId)) {
                    value = targetAppId;
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                return literal;
            }
            return null;
        }

        private static String getAppId(Placement placement) {
            return placement.getAppId();
        }
    }

    @Component
    private static class DbdDataSourceIDReWriter
    implements Rewriter {
        @Autowired
        private IDynamicDataSourceService remoteDataSourceService;
        private static IDynamicDataSourceService dataSourceService;

        private DbdDataSourceIDReWriter() {
        }

        @PostConstruct
        public void init() {
            dataSourceService = this.remoteDataSourceService;
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.DBD_DATASOURCE_ID) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                Long sourceDsID = ctx.getSource().getDsId();
                Long targetDsID = ctx.getTarget().getDsId();
                if (Objects.equals(value, sourceDsID) || ToolUtil.isEmpty((Object)dataSourceService.getDataSource(value))) {
                    return EscapeUtil.javaStringEscape(targetDsID.toString());
                }
                return literal;
            }
            return null;
        }
    }

    private static class DbdDataSourceNameReWriter
    implements Rewriter {
        private DbdDataSourceNameReWriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.DBD_DATASOURCE_NAME) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceDsName = ctx.getSource().getDsName();
                String targetDsName = ctx.getTarget().getDsName();
                if (Objects.equals(value, sourceDsName)) {
                    return EscapeUtil.javaStringEscape(targetDsName);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JsPrefixPathNameReWriter
    implements Rewriter {
        private JsPrefixPathNameReWriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_PREFIX_PATH_NAME) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourcePrefix = FileUtil.posixPath((String[])new String[]{"/" + AppContextUtil.asIdentifier((String)ctx.getSource().getTenantCode()), AppContextUtil.asIdentifier((String)ctx.getSource().getAppName())});
                String targetPrefix = FileUtil.posixPath((String[])new String[]{"/" + AppContextUtil.asIdentifier((String)ctx.getTarget().getTenantCode()), AppContextUtil.asIdentifier((String)ctx.getTarget().getAppName())});
                if (Objects.equals(value, sourcePrefix)) {
                    return EscapeUtil.javaStringEscape(targetPrefix);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JsTenantAppRoutePrefixReWriter
    implements Rewriter {
        private JsTenantAppRoutePrefixReWriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_TENANT_APP_ROUTE_PREFIX) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourcePrefix = FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)ctx.getSource().getTenantCode()), AppContextUtil.asIdentifier((String)ctx.getSource().getAppName())});
                String targetPrefix = FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)ctx.getTarget().getTenantCode()), AppContextUtil.asIdentifier((String)ctx.getTarget().getAppName())});
                if (Objects.equals(value, sourcePrefix)) {
                    return EscapeUtil.javaStringEscape(targetPrefix);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JsTenantAppNameReWriter
    implements Rewriter {
        private JsTenantAppNameReWriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_TENANT_APP_NAME) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceAppName = ctx.getSource().getAppName();
                String targetAppName = ctx.getTarget().getAppName();
                if (Objects.equals(value, sourceAppName)) {
                    return EscapeUtil.javaStringEscape(targetAppName);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JsTenantTenantIdReWriter
    implements Rewriter {
        private JsTenantTenantIdReWriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_TENANT_TENANT_ID) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceTenantCode = ctx.getSource().getTenantCode();
                String targetTenantCode = ctx.getTarget().getTenantCode();
                if (Objects.equals(value, sourceTenantCode)) {
                    return EscapeUtil.javaStringEscape(targetTenantCode);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JsTenantDsNameReWriter
    implements Rewriter {
        private JsTenantDsNameReWriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_TENANT_DS_NAME) {
                String literal = ctx.slice(segment);
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceDsName = ctx.getSource().getDsName();
                String targetDsName = ctx.getTarget().getDsName();
                if (Objects.equals(value, sourceDsName)) {
                    return EscapeUtil.javaStringEscape(targetDsName);
                }
                return literal;
            }
            return null;
        }
    }

    private static class JsRouterPathRewriter
    implements Rewriter {
        private JsRouterPathRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_ROUTER_PATH_STRING) {
                String literal = ctx.slice(segment);
                boolean apos = literal.startsWith("'");
                boolean tilde = literal.startsWith("`");
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourcePrefix = JsRouterPathRewriter.getPrefix(ctx.getSource());
                String targetPrefix = JsRouterPathRewriter.getPrefix(ctx.getTarget());
                if (value.startsWith(sourcePrefix)) {
                    value = targetPrefix + StringUtils.removeStart((String)value, (String)sourcePrefix);
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                if (value.startsWith("/" + sourcePrefix)) {
                    value = "/" + targetPrefix + StringUtils.removeStart((String)value, (String)("/" + sourcePrefix));
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                return literal;
            }
            return null;
        }

        private static String getPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName()), "/"});
        }
    }

    private static class JsApiPathRewriter
    implements Rewriter {
        private JsApiPathRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_API_PATH_STRING) {
                String literal = ctx.slice(segment);
                boolean apos = literal.startsWith("'");
                boolean tilde = literal.startsWith("`");
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceFullPrefix = JsApiPathRewriter.getFullPrefix(ctx.getSource());
                String sourcePartialPrefix = JsApiPathRewriter.getPartialPrefix(ctx.getSource());
                String targetFullPrefix = JsApiPathRewriter.getFullPrefix(ctx.getTarget());
                if (value.startsWith(sourceFullPrefix)) {
                    value = targetFullPrefix + StringUtils.removeStart((String)value, (String)sourceFullPrefix);
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                if (value.startsWith(sourcePartialPrefix)) {
                    value = targetFullPrefix + StringUtils.removeStart((String)value, (String)sourcePartialPrefix);
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                return literal;
            }
            return null;
        }

        private static String getFullPrefix(Placement placement) {
            if (placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{"/", AppContextUtil.asIdentifier((String)placement.getTenantCode()), placement.getAppName(), "/"});
        }

        private static String getPartialPrefix(Placement placement) {
            if (placement.getTenantCode() == null) {
                throw new RelocationException("missing tenantCode");
            }
            return FileUtil.posixPath((String[])new String[]{"/", AppContextUtil.asIdentifier((String)placement.getTenantCode()), "/"});
        }
    }

    private static class JsImportRewriter
    implements Rewriter {
        private JsImportRewriter() {
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            if (segment.getKind() == Segment.Kind.JS_IMPORT_STRING) {
                String literal = ctx.slice(segment);
                boolean apos = literal.startsWith("'");
                boolean tilde = literal.startsWith("`");
                String value = EscapeUtil.jsStringUnescape(literal);
                String sourceApiPrefix = JsImportRewriter.getApiPrefix(ctx, ctx.getSource());
                String sourceVuePrefix = JsImportRewriter.getVuePrefix(ctx, ctx.getSource());
                String targetApiPrefix = JsImportRewriter.getApiPrefix(ctx, ctx.getTarget());
                String targetVuePrefix = JsImportRewriter.getVuePrefix(ctx, ctx.getTarget());
                if (value.startsWith(sourceApiPrefix)) {
                    value = targetApiPrefix + StringUtils.removeStart((String)value, (String)sourceApiPrefix);
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                if (value.startsWith(sourceVuePrefix)) {
                    value = targetVuePrefix + StringUtils.removeStart((String)value, (String)sourceVuePrefix);
                    return EscapeUtil.jsStringEscape(value, apos, tilde);
                }
                return literal;
            }
            return null;
        }

        private static String getApiPrefix(Context ctx, Placement placement) {
            if (ctx.getOptions().getApiPrefix() == null || placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing apiPrefix or tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{ctx.getOptions().getApiPrefix(), AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName()), "/"});
        }

        private static String getVuePrefix(Context ctx, Placement placement) {
            if (ctx.getOptions().getVuePrefix() == null || placement.getTenantCode() == null || placement.getAppName() == null) {
                throw new RelocationException("missing vuePrefix or tenantCode or appName");
            }
            return FileUtil.posixPath((String[])new String[]{ctx.getOptions().getVuePrefix(), AppContextUtil.asIdentifier((String)placement.getTenantCode()), AppContextUtil.asIdentifier((String)placement.getAppName()), "/"});
        }
    }

    private static class ChainRewriter
    implements Rewriter {
        private final List<Rewriter> chain;

        public ChainRewriter(Rewriter ... chain) {
            this.chain = Arrays.asList(chain);
        }

        @Override
        public String handle(Context ctx, Segment segment) {
            for (Rewriter rewriter : this.chain) {
                String result = rewriter.handle(ctx, segment);
                if (result == null) continue;
                return result;
            }
            return ctx.slice(segment);
        }
    }

    private static interface Rewriter {
        public String handle(Context var1, Segment var2);
    }

    private static class RewriteStage {
        private static final Rewriter JS_REWRITER_CHAIN = new ChainRewriter(new JsImportRewriter(), new JsApiPathRewriter(), new JsTenantDsNameReWriter(), new JsTenantTenantIdReWriter(), new JsTenantAppNameReWriter(), new JsPrefixPathNameReWriter(), new JsTenantAppRoutePrefixReWriter());
        private static final Rewriter VUE_REWRITER_CHAIN = new ChainRewriter(new JsImportRewriter(), new JsApiPathRewriter(), new JsRouterPathRewriter(), new JsAppIdRewriter());
        private static final Rewriter JAVA_REWRITER_CHAIN = new ChainRewriter(new JavaPackageRewriter(), new JavaBeanNameRewriter(), new JavaRouteRewriter(), new JavaDsNameRewriter(), new JavaPluginBusRewriter());
        private static final Rewriter MAPPER_REWRITER_CHAIN = new ChainRewriter(new MapperPackageRewriter(), new MapperInterpolateJavaTypeRewriter());
        private static final Rewriter BPM_WFD_REWRITER_CHAIN = new ChainRewriter(new WfdUrlRewriter());
        private static final Rewriter BPM_XML_REWRITER_CHAIN = new ChainRewriter(new BpmXmlFromKeyJsonAttributeRewriter(), new BpmXmlFromDetailKeyJsonAttributeRewriter());
        private static final Rewriter DBD_DATASOURCE_NAME_CHAIN = new ChainRewriter(new DbdDataSourceNameReWriter(), new DbdDataSourceIDReWriter());

        private RewriteStage() {
        }

        public static String rewrite(Context ctx, List<Segment> segments) {
            Rewriter chain;
            switch (ctx.getType()) {
                case JS: {
                    chain = JS_REWRITER_CHAIN;
                    break;
                }
                case VUE: {
                    chain = VUE_REWRITER_CHAIN;
                    break;
                }
                case JAVA: {
                    chain = JAVA_REWRITER_CHAIN;
                    break;
                }
                case MAPPER: {
                    chain = MAPPER_REWRITER_CHAIN;
                    break;
                }
                case BPM_WFD: {
                    chain = BPM_WFD_REWRITER_CHAIN;
                    break;
                }
                case BPM_XML: {
                    chain = BPM_XML_REWRITER_CHAIN;
                    break;
                }
                case DBD: {
                    chain = DBD_DATASOURCE_NAME_CHAIN;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            StringBuilder builder = new StringBuilder();
            for (Segment segment : segments) {
                String value;
                try {
                    value = chain.handle(ctx, segment);
                }
                catch (RelocationException e) {
                    ctx.printError("%s", e.getMessage());
                    return null;
                }
                if (value != null) {
                    builder.append(value);
                    continue;
                }
                ctx.printWarn("rewrite segment %s to null", segment);
                builder.append(ctx.slice(segment));
            }
            return builder.toString();
        }
    }

    private static class RegexpGroupExtractor
    implements Extractor {
        private final Pattern regexp;
        private final String group;
        private final Segment.Kind kind;

        public RegexpGroupExtractor(Pattern regexp, String group, Segment.Kind kind) {
            this.regexp = regexp;
            this.group = group;
            this.kind = kind;
        }

        @Override
        public List<Segment> split(Context ctx, List<Segment> segments) {
            ArrayList<Segment> produce = new ArrayList<Segment>();
            for (Segment segment : segments) {
                if (segment.getKind() == Segment.Kind.UNRECOGNIZED) {
                    int offset = segment.getStart();
                    String piece = ctx.slice(segment);
                    int nextStart = 0;
                    Matcher matcher = this.regexp.matcher(piece);
                    while (matcher.find(nextStart)) {
                        int endGroup;
                        int startGroup;
                        int startMatch = matcher.start();
                        int endMatch = matcher.end();
                        Segment workingSegment = new Segment(null, nextStart + offset, endMatch + offset);
                        try {
                            startGroup = matcher.start(this.group);
                            endGroup = matcher.end(this.group);
                        }
                        catch (IllegalArgumentException ignore) {
                            ctx.printWarn("group '%s' in '%s' not matched", this.group, this.regexp.pattern());
                            List<Segment> split = workingSegment.split(startMatch + offset);
                            Segment.assign(split, Segment.Kind.UNRECOGNIZED, Segment.Kind.EXCLUDED);
                            produce.addAll(Segment.optimize(split));
                            nextStart = endMatch;
                            continue;
                        }
                        List<Segment> split = workingSegment.split(startMatch + offset, startGroup + offset, endGroup + offset);
                        Segment.assign(split, Segment.Kind.UNRECOGNIZED, Segment.Kind.EXCLUDED, this.kind, Segment.Kind.EXCLUDED);
                        produce.addAll(Segment.optimize(split));
                        nextStart = endMatch;
                    }
                    if (nextStart + offset >= segment.getEnd()) continue;
                    produce.add(new Segment(Segment.Kind.UNRECOGNIZED, nextStart + offset, segment.getEnd()));
                    continue;
                }
                produce.add(segment);
            }
            return produce;
        }
    }

    private static interface Extractor {
        public List<Segment> split(Context var1, List<Segment> var2);
    }

    private static class ExtractStage {
        private static final Extractor JS_IMPORT_STATEMENT = new RegexpGroupExtractor(Pattern.compile("(?<!@)import\\s+[\\sa-zA-Z0-9_${},*]*(?<path>'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\")"), "path", Segment.Kind.JS_IMPORT_STRING);
        private static final Extractor JS_IMPORT_EXPRESSION = new RegexpGroupExtractor(Pattern.compile("(?<!@)(import|require)\\s*\\(\\s*(?<path>'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\")"), "path", Segment.Kind.JS_IMPORT_STRING);
        private static final Extractor JS_API_INVOCATION = new RegexpGroupExtractor(Pattern.compile("hussarRequest\\s*\\.\\s*[a-zA-Z0-9_$]+\\s*\\(\\s*(?<api>'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\"|`(\\\\`|[^`])*`)"), "api", Segment.Kind.JS_API_PATH_STRING);
        private static final Extractor JS_ROUTER_PUSH = new RegexpGroupExtractor(Pattern.compile("\\$router\\s*\\.\\s*push\\s*\\(\\s*\\{\\s*path\\s*:\\s*(?<path>'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\")"), "path", Segment.Kind.JS_ROUTER_PATH_STRING);
        private static final Extractor JS_FLOW_AUTH_APP_ID = new RegexpGroupExtractor(Pattern.compile("(?<![a-zA-Z0-9_$])appId\\s*:\\s*(?<id>'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\")"), "id", Segment.Kind.JS_APP_ID_STRING);
        private static final Extractor JS_TENANT_DS_NAME = new RegexpGroupExtractor(Pattern.compile("dbName\" : \\s*(?<dsName>\"(\\\\\"|[^\"])*\")"), "dsName", Segment.Kind.JS_TENANT_DS_NAME);
        private static final Extractor JS_TENANT_TENANT_ID = new RegexpGroupExtractor(Pattern.compile("tenantId\" : \\s*(?<tenantId>\"(\\\\\"|[^\"])*\")"), "tenantId", Segment.Kind.JS_TENANT_TENANT_ID);
        private static final Extractor JS_TENANT_APP_NAME = new RegexpGroupExtractor(Pattern.compile("appName\" : \\s*(?<appName>\"(\\\\\"|[^\"])*\")"), "appName", Segment.Kind.JS_TENANT_APP_NAME);
        private static final Extractor JS_TENANT_APP_ROUTE_PREFIX = new RegexpGroupExtractor(Pattern.compile("appRoutePrefix\" : \\s*(?<appRoutePrefix>\"(\\\\\"|[^\"])*\")"), "appRoutePrefix", Segment.Kind.JS_TENANT_APP_ROUTE_PREFIX);
        private static final Extractor JS_PREFIX_PATH_NAME = new RegexpGroupExtractor(Pattern.compile("pathName\" : \\s*(?<pathName>\"(\\\\\"|[^\"])*\")"), "pathName", Segment.Kind.JS_PREFIX_PATH_NAME);
        private static final Extractor CSS_DECLARATION_URL = new RegexpGroupExtractor(Pattern.compile("[a-zA-Z0-9_-]+\\s*:\\s*([#'\"a-zA-Z0-9_-]+\\s+)*url\\s*\\(\\s*(?<url>[^)]*|'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\")"), "url", Segment.Kind.CSS_URL_STRING);
        private static final Extractor CSS_IMPORT_STRING = new RegexpGroupExtractor(Pattern.compile("@import\\s+(url\\s*\\(\\s*)?(?<url>'(\\\\'|[^'])*'|\"(\\\\\"|[^\"])*\")"), "url", Segment.Kind.CSS_URL_STRING);
        private static final Extractor HTML_SRC_ATTRIBUTE = new RegexpGroupExtractor(Pattern.compile("\\s+src=(?<url>'[^']*'|\\\"[^\\\"]*\\\"|[^\\s/>]*)", 2), "url", Segment.Kind.HTML_SRC_ATTRIBUTE);
        private static final Extractor JAVA_PACKAGE = new RegexpGroupExtractor(Pattern.compile("package\\s+(?<package>[a-zA-Z_$][a-zA-Z0-9_$]*(\\s*\\.\\s*[a-zA-Z_$][a-zA-Z0-9_$]*)*)\\s*;"), "package", Segment.Kind.JAVA_PACKAGE);
        private static final Extractor JAVA_IMPORT = new RegexpGroupExtractor(Pattern.compile("import\\s+(static\\s+)?(?<qualified>[a-zA-Z_$][a-zA-Z0-9_$]*(\\s*\\.\\s*[a-zA-Z_$][a-zA-Z0-9_$]*)*(\\s*\\.\\s*\\*)?)\\s*;"), "qualified", Segment.Kind.JAVA_QUALIFIED);
        private static final Extractor JAVA_BEAN_NAME = new RegexpGroupExtractor(Pattern.compile("@\\s*(Component|Configuration|Controller|RestController|Service|Mapper|Repository|Alias)\\s*\\(\\s*((?!value\\s*=)[a-zA-Z_$][a-zA-Z0-9_$]*\\s*=(\"(\\\\\"|[^\"])*\"|'(\\\\'|[^'])*'|[^,)\"'])+,\\s*)*(value\\s*=)?\\s*(?<name>\"(\\\\\"|[^\"])*\")"), "name", Segment.Kind.JAVA_BEAN_NAME_STRING);
        private static final Extractor JAVA_REQUEST_MAPPING = new RegexpGroupExtractor(Pattern.compile("@\\s*RequestMapping\\s*\\(\\s*((?!value\\s*=)[a-zA-Z_$][a-zA-Z0-9_$]*\\s*=(\"(\\\\\"|[^\"])*\"|'(\\\\'|[^'])*'|[^,)\"'])+,\\s*)*(value\\s*=)?\\s*(?<path>\"(\\\\\"|[^\"])*\")"), "path", Segment.Kind.JAVA_REQUEST_MAPPING_STRING);
        private static final Extractor JAVA_DS_NAME = new RegexpGroupExtractor(Pattern.compile("@\\s*HussarDs\\s*\\(\\s*((?!value\\s*=)[a-zA-Z_$][a-zA-Z0-9_$]*\\s*=(\"(\\\\\"|[^\"])*\"|'(\\\\'|[^'])*'|[^,)\"'])+,\\s*)*(value\\s*=)?\\s*(?<name>\"(\\\\\"|[^\"])*\")"), "name", Segment.Kind.JAVA_DS_NAME_STRING);
        private static final Extractor JAVA_CHANGE_DS_INVOCATION = new RegexpGroupExtractor(Pattern.compile("DataSourceUtil\\s*\\.\\s*(changeTempDs|changeLongTermDs)\\s*\\(\\s*(?<name>\"(\\\\\"|[^\"])*\")"), "name", Segment.Kind.JAVA_DS_NAME_STRING);
        private static final Extractor JAVA_LOG_KEY = new RegexpGroupExtractor(Pattern.compile("@\\s*BussinessLog\\s*\\(\\s*((?!key\\s*=)[a-zA-Z_$][a-zA-Z0-9_$]*\\s*=(\"(\\\\\"|[^\"])*\"|'(\\\\'|[^'])*'|[^,)\"'])+,\\s*)*key\\s*=\\s*(?<key>\"(\\\\\"|[^\"])*\")"), "key", Segment.Kind.JAVA_LOG_KEY_STRING);
        private static final Extractor JAVA_PLUGIN_BUS = new RegexpGroupExtractor(Pattern.compile("@\\s*Extract\\s*\\(\\s*((?!bus\\s*=)[a-zA-Z_$][a-zA-Z0-9_$]*\\s*=(\"(\\\\\"|[^\"])*\"|'(\\\\'|[^'])*'|[^,)\"'])+,\\s*)*bus\\s*=\\s*(?<bus>\"(\\\\\"|[^\"])*\")"), "bus", Segment.Kind.JAVA_PLUGIN_BUS_STRING);
        private static final Extractor JAVA_QUALIFIED_CLASS = new RegexpGroupExtractor(Pattern.compile("(?<![a-zA-Z0-9_$.])(?<qualified>(com|org|net|cn|edu|gov|mil|java|javax)(\\s*\\.\\s*[a-z_$][a-z0-9_$]*)*\\s*\\.\\s*[A-Z_$][a-zA-Z0-9_$]*)"), "qualified", Segment.Kind.JAVA_QUALIFIED);
        private static final Extractor MAPPER_NAMESPACE = new RegexpGroupExtractor(Pattern.compile("(?<![a-zA-Z0-9])namespace=(?<ns>'[^']*'|\"[^\"]*\"|[^\\s/>]*)"), "ns", Segment.Kind.MAPPER_NAMESPACE_ATTRIBUTE);
        private static final Extractor MAPPER_INTERPOLATE_TYPE = new RegexpGroupExtractor(Pattern.compile("[#$]\\{[^,}]+(,\\s*(?!javaType\\s*=)[a-zA-Z0-9_]+\\s*=\\s*[^=,}]+)*,\\s*javaType\\s*=\\s*(?<type>[^=,}\\s]+)\\s*(,\\s*[a-zA-Z0-9_]+\\s*=\\s*[^=,}]+)*}"), "type", Segment.Kind.MAPPER_INTERPOLATE_JAVA_TYPE);
        private static final Extractor MAPPER_TYPE_ATTRIBUTES = new RegexpGroupExtractor(Pattern.compile("(?<![a-zA-Z0-9])(type|resultType|javaType|ofType|parameterType)=(?<type>'[^']*'|\"[^\"]*\"|[^\\s/>]*)"), "type", Segment.Kind.MAPPER_TYPE_ATTRIBUTE);
        private static final Extractor BPM_WFD_URL_FIELD = new RegexpGroupExtractor(Pattern.compile("\"url\"\\s*:\\s*(?<url>\"(\\\\\"|[^\"])*\")"), "url", Segment.Kind.BPM_WFD_URL_STRING);
        private static final Extractor BPM_XML_FORM_KEY = new RegexpGroupExtractor(Pattern.compile("activiti:formKey=(?<attribute>'[^']*'|\"[^\"]*\"|[^\\s/>]*)"), "attribute", Segment.Kind.BPM_FORM_KEY_ATTRIBUTE);
        private static final Extractor BPM_XML_FORM_DETAIL_KEY = new RegexpGroupExtractor(Pattern.compile("flowFormDetailKey=(?<attribute>'[^']*'|\"[^\"]*\"|[^\\s/>]*)"), "attribute", Segment.Kind.BPM_FORM_DETAIL_KEY_ATTRIBUTE);
        private static final Extractor DBD_DATASOURCE_NAME = new RegexpGroupExtractor(Pattern.compile("dataSourceName\"\\s*:\\s*(?<dataSourceName>\"(\\\\\"|[^\"])*\")"), "dataSourceName", Segment.Kind.DBD_DATASOURCE_NAME);
        private static final Extractor DBD_DATASOURCE_ID = new RegexpGroupExtractor(Pattern.compile("dataSourceId\"\\s*:\\s*(?<dataSourceId>\"(\\\\\"|[^\"])*\")"), "dataSourceId", Segment.Kind.DBD_DATASOURCE_ID);
        private static final List<Extractor> JS_EXTRACTION_PHASES = Arrays.asList(JS_IMPORT_STATEMENT, JS_IMPORT_EXPRESSION, JS_API_INVOCATION, JS_TENANT_DS_NAME, JS_TENANT_TENANT_ID, JS_TENANT_APP_NAME, JS_TENANT_APP_ROUTE_PREFIX, JS_PREFIX_PATH_NAME);
        private static final List<Extractor> VUE_EXTRACTION_PHASES = Arrays.asList(JS_IMPORT_STATEMENT, JS_IMPORT_EXPRESSION, JS_API_INVOCATION, JS_ROUTER_PUSH, JS_FLOW_AUTH_APP_ID, CSS_DECLARATION_URL, CSS_IMPORT_STRING, HTML_SRC_ATTRIBUTE);
        private static final List<Extractor> JAVA_EXTRACTION_PHASES = Arrays.asList(JAVA_PACKAGE, JAVA_IMPORT, JAVA_BEAN_NAME, JAVA_REQUEST_MAPPING, JAVA_DS_NAME, JAVA_CHANGE_DS_INVOCATION, JAVA_LOG_KEY, JAVA_PLUGIN_BUS, JAVA_QUALIFIED_CLASS);
        private static final List<Extractor> MAPPER_EXTRACTION_PHASES = Arrays.asList(MAPPER_NAMESPACE, MAPPER_INTERPOLATE_TYPE, MAPPER_TYPE_ATTRIBUTES);
        private static final List<Extractor> BPM_WFD_EXTRACTION_PHASES = Collections.singletonList(BPM_WFD_URL_FIELD);
        private static final List<Extractor> BPM_XML_EXTRACTION_PHASES = Arrays.asList(BPM_XML_FORM_KEY, BPM_XML_FORM_DETAIL_KEY);
        private static final List<Extractor> DBD_DATASOURCE_NAME_PHASES = Arrays.asList(DBD_DATASOURCE_NAME, DBD_DATASOURCE_ID);

        private ExtractStage() {
        }

        public static List<Segment> extract(Context ctx) {
            List<Extractor> phases;
            switch (ctx.getType()) {
                case JS: {
                    phases = JS_EXTRACTION_PHASES;
                    break;
                }
                case VUE: {
                    phases = VUE_EXTRACTION_PHASES;
                    break;
                }
                case JAVA: {
                    phases = JAVA_EXTRACTION_PHASES;
                    break;
                }
                case MAPPER: {
                    phases = MAPPER_EXTRACTION_PHASES;
                    break;
                }
                case BPM_WFD: {
                    phases = BPM_WFD_EXTRACTION_PHASES;
                    break;
                }
                case BPM_XML: {
                    phases = BPM_XML_EXTRACTION_PHASES;
                    break;
                }
                case DBD: {
                    phases = DBD_DATASOURCE_NAME_PHASES;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            List<Segment> segments = Segment.original(ctx.getOriginal());
            for (Extractor phase : phases) {
                try {
                    segments = phase.split(ctx, segments);
                }
                catch (RelocationException e) {
                    ctx.printError("%s", e.getMessage());
                    return null;
                }
            }
            return segments;
        }
    }

    private static class Segment {
        private Kind kind;
        private int start;
        private int end;

        private Segment(Kind kind, int start, int end) {
            this.kind = kind;
            this.start = start;
            this.end = end;
        }

        public static List<Segment> original(String original) {
            return Collections.singletonList(new Segment(Kind.UNRECOGNIZED, 0, original.length()));
        }

        public List<Segment> split(int ... points) {
            int[] preprocessed = Arrays.stream(points).filter(point -> point >= this.start && point <= this.end).sorted().toArray();
            if (preprocessed.length != points.length) {
                throw new RelocationException("points in " + Arrays.toString(points) + " out of range " + this.start + ".." + this.end);
            }
            int last = this.start;
            ArrayList<Segment> segments = new ArrayList<Segment>(preprocessed.length + 1);
            for (int point2 : preprocessed) {
                segments.add(new Segment(null, last, point2));
                last = point2;
            }
            segments.add(new Segment(null, last, this.end));
            return segments;
        }

        public static void assign(List<Segment> segments, Kind ... kinds) {
            if (kinds.length != segments.size()) {
                throw new RelocationException("segments kind assignment shape mismatched: " + segments + " ~ " + Arrays.asList(kinds));
            }
            for (int i = 0; i < kinds.length; ++i) {
                segments.get(i).setKind(kinds[i]);
            }
        }

        public static List<Segment> optimize(List<Segment> segments) {
            return segments.stream().filter(segment -> segment.end > segment.start).collect(Collectors.toList());
        }

        public Kind getKind() {
            return this.kind;
        }

        public void setKind(Kind kind) {
            this.kind = kind;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "@<" + this.start + ":" + this.end + ">";
        }

        public static enum Kind {
            UNRECOGNIZED,
            EXCLUDED,
            JS_IMPORT_STRING,
            JS_API_PATH_STRING,
            JS_ROUTER_PATH_STRING,
            JS_APP_ID_STRING,
            JS_TENANT_DS_NAME,
            JS_TENANT_TENANT_ID,
            JS_TENANT_APP_NAME,
            JS_TENANT_APP_ROUTE_PREFIX,
            JS_PREFIX_PATH_NAME,
            CSS_URL_STRING,
            HTML_SRC_ATTRIBUTE,
            JAVA_PACKAGE,
            JAVA_QUALIFIED,
            JAVA_BEAN_NAME_STRING,
            JAVA_DS_NAME_STRING,
            JAVA_LOG_KEY_STRING,
            JAVA_PLUGIN_BUS_STRING,
            JAVA_REQUEST_MAPPING_STRING,
            MAPPER_NAMESPACE_ATTRIBUTE,
            MAPPER_TYPE_ATTRIBUTE,
            MAPPER_INTERPOLATE_JAVA_TYPE,
            BPM_WFD_URL_STRING,
            BPM_FORM_KEY_ATTRIBUTE,
            BPM_FORM_DETAIL_KEY_ATTRIBUTE,
            DBD_DATASOURCE_NAME,
            DBD_DATASOURCE_ID;

        }
    }

    private static class TwoStageProcessor
    implements Processor {
        private TwoStageProcessor() {
        }

        @Override
        public String process(Context ctx) {
            List<Segment> segments = ExtractStage.extract(ctx);
            if (!ctx.isSuccess() || segments == null) {
                return null;
            }
            if (ctx.getOptions().isDebug()) {
                System.out.println("*** segments ***");
                int i = 0;
                for (Segment segment : segments) {
                    ++i;
                    if (segment.getKind() == Segment.Kind.UNRECOGNIZED || segment.getKind() == Segment.Kind.EXCLUDED) continue;
                    System.out.println("[" + i + "] " + segment + ": " + ctx.slice(segment));
                }
                System.out.println();
            }
            return RewriteStage.rewrite(ctx, segments);
        }
    }

    private static interface Processor {
        public String process(Context var1);

        public static Processor factory(Context ctx) {
            switch (ctx.getType()) {
                case JAVA: 
                case MAPPER: 
                case JS: 
                case VUE: 
                case BPM_WFD: 
                case BPM_XML: 
                case DBD: {
                    return new TwoStageProcessor();
                }
                case BPM_WORKFLOW_TABLE_JSON: {
                    return new BpmWorkflowTableJsonProcessor();
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class RelocationException
    extends RuntimeException {
        public RelocationException(String message) {
            super(message);
        }

        @Override
        public String getMessage() {
            String place = null;
            StackTraceElement[] stack = super.getStackTrace();
            if (stack.length > 0) {
                place = stack[0].getClassName().replaceAll("^.+[.$](?=\\w+$)", "") + "." + stack[0].getMethodName();
            }
            return (place != null ? place + ": " : "") + super.getMessage();
        }
    }

    private static class Context {
        private boolean success = true;
        private final StringBuilder warns = new StringBuilder();
        private final StringBuilder errors = new StringBuilder();
        private final SourceType type;
        private final String original;
        private final Placement source;
        private final Placement target;
        private final Options options;

        public Context(SourceType type, String content, Placement source, Placement target, Options options) {
            this.type = type;
            this.original = content;
            this.source = source;
            this.target = target;
            this.options = options;
        }

        public String slice(Segment segment) {
            if (segment.getStart() > segment.getEnd() || segment.getStart() < 0 || segment.getEnd() > this.original.length()) {
                throw new RelocationException("slice bound " + segment.getStart() + ".." + segment.getEnd() + " out of range 0.." + this.original.length());
            }
            return this.original.substring(segment.getStart(), segment.getEnd());
        }

        public Result result(String content) {
            return new Result(this.isSuccess(), content, this.getWarns(), this.getErrors());
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void printWarn(String format, Object ... args) {
            String message = String.format(format, args);
            this.warns.append(message).append(System.lineSeparator());
        }

        public void printError(String format, Object ... args) {
            String message = String.format(format, args);
            this.errors.append(message).append(System.lineSeparator());
            this.success = false;
        }

        public String getWarns() {
            return this.warns.length() > 0 ? this.warns.toString() : null;
        }

        public String getErrors() {
            return this.errors.length() > 0 ? this.errors.toString() : null;
        }

        public SourceType getType() {
            return this.type;
        }

        public String getOriginal() {
            return this.original;
        }

        public Placement getSource() {
            return this.source;
        }

        public Placement getTarget() {
            return this.target;
        }

        public Options getOptions() {
            return this.options;
        }
    }

    public static class Options {
        private boolean debug = false;
        private boolean strict = false;
        private String vuePrefix = "#/views";
        private String apiPrefix = "#/api";

        public static Options defaultOptions() {
            return new Options();
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public String getVuePrefix() {
            return this.vuePrefix;
        }

        public void setVuePrefix(String vuePrefix) {
            this.vuePrefix = vuePrefix;
        }

        public String getApiPrefix() {
            return this.apiPrefix;
        }

        public void setApiPrefix(String apiPrefix) {
            this.apiPrefix = apiPrefix;
        }
    }

    public static class Placement {
        private String serviceName;
        private String tenantCode;
        private String appName;
        private String appId;
        private String dsName;
        private Long dsId;
        private String backPackagePrefix;

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getTenantCode() {
            return HussarUtils.isEmpty((Object)this.tenantCode) ? "0" : this.tenantCode;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getDsName() {
            return this.dsName;
        }

        public void setDsName(String dsName) {
            this.dsName = dsName;
        }

        public Long getDsId() {
            return this.dsId;
        }

        public void setDsId(Long dsId) {
            this.dsId = dsId;
        }

        public String getBackPackagePrefix() {
            return this.backPackagePrefix;
        }

        public void setBackPackagePrefix(String backPackagePrefix) {
            this.backPackagePrefix = backPackagePrefix;
        }
    }

    public static enum SourceType {
        JAVA,
        MAPPER,
        JS,
        VUE,
        BPM_WFD,
        BPM_XML,
        BPM_WORKFLOW_TABLE_JSON,
        DBD;

    }

    public static class Result {
        private final boolean success;
        private final String content;
        private final String warns;
        private final String errors;

        public Result(boolean success, String content, String warns, String errors) {
            this.success = success;
            this.content = content;
            this.warns = warns;
            this.errors = errors;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getContent() {
            return this.content;
        }

        public String getWarns() {
            return this.warns;
        }

        public String getErrors() {
            return this.errors;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.success && this.content != null) {
                builder.append("*** content ***\n").append(this.content).append("\n");
            }
            if (this.errors != null) {
                builder.append("*** errors ***\n").append(this.errors).append("\n");
            }
            if (this.warns != null) {
                builder.append("*** warns ***\n").append(this.warns).append("\n");
            }
            return builder.toString();
        }
    }
}

