/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.inducts.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.inducts.InductsTableService;
import com.jxdinfo.hussar.formdesign.inducts.impl.InductsTableSqlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InductsTableServiceImpl
implements InductsTableService {
    @Autowired
    private HussarDdlService ddlService;
    @Autowired
    private InductsTableSqlService inductsTableSqlService;

    public Map<String, Object> contrast(Map<String, String> tableStructures, String dsName) throws IOException, LcdpException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        ArrayList<JSONObject> addTableResultList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> modifyTableResults = new ArrayList<JSONObject>();
        for (String dataSourceName : tableStructures.keySet()) {
            FormDesignAppInfo appInfo = AppContextUtil.getAppInfo();
            List tableInfoList = (List)JSON.parseObject((String)tableStructures.get(dataSourceName), (TypeReference)new TypeReference<List<TableInfo>>(){}, (Feature[])new Feature[0]);
            this.generateSql(tableInfoList, dataSourceName, sqlMap, addTableResultList, modifyTableResults);
        }
        dataMap.put("sql", JSON.toJSONString(sqlMap));
        dataMap.put("createTables", addTableResultList);
        dataMap.put("alterTables", modifyTableResults);
        return dataMap;
    }

    public void executeSql(String sqlStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)sqlStr);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            for (String dataSourceName : jsonObject.keySet()) {
                String sql = jsonObject.getString(dataSourceName);
                if (!ToolUtil.isNotEmpty((Object)sql)) continue;
                this.inductsTableSqlService.generateSql(dataSourceName, sql);
            }
        }
    }

    private void generateSql(List<TableInfo> tableStructure, String dataSource, Map<String, String> sqlMap, List<JSONObject> addTableResultList, List<JSONObject> modifyTableResults) throws IOException, LcdpException {
        StringBuilder sql = new StringBuilder();
        JSONObject addTables = new JSONObject();
        ArrayList<String> addTableName = new ArrayList<String>();
        addTables.put("dataSourceName", (Object)dataSource);
        addTables.put("tableNames", addTableName);
        JSONObject editTables = new JSONObject();
        HashMap<String, List<String>> tableMessage = new HashMap<String, List<String>>();
        editTables.put("dataSourceName", (Object)dataSource);
        editTables.put("tableMessage", tableMessage);
        for (TableInfo tableInfo : tableStructure) {
            Optional newTableInfo = DataModelUtil.filterTable((String)dataSource, (String)"BASE TABLE", (String)tableInfo.getName());
            if (!newTableInfo.isPresent()) {
                String createTableSql = this.ddlService.getDdlSql(this.getCreateTableParam(tableInfo, dataSource, addTableName), new ArrayList(), null);
                sql.append(createTableSql);
                continue;
            }
            String updateTableSql = this.ddlService.getDdlSql(this.getUpdateTableParam(tableInfo, (TableInfo)newTableInfo.get(), dataSource, tableMessage), this.getColumnDto(((TableInfo)newTableInfo.get()).getFields()), tableInfo.getName());
            sql.append(updateTableSql);
        }
        addTableResultList.add(addTables);
        modifyTableResults.add(editTables);
        sqlMap.put(dataSource, sql.toString());
    }

    private MetadataParam getCreateTableParam(TableInfo tableInfo, String dataSource, List<String> addTableName) {
        addTableName.add(tableInfo.getName());
        MetadataParam param = new MetadataParam();
        List<ColumnInfoDto> columnDto = this.getColumnDto(tableInfo.getFields());
        param.setTableInfo(this.getTableInfoDto(tableInfo, dataSource, columnDto));
        param.setColumnInfo(columnDto);
        return param;
    }

    private List<ColumnInfoDto> getColumnDto(List<TableField> tableFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (TableField tableField : tableFields) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(tableField.getName());
            columnInfo.setColumnComment(tableField.getComment());
            columnInfo.setRequired("0");
            if ("PRI".equals(tableField.getPrimarys())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
                columnInfo.setPrimarys("1");
            } else {
                columnInfo.setPk("0");
            }
            if (tableField.getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataIsEmpty(Integer.valueOf(tableField.getDataIsEmpty() ? 1 : 0));
            columnInfo.setDataLength(Long.valueOf(tableField.getDataLength()));
            columnInfo.setDataDot(Integer.valueOf(tableField.getDataDot()));
            columnInfo.setDataType(tableField.getType().toUpperCase());
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    private TableInfoDto getTableInfoDto(TableInfo tableInfo, String dataSource, List<ColumnInfoDto> columnDto) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(tableInfo.getName());
        tableDto.setPollName(dataSource);
        tableDto.setTableAlias(tableInfo.getName());
        tableDto.setTableDec(tableInfo.getComment());
        tableDto.setColumnList(HussarUtils.copyProperties(columnDto, MetadataColumn.class));
        return tableDto;
    }

    private MetadataParam getUpdateTableParam(TableInfo tableInfo, TableInfo newTableInfo, String dataSource, Map<String, List<String>> tableMessage) {
        ArrayList<String> messageList = new ArrayList<String>();
        MetadataParam param = new MetadataParam();
        param.setDeletedCols(new ArrayList());
        param.setColumnInfo(new ArrayList());
        List<ColumnInfoDto> columnDto = this.getColumnDto(tableInfo.getFields());
        param.setTableInfo(this.getTableInfoDto(tableInfo, dataSource, columnDto));
        this.mcontrastWith(tableInfo, newTableInfo, messageList, param);
        if (!messageList.isEmpty()) {
            tableMessage.put(tableInfo.getName(), messageList);
        }
        return param;
    }

    private void mcontrastWith(TableInfo tableInfo, TableInfo newTableInfo, List<String> tableMessage, MetadataParam param) {
        ArrayList<ColumnInfoDto> columnInfoDtos = new ArrayList<ColumnInfoDto>();
        ArrayList<TableField> editField = new ArrayList<TableField>();
        ArrayList<TableField> delField = new ArrayList<TableField>();
        Map addFieldsMap = tableInfo.getFields().stream().collect(Collectors.toMap(TableField::getName, Function.identity(), (k1, k2) -> k1));
        for (Object oldField : newTableInfo.getFields()) {
            boolean flag = false;
            for (TableField newField : tableInfo.getFields()) {
                if (!HussarUtils.equals((Object)oldField.getName(), (Object)newField.getName())) continue;
                flag = true;
                addFieldsMap.remove(oldField.getName());
                if (HussarUtils.equals((Object)oldField.getType().toLowerCase(), (Object)newField.getType().toLowerCase()) && oldField.getDataIsEmpty() == newField.getDataIsEmpty() && oldField.getDataLength() == newField.getDataLength() && oldField.getDataDot() == newField.getDataDot() && HussarUtils.equals((Object)oldField.getComment(), (Object)newField.getComment()) && HussarUtils.equals((Object)"PRI", (Object)oldField.getPrimarys()) == HussarUtils.equals((Object)"PRI", (Object)newField.getPrimarys())) break;
                tableMessage.add(String.format("%s\u5217\uff1a%s(%s)", "\u4fee\u6539", oldField.getName(), oldField.getComment()));
                editField.add(newField);
            }
            if (flag) continue;
            tableMessage.add(String.format("%s\u5217\uff1a%s(%s)", "\u5220\u9664", oldField.getName(), oldField.getComment()));
            delField.add((TableField)oldField);
        }
        if (HussarUtils.isNotEmpty(editField)) {
            List<ColumnInfoDto> editFieldColumnDto = this.getColumnDto(editField);
            for (ColumnInfoDto columnInfoDto : editFieldColumnDto) {
                columnInfoDto.setOperation("edit");
            }
            columnInfoDtos.addAll(editFieldColumnDto);
        }
        if (HussarUtils.isNotEmpty(addFieldsMap.values())) {
            ArrayList<TableField> addField = new ArrayList<TableField>(addFieldsMap.values());
            List<ColumnInfoDto> addFieldColumnDto = this.getColumnDto(addField);
            for (ColumnInfoDto columnInfoDto : addFieldColumnDto) {
                tableMessage.add(String.format("%s\u5217\uff1a%s(%s)", "\u65b0\u589e", columnInfoDto.getColumnName(), columnInfoDto.getColumnComment()));
                columnInfoDto.setOperation("add");
            }
            columnInfoDtos.addAll(addFieldColumnDto);
        }
        if (HussarUtils.isNotEmpty(delField)) {
            param.setDeletedCols(this.getColumnDto(delField));
        }
        param.setColumnInfo(columnInfoDtos);
    }
}

