<#list filterOptions! as item>
    <#if item.componentType?? && item.componentType != 'JXDNSelectTree' && item.componentType != 'JXDNSelectTreeMulti'>
         <#if item.type == 'CommonModel'>
        const params${item_index} = {
          typeName: '${item.dictType!}',
        };
        ${item.apiFileName!}.${item.importMethod!}(params${item_index}).then(res => {
            if (res.code === 200 || res.code === 10000) {
                const data = res?.data;
                if(data?.length){
                    <#if item.componentModelType?? && item.componentModelType == 'select'>
                    const options = data.map(opt => {
                        return {
                            name: opt.label,
                            value: opt.value
                        }
                    })
                    <#elseif item.componentModelType?? && item.componentModelType == 'tree'>
                    const options = formatDictToTreeData(data, [], null, true);
                    </#if>
                    self.${instanceKey!}PropsData.filterColumns.find(col=>{
                        // 列筛查字段匹配表格列名，列名相同则覆盖原筛选下拉内容
                        const colProp = col.prop ? col.prop : col.field;
                        if(colProp === '${item.value}'){
                            col.options = options;
                            return true;
                        }
                    })
                    <#if viewId?? && viewId != "">
                        updateTableFilters(self.${instanceKey!}PropsData);
                    </#if>
                }
            }
        })
    <#else>
        const params${item_index} = {
            ${item.queryAttr!}
            <#if item.orders??>
                ${item.orders}
            </#if>
        }
        <#if item.queryConditions??>
            const queryConditions = self.${instanceKey!}${item.value!?cap_first}ColGetQueryConditions(params${item_index});
            if (queryConditions && queryConditions.length) {
            params${item_index}.superQueryConditionDto = queryConditions;
            }
        </#if>
        ${item.apiFileName!}.${item.importMethod!}(params${item_index}).then(res => {
            if (res.code === 200 || res.code === 10000) {
                const data = res?.data?.data;
                if(data?.length){
                <#if item.componentModelType?? && item.componentModelType == 'select' &&
                   item.selectValue?? && item.selectValue != '' &&
                   item.selectLabel?? && item.selectLabel != ''>
                    const options = data.map(opt => {
                        return {
                            name: opt.${item.selectLabel!},
                            value: opt.${item.selectValue!}
                        }
                    })
                <#elseif item.componentModelType?? && item.componentModelType == 'tree' &&
                    item.selectValue?? && item.selectValue != '' &&
                    item.selectLabel?? && item.selectLabel != '' &&
                    item.selectParentId?? && item.selectParentId != ''>
                    const options = formatModelToTreeData(data, (item)=>{
                     return {
                        id: item.${item.selectValue!},
                        label: item.${item.selectLabel!},
                        pid: item.${item.selectParentId!},
                        children: []
                     }
                    });
                <#else>
                    const options = [];
                </#if>
                    self.${instanceKey!}PropsData.filterColumns.find(col=>{
                        // 列筛查字段匹配表格列名，列名相同则覆盖原筛选下拉内容
                        const colProp = col.prop ? col.prop : col.field;
                        if(colProp === '${item.value}'){
                            col.options = options;
                            return true;
                        }
                    })
                    <#if viewId?? && viewId != "">
                        updateTableFilters(self.${instanceKey!}PropsData);
                    </#if>
                }
            }
        })
    </#if>
    <#else>
        const ${item.value} = self.${instanceKey!}PropsData.filterColumns.find((col) => col.prop ? col.prop === '${item.value}' : col.field === '${item.value}');
        if (${item.value}?.load) {
            ${item.value}.options = await ${item.value}.load({});
        }
    </#if>
</#list>
