<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-colgroup
                align="${item.bodyAlign!}"
                header-align="${item.align!}"
                title="${item.label!}"
                <#if item.width??>width="${item.width!}"</#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-colgroup>
        <#else>
            <#if item.colsMode?? && item.colsMode == 'colsCustom' &&  item.customCols?? && item.customCols != ''>
                <!-- ${instanceKey!}-${item.fieldName} #自定义表格列代码开始 -->
                ${item.customCols}
            <#elseif item.rowSummary?? && item.rowSummary>
                <vxe-table-column
                        :visible="page.editTableColumnShow('${instanceKey!}', '${item.prop!}')"
                        extension
                    <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit!>
                        align="${item.bodyAlign!}"
                    <#else >
                        align="noConfig"
                    </#if>
                        <#if item.tableLineBreak??>
                            <#if item.tableLineBreak != 'none'>
                                :show-overflow="true"
                            </#if>
                        <#else>
                            <#if tableLinesBreak??>
                                <#if tableLinesBreak != 'none'>
                                    :show-overflow="true"
                                </#if>
                            </#if>
                        </#if>
                        <#if item.headAlignIsEdit?? && item.headAlignIsEdit!>
                            header-align="${item.align!}"
                    <#else >
                            header-align="noConfig"
                        </#if>
                        field="${item.prop!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width = "${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.minWidth??>
                                :min-width="parseInt(${item.minWidth!}, 10)"
                            <#elseif item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 112>
                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                            <#else>
                                :min-width="150"
                            </#if>
                        </#if>
                        title="${item.label!}"
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                >
                    <#if item.rowCalculate??>
                        <#if item.rowCalculate.formulaId??>
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{$hussarFormat.bigNumberFormat(${item.rowCalculate.editFormulaReplace!}, '<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>')}}</span>
                            </template>
                        <#else >
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{$hussarFormat.bigNumberFormat(row.${item.prop!}, '<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>')}}</span>
                            </template>
                        </#if>
                    </#if>
                </vxe-table-column>
            <#elseif item.isShowConfig?? && item.isShowConfig!>
                <vxe-table-column
                        :visible="page.editTableColumnShow('${instanceKey!}', '${item.prop!}')"
                        extension
                        <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit!>
                            align="${item.bodyAlign!}"
                        <#else >
                            align="noConfig"
                        </#if>
                        <#if item.tableLineBreak??>
                            <#if item.tableLineBreak != 'none'>
                                :show-overflow="true"
                            </#if>
                        <#else>
                            <#if tableLinesBreak??>
                                <#if tableLinesBreak != 'none'>
                                    :show-overflow="true"
                                </#if>
                            </#if>
                        </#if>
                        <#if item.headAlignIsEdit?? && item.headAlignIsEdit!>
                            header-align="${item.align!}"
                        <#else >
                            header-align="noConfig"
                        </#if>
                        field="${item.prop!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width = "${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.minWidth??>
                                :min-width="parseInt(${item.minWidth!}, 10)"
                            <#elseif item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 112>
                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                            <#else>
                                :min-width="150"
                            </#if>
                        </#if>
                        title="${item.label!}"
                        <#if item.width??>width="${item.width!}"</#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                >
                <template v-slot="{ row }">
                <span class="vxe-cell--label">{{row.${item.prop!}}}</span>
                </template>
                </vxe-table-column>
            <#else>
                <vxe-table-column
                        :visible="page.editTableColumnShow('${instanceKey!}', '${item.prop!}')"
                        extension
                        <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit!>
                            align="${item.bodyAlign!}"
                        <#else >
                            align="noConfig"
                        </#if>
                        <#if item.tableLineBreak??>
                            <#if item.tableLineBreak != 'none'>
                                :show-overflow="true"
                            </#if>
                        <#else>
                            <#if tableLinesBreak??>
                                <#if tableLinesBreak != 'none'>
                                    :show-overflow="true"
                                </#if>
                            </#if>
                        </#if>
                        <#if item.headAlignIsEdit?? && item.headAlignIsEdit!>
                            header-align="${item.align!}"
                        <#else >
                            header-align="noConfig"
                        </#if>
                        field="${item.prop!}"
                        title="${item.label!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width = "${item.minWidth!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.minWidth??>
                                :min-width="parseInt(${item.minWidth!}, 10)"
                            <#elseif item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 112>
                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                            <#else>
                                :min-width="150"
                            </#if>
                        </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                        <#if item.colEditComponent?? && item.colEditComponent! == 'select'>
                            v-if="${instanceKey!}${item.prop!?cap_first}Options.length > 0"
                        </#if>
                        <#--可编辑列-->
                        :edit-render="${instanceKey!}EditRender_extension('${item.prop!}')"
                >
                    <#if item.instance?? && item.instance!>
                        <#if tableEditState?? && !tableEditState>
                            <template v-slot:edit="{ row: ${instanceKey!}Item, $rowIndex: ${instanceKey}Index }">
                                ${slotCodes[item.id]!}
                            </template>
                            <#if item.showParams?? && item.colEditComponent == 'com.jxdinfo.elementui.JXDElSelect'>
                                <template v-slot="{ row }">
                                    <span class="vxe-cell--label">{{ ${instanceKey!}ShowSelectValue(${item.showParams}, row.${item.prop!}, '${item.customLabel}', '${item.customValue}', ${item.selectMultiple?c}) }}</span>
                                </template>
                            <#elseif item.showParams?? && item.colEditComponent == 'com.jxdinfo.elementui.JXDElSelectTree'>
                                <template v-slot="{ row }">
                                    <span class="vxe-cell--label">{{ page.${instanceKey!}ShowTreeSelectValue(${item.showParams}, row.${item.prop!}) }}</span>
                                </template>
                            <#elseif item.showParams?? && item.colEditComponent == 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                                <template v-slot="{ row }">
                                    <span class="vxe-cell--label">{{ ${instanceKey!}ShowRegionValue(${item.showParams}, row.${item.prop!}, ${item.customLabel}) }}</span>
                                </template>
                            </#if>
                        <#else >
                            <template v-slot:edit="{ row: ${instanceKey!}Item, $rowIndex: ${instanceKey}Index }">
                                ${slotCodes[item.id]!}
                            </template>
                        </#if>
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'multipleUpload'>
                        <#if tableEditState?? && !tableEditState>
                            <template v-slot:edit="{ row }">
                                <h-img-upload-input :disabled="page.${instanceKey!}Disabled || page.${instanceKey!}_${item.prop!}Disabled" v-model="row.${item.prop!}" @onExceed="${instanceKey!}ImgExceed" @onUpload="${instanceKey!}ImgUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" :upload-api="${instanceKey}ImgUploadApi"
                                        <#if item.selectFormat?? && item.selectFormat.multipleImgNumber?? && item.selectFormat.multipleImgNumber?string != ''>
                                            :imgLimit="${item.selectFormat.multipleImgNumber}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :file="${instanceKey!}GetRowBlobList(row, '${item.prop!}', '${instanceKey!}${item.prop!}ImgFileBlobSrc')"
                                        :blob-list="row.${instanceKey!}${item.prop!}ImgFileBlobSrc"
                                >
                                    <template v-slot:imgViewer="config">
                                        <image-viewer v-if="config.isVisable" :urlList="config.urlList" :initialIndex="config.index" @close="config.close"></image-viewer>
                                    </template>
                                </h-img-upload-input>
                            </template>
                            <template v-slot="{ row }">
                                <div style="position: absolute;left: 10px; top: 4px;bottom: 4px;height: auto;width: calc(100% - 20px)">
                                    <h-show-img-field-input  :file="${instanceKey!}GetRowBlobList(row, '${item.prop!}', '${instanceKey!}${item.prop!}ImgFileBlobSrc')" :file-list="row.${instanceKey!}${item.prop!}ImgFileBlobSrc">
                                        <template v-slot:imgViewer="config">
                                            <image-viewer v-if="config.isVisable" :urlList="config.urlList" :initialIndex="config.index" @close="config.close"></image-viewer>
                                        </template>
                                    </h-show-img-field-input>
                                </div>
                            </template>
                        <#else >
                            <template v-slot:edit="{ row }">
                                <h-img-upload-input :disabled="page.${instanceKey!}Disabled || page.${instanceKey!}_${item.prop!}Disabled" v-model="row.${item.prop!}" @onExceed="${instanceKey!}ImgExceed" @onUpload="${instanceKey!}ImgUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" :upload-api="${instanceKey}ImgUploadApi"
                                        <#if item.selectFormat?? && item.selectFormat.multipleImgNumber?? && item.selectFormat.multipleImgNumber?string != ''>
                                            :imgLimit="${item.selectFormat.multipleImgNumber}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :file="${instanceKey!}GetRowBlobList(row, '${item.prop!}', '${instanceKey!}${item.prop!}ImgFileBlobSrc')"
                                        :blob-list="row.${instanceKey!}${item.prop!}ImgFileBlobSrc"
                                >
                                    <template v-slot:imgViewer="config">
                                        <image-viewer v-if="config.isVisable" :urlList="config.urlList" :initialIndex="config.index" @close="config.close"></image-viewer>
                                    </template>
                                </h-img-upload-input>
                            </template>
                        </#if>
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'attachmentUpload'>
                        <#if tableEditState?? && !tableEditState>
                            <template v-slot:edit="{ row }">
                                <h-file-upload-input :disabled="page.${instanceKey!}Disabled || page.${instanceKey!}_${item.prop!}Disabled" v-model="row.${item.prop!}" :attachDownLoad="${instanceKey!}FileInputDownLoad" @onDelete="${instanceKey!}FileInputDelete($event, row, '${item.prop!}')" @onUpload="${instanceKey!}FileUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" @onExceed="${instanceKey!}FileExceed"
                                        <#if item.selectFormat?? && item.selectFormat.uploadFileNumber?? && item.selectFormat.uploadFileNumber?string != ''>
                                            :fileLimit="${item.selectFormat.uploadFileNumber}"
                                        </#if>
                                        <#if item.selectFormat?? && item.selectFormat.uploadType?? && item.selectFormat.uploadType?string != ''>
                                            fileTypes="${item.selectFormat.uploadType}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :show-file-list="false"
                                ></h-file-upload-input>
                            </template>
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{ ${instanceKey!}FileUploadList(row.${item.prop!}) }}</span>
                            </template>
                        <#else >
                            <template v-slot:edit="{ row }">
                                <h-file-upload-input :disabled="page.${instanceKey!}Disabled || page.${instanceKey!}_${item.prop!}Disabled" v-model="row.${item.prop!}" :attachDownLoad="${instanceKey!}FileInputDownLoad" @onDelete="${instanceKey!}FileInputDelete($event, row, '${item.prop!}')" @onUpload="${instanceKey!}FileUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" @onExceed="${instanceKey!}FileExceed"
                                        <#if item.selectFormat?? && item.selectFormat.uploadFileNumber?? && item.selectFormat.uploadFileNumber?string != ''>
                                            :fileLimit="${item.selectFormat.uploadFileNumber}"
                                        </#if>
                                        <#if item.selectFormat?? && item.selectFormat.uploadType?? && item.selectFormat.uploadType?string != ''>
                                            fileTypes="${item.selectFormat.uploadType}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :show-file-list="false"
                                ></h-file-upload-input>
                            </template>
                        </#if>
                    </#if>
                    <#if item.colEditComponent?? && item.colComponent! == 'date' && tableEditState?? && !tableEditState && item.colEditComponent != 'com.jxdinfo.elementui.JXDElSelect' && item.colEditComponent! != 'attachmentUpload' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                        <template v-slot="{ row }">
                            <#if item.selectType?? && item.selectType.dateFmtSelect! == 'yyyy-WW周'>
                                <span class="vxe-cell--label">{{(row.${item.prop!}) ? $utils.toDateString(row.${item.prop!},'<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                            <#else>
                                <span class="vxe-cell--label">{{(row.${item.prop!}) ? $dayjs(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                            </#if>
                        </template>
                    <#elseif item.colEditComponent?? && item.colComponent! == 'number' && tableEditState?? && !tableEditState && item.colEditComponent != 'com.jxdinfo.elementui.JXDElSelect' && item.colEditComponent! != 'attachmentUpload' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $hussarFormat.bigNumberFormat(row.${item.prop!}, '<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                    <#elseif item.colEditComponent?? && item.colComponent! == 'boolean' && tableEditState?? && !tableEditState && item.colEditComponent != 'com.jxdinfo.elementui.JXDElSelect' && item.colEditComponent! != 'attachmentUpload' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? '是' : '否'}}</span>
                        </template>
                    </#if>
                </vxe-table-column>
            </#if>
        </#if>
    </#list>
</#macro>
<div data-role="fragment">
        <#--列表列-->
        <@editTree list= tableShowFields!></@editTree>
</div>