<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-colgroup
                align="${item.bodyAlign!}"
                header-align="${item.align!}"
                <#if item.titleType?? && item.titleType == "string">
                    title="${item.title!}"
                <#else >
                    :title="${item.title!}"
                </#if>
                <#if item.width??>width="${item.width!}"</#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-colgroup>
        <#else>
            <#if item.colsMode?? && item.colsMode == 'colsCustom' &&  item.customCols?? && item.customCols != ''>
                <!-- ${instanceKey!}-${item.fieldName} #自定义表格列代码开始 -->
                ${item.customCols}
                <!-- #自定义表格列代码结束 -->
            <#elseif item.colsMode?? && item.colsMode == 'isExtend' && item.signType! == 'start'>
                <!-- begin ${item.extendKey!} # 扩展组件 -->
                <h-extension-provider :ext-scope="PREFIX.extScope" extId="${item.extendKey!}"></h-extension-provider>
            <#elseif item.colsMode?? && item.colsMode == 'isExtend' && item.signType! == 'end'>
                <!-- end ${item.extendKey!} -->
            <#elseif item.rowSummary?? && item.rowSummary>
                <vxe-table-column
                    :visible="editTableColumnShow('${instanceKey!}', '${item.prop!}')"
                    <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit!>
                        align="${item.bodyAlign!}"
                    <#else >
                        align="noConfig"
                    </#if>
                        <#if item.tableLineBreak??>
                            <#if item.tableLineBreak != 'none'>
                                :show-overflow="true"
                            </#if>
                        <#else>
                            <#if tableLinesBreak??>
                                <#if tableLinesBreak != 'none'>
                                    :show-overflow="true"
                                </#if>
                            </#if>
                        </#if>
                        <#if item.headAlignIsEdit?? && item.headAlignIsEdit!>
                            header-align="${item.align!}"
                    <#else >
                            header-align="noConfig"
                        </#if>
                        field="${item.prop!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width = "${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.minWidth??>
                                :min-width="parseInt(${item.minWidth!}, 10)"
                            <#elseif item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 112>
                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                            <#else>
                                :min-width="150"
                            </#if>
                        </#if>
                        <#if item.titleType?? && item.titleType == "string">
                            title="${item.title!}"
                        <#else >
                            :title="${item.title!}"
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                >
                    <#if item.rowCalculate??>
                        <#if item.rowCalculate.formulaId??>
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{$hussarFormat.bigNumberFormat(${item.rowCalculate.editFormulaReplace!}, '<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>')}}</span>
                            </template>
                        <#else >
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{$hussarFormat.bigNumberFormat(row.${item.prop!}, '<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>')}}</span>
                            </template>
                        </#if>
                    </#if>
                </vxe-table-column>
            <#elseif item.isShowConfig?? && item.isShowConfig!>
                <vxe-table-column
                        :visible="editTableColumnShow('${instanceKey!}', '${item.prop!}')"
                        <#if item.colEditComponent?? && (item.colEditComponent! == 'multipleUpload' || item.colEditComponent! == 'attachmentUpload')>
                            class-name="__h_enable_column"
                        </#if>
                        <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit!>
                            align="${item.bodyAlign!}"
                        <#else >
                            align="noConfig"
                        </#if>
                        <#if item.tableLineBreak??>
                            <#if item.tableLineBreak != 'none'>
                                :show-overflow="true"
                            </#if>
                        <#else>
                            <#if tableLinesBreak??>
                                <#if tableLinesBreak != 'none'>
                                    :show-overflow="true"
                                </#if>
                            </#if>
                        </#if>
                        <#if item.headAlignIsEdit?? && item.headAlignIsEdit!>
                            header-align="${item.align!}"
                        <#else >
                            header-align="noConfig"
                        </#if>
                        field="${item.prop!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width = "${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.minWidth??>
                                :min-width="parseInt(${item.minWidth!}, 10)"
                            <#elseif item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 112>
                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                            <#else>
                                :min-width="150"
                            </#if>
                        </#if>
                        <#if item.titleType?? && item.titleType == "string">
                            title="${item.title!}"
                        <#else >
                            :title="${item.title!}"
                        </#if>
                        <#if item.width??>width="${item.width!}"</#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                >
                <template v-slot="{ row }">
                <span class="vxe-cell--label">{{row.${item.prop!}}}</span>
                </template>
                </vxe-table-column>
            <#else>
                <vxe-table-column
                        :visible="editTableColumnShow('${instanceKey!}', '${item.prop!}')"
                        <#if item.colEditComponent?? && (item.colEditComponent! == 'multipleUpload' || item.colEditComponent! == 'attachmentUpload')>
                            class-name="__h_enable_column"
                        <#elseif item.colEditComponent?? && item.colEditComponent! == 'dialog'>
                            :class-name='${instanceKey!}_${item.prop!}Disabled ? "__column_dis_dialog": ""'
                        </#if>
                        <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit!>
                            align="${item.bodyAlign!}"
                        <#else >
                            align="noConfig"
                        </#if>
                        <#if item.tableLineBreak??>
                            <#if item.tableLineBreak != 'none'>
                                :show-overflow="true"
                            </#if>
                        <#else>
                            <#if tableLinesBreak??>
                                <#if tableLinesBreak != 'none'>
                                    :show-overflow="true"
                                </#if>
                            </#if>
                        </#if>
                        <#if item.headAlignIsEdit?? && item.headAlignIsEdit!>
                            header-align="${item.align!}"
                        <#else >
                            header-align="noConfig"
                        </#if>
                        field="${item.prop!}"
                        <#if item.titleType?? && item.titleType == "string">
                            title="${item.title!}"
                        <#else >
                            :title="${item.title!}"
                        </#if>
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width = "${item.minWidth!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.minWidth??>
                                :min-width="parseInt(${item.minWidth!}, 10)"
                            <#elseif item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 112>
                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                            <#else>
                                :min-width="150"
                            </#if>
                        </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                        <#if item.colEditComponent?? && item.colEditComponent! == 'select'>
                            v-if="${instanceKey!}${item.prop!?cap_first}Options.length > 0"
                        </#if>
                        <#--可编辑列-->
                        :edit-render="${instanceKey!}EditRender('${item.prop!}')"
                >
                    <#if item.instance?? && item.instance!>
                        <#if tableEditState?? && !tableEditState>
                            <template v-slot:edit="{ row: ${instanceKey!}Item, $rowIndex: ${instanceKey}Index }">
                                ${slotCodes[item.id]!}
                            </template>
                            <#if item.showParams?? && item.colEditComponent == 'com.jxdinfo.elementui.JXDElSelect'>
                                <template v-slot="{ row }">
                                    <span class="vxe-cell--label">{{ ${instanceKey!}ShowSelectValue(${item.showParams}, row.${item.prop!}, '${item.customLabel}', '${item.customValue}', ${item.selectMultiple?c}) }}</span>
                                </template>
                            <#elseif item.showParams?? && item.colEditComponent == 'com.jxdinfo.elementui.JXDElSelectTree'>
                                <template v-slot="{ row }">
                                    <span class="vxe-cell--label">{{ ${instanceKey!}ShowTreeSelectValue(${item.showParams}, row.${item.prop!}) }}</span>
                                </template>
                            <#elseif item.showParams?? && item.colEditComponent == 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                                <template v-slot="{ row }">
                                    <span class="vxe-cell--label">{{ ${instanceKey!}ShowRegionValue(${item.showParams}, row.${item.prop!}, ${item.customLabel}) }}</span>
                                </template>
                            <#elseif item.colEditComponent == 'com.jxdinfo.elementui.JXDmultipleImgUpload' ||  item.colEditComponent == 'com.jxdinfo.elementui.HJXDElAttachmentUpload'>
                                <template v-slot="{ row }">
                                    <h-image-render
                                        :fileListStr="row['${item.prop!}']"
                                    />
                                </template>
                            <#elseif item.colEditComponent == 'com.jxdinfo.extendelement.JXDHUser' || item.colEditComponent == 'com.jxdinfo.extendelement.JXDHUserMulti'>
                               <template v-slot="{ row }">
                                   <h-staff-organ-render
                                       type="staff"
                                       :idListStr="row['${item.prop!}']"
                                   />
                               </template>
                           <#elseif item.colEditComponent == 'com.jxdinfo.extendelement.JXDHOrgan' || item.colEditComponent == 'com.jxdinfo.extendelement.JXDHOrganMulti'>
                              <template v-slot="{ row }">
                                  <h-staff-organ-render
                                      type="organ"
                                      :idListStr="row['${item.prop!}']"
                                  />
                              </template>
                            <#elseif item.colEditComponent == 'com.jxdinfo.elementui.JXDElHSign'>
                              <template v-slot="{ row }">
                                    <h-sign-render v-model="row['${item.prop!}']" />
                               </template>
                            </#if>
                        <#else >
                            <template v-slot:edit="{ row: ${instanceKey!}Item, $rowIndex: ${instanceKey}Index }">
                                ${slotCodes[item.id]!}
                            </template>
                        </#if>
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'multipleUpload'>
                        <#if tableEditState?? && !tableEditState>
                            <template v-slot:edit="{ row }">
                                <h-img-upload-input :disabled="${instanceKey!}Disabled || ${instanceKey!}_${item.prop!}Disabled" v-model="row.${item.prop!}" @onExceed="${instanceKey!}ImgExceed" @onUpload="${instanceKey!}ImgUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" :upload-api="${instanceKey}ImgUploadApi"
                                        <#if item.selectFormat?? && item.selectFormat.multipleImgNumber?? && item.selectFormat.multipleImgNumber?string != ''>
                                            :imgLimit="${item.selectFormat.multipleImgNumber}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :file="${instanceKey!}GetRowBlobList(row, '${item.prop!}', '${instanceKey!}${item.prop!}ImgFileBlobSrc')"
                                        :blob-list="row.${instanceKey!}${item.prop!}ImgFileBlobSrc"
                                >
                                    <template v-slot:imgViewer="config">
                                        <image-viewer v-if="config.isVisable" :urlList="config.urlList" :initialIndex="config.index" @close="config.close"></image-viewer>
                                    </template>
                                </h-img-upload-input>
                            </template>
                            <template v-slot="{ row }">
                                <div style="position: absolute;left: 10px; top: 4px;bottom: 4px;height: auto;width: calc(100% - 20px)">
                                    <h-show-img-field-input :file="${instanceKey!}GetRowBlobList(row, '${item.prop!}', '${instanceKey!}${item.prop!}ImgFileBlobSrc')" :file-list="row.${instanceKey!}${item.prop!}ImgFileBlobSrc">
                                        <template v-slot:imgViewer="config">
                                            <image-viewer v-if="config.isVisable" :urlList="config.urlList" :initialIndex="config.index" @close="config.close"></image-viewer>
                                        </template>
                                    </h-show-img-field-input>
                                </div>
                            </template>
                        <#else >
                            <template v-slot:edit="{ row }">
                                <h-img-upload-input :disabled="${instanceKey!}Disabled || ${instanceKey!}_${item.prop!}Disabled" v-model="row.${item.prop!}" @onExceed="${instanceKey!}ImgExceed" @onUpload="${instanceKey!}ImgUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" :upload-api="${instanceKey}ImgUploadApi"
                                        <#if item.selectFormat?? && item.selectFormat.multipleImgNumber?? && item.selectFormat.multipleImgNumber?string != ''>
                                            :imgLimit="${item.selectFormat.multipleImgNumber}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :file="${instanceKey!}GetRowBlobList(row, '${item.prop!}', '${instanceKey!}${item.prop!}ImgFileBlobSrc')"
                                        :blob-list="row.${instanceKey!}${item.prop!}ImgFileBlobSrc"
                                >
                                    <template v-slot:imgViewer="config">
                                        <image-viewer v-if="config.isVisable" :urlList="config.urlList" :initialIndex="config.index" @close="config.close"></image-viewer>
                                    </template>
                                </h-img-upload-input>
                            </template>
                        </#if>
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'attachmentUpload'>
                        <#if tableEditState?? && !tableEditState>
                            <template v-slot:edit="{ row }">
                                <h-file-upload-input v-model="row.${item.prop!}" :disabled="${instanceKey!}Disabled || ${instanceKey!}_${item.prop!}Disabled" :attachDownLoad="${instanceKey!}FileInputDownLoad" @onDelete="${instanceKey!}FileInputDelete($event, row, '${item.prop!}')" @onUpload="${instanceKey!}FileUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" @onExceed="${instanceKey!}FileExceed"
                                        <#if item.selectFormat?? && item.selectFormat.uploadFileNumber?? && item.selectFormat.uploadFileNumber?string != ''>
                                            :fileLimit="${item.selectFormat.uploadFileNumber}"
                                        </#if>
                                        <#if item.selectFormat?? && item.selectFormat.uploadType?? && item.selectFormat.uploadType?string != ''>
                                            fileTypes="${item.selectFormat.uploadType}"
                                        </#if>
                                         <#if item.selectFormat?? && item.selectFormat.fileUploadSize?? && item.selectFormat.fileUploadSize?string != ''>
                                            :fileUploadSize="${item.selectFormat.fileUploadSize}"
                                        </#if>
                                         <#if item.selectFormat?? && item.selectFormat.fileUploadUnit?? && item.selectFormat.fileUploadUnit?string != ''>
                                            fileUploadUnit="${item.selectFormat.fileUploadUnit}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :show-file-list="false"
                                ></h-file-upload-input>
                            </template>
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{ ${instanceKey!}FileUploadList(row.${item.prop!}) }}</span>
                            </template>
                        <#else >
                            <template v-slot:edit="{ row }">
                                <h-file-upload-input v-model="row.${item.prop!}" :disabled="${instanceKey!}Disabled || ${instanceKey!}_${item.prop!}Disabled" :attachDownLoad="${instanceKey!}FileInputDownLoad" @onDelete="${instanceKey!}FileInputDelete($event, row, '${item.prop!}')" @onUpload="${instanceKey!}FileUpload($event, row, '${item.prop!}')" :headers="${instanceKey!}Headers" @onExceed="${instanceKey!}FileExceed"
                                        <#if item.selectFormat?? && item.selectFormat.uploadFileNumber?? && item.selectFormat.uploadFileNumber?string != ''>
                                            :fileLimit="${item.selectFormat.uploadFileNumber}"
                                        </#if>
                                        <#if item.selectFormat?? && item.selectFormat.uploadType?? && item.selectFormat.uploadType?string != ''>
                                            fileTypes="${item.selectFormat.uploadType}"
                                        </#if>
                                        <#if item.realWidth??>
                                            width="${item.realWidth!}"
                                        <#else>
                                            <#if item.label?? && item.label?length gt 0 && item.label?length * tHeadFontSize gt 42>
                                                :min-width="${(item.label?length * tHeadFontSize + 38)}"
                                            <#else>
                                                :min-width="80"
                                            </#if>
                                        </#if>
                                        :show-file-list="false"
                                ></h-file-upload-input>
                            </template>
                        </#if>
                    </#if>
                    <#if item.colEditComponent?? && item.colComponent! == 'date' && tableEditState?? && !tableEditState && item.colEditComponent != 'com.jxdinfo.elementui.JXDElSelect' && item.colEditComponent! != 'attachmentUpload' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                        <template v-slot="{ row }">
                            <#if item.selectType?? && item.selectType.dateFmtSelect! == 'yyyy-WW周'>
                                <span class="vxe-cell--label">{{(row.${item.prop!}) ? $utils.toDateString(row.${item.prop!},'<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                            <#else>
                                <span class="vxe-cell--label">{{(row.${item.prop!}) ? $dayjs(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                            </#if>
                        </template>
                    <#elseif item.colEditComponent?? && item.colComponent! == 'number' && tableEditState?? && !tableEditState && item.colEditComponent != 'com.jxdinfo.elementui.JXDElSelect' && item.colEditComponent! != 'attachmentUpload' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $hussarFormat.bigNumberFormat(row.${item.prop!}, '<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                    <#elseif item.colEditComponent?? && item.colComponent! == 'boolean' && tableEditState?? && !tableEditState && item.colEditComponent != 'com.jxdinfo.elementui.JXDElSelect' && item.colEditComponent! != 'attachmentUpload' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'com.jxdinfo.extendelement.JXDElRegionSelect'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? '是' : '否'}}</span>
                        </template>
                    </#if>
                </vxe-table-column>
            </#if>
        </#if>
    </#list>
</#macro>
<div v-show="!${instanceKey}Hidden">
<h-edit-table
        :data="${instanceKey!}Data"
        <#if isDisabled??>:active-method="${instanceKey!}ActiveRowMethod"</#if>
        :props="${instanceKey!}PropsData"
        <#--列弹框展示-->
        <#if dialogFields?? && (dialogFields?size>0)>
            <#list dialogFields! as key>
                <#if (key??)>
                    @focus${key?cap_first}="${instanceKey!}${key?cap_first}EditEvent"
                </#if>
            </#list>
        </#if>
        <#--合计行触发事件-->
        <#if columnSummary?? && columnSummary>
            @input="${instanceKey!}UpdateFooterEvent"
        </#if>
        <#if columnStyle?? && columnStyle>
            :cell-style="${instanceKey!}CellStyle"
            :head-cell-style="${instanceKey!}HeadCellStyle"
        </#if>
        <#if isSortChange?? && isSortChange>
            @sort-change="${instanceKey!}SortChange"
            :sort-config="{ remote: true }"
        </#if>
        <#if isRenderOptions??>
            :render-options="${isRenderOptions!}"
        </#if>
        :innerStyles="${instanceKey!}InnerStylesData"
        :table-loading="${instanceKey!}TableLoading"
        :table-show-fields="${instanceKey!}tableShowFields"
        <#if columnSummary?? && columnSummary>
            :footer-method="${instanceKey!}ColumnSummaryEvent"
        </#if>
        theme-name="${styleSchemeClassName!'default'}"
        <#if editRulesFlag?? && editRulesFlag>
            :edit-rules="${instanceKey!}EditRules"
        </#if>
        <#if (disabled??)>
            :edit-disabled="${instanceKey!}Disabled"
        </#if>
        :key="${instanceKey!}TableKey"
        <#--选择项变化-->
        @radio-change="${instanceKey!}SelectRow"
        @checkbox-change="${instanceKey!}SelectRow"
        @checkbox-all="${instanceKey!}SelectAll"
>
    <template #default>
        <#--列表列-->
        <@editTree list= tableShowFields!></@editTree>
    </template>
        <#if needOperation?? && needOperation!>
            <template slot="needOperation">
                <vxe-table-column
                  align="center"
                  header-align="center"
                  show-overflow="ellipsis"
                  show-header-overflow="ellipsis"
                  :width="${instanceKey!}OptionWidth"
                  height="auto"
                  :fixed="${instanceKey!}NeedOperationFixed ? `right` : ''"
                  :class-name="${instanceKey!}NeedOperationClassName">
                  <template slot-scope="scope">
                    <div class="operation-btn">
                      <template v-for="(item, index) in ${instanceKey!}NeedOperations">
                        <el-button v-if="editTableBtnNotInMore(item, scope)"
                          :disabled="item.disabledFn ? item.disabledFn(scope.row) : false"
                          class="default-operation-btn jxd-button-item jxd_ins_elButton"
                          v-dynamic-min-width
                          :class="item.styleName"
                          v-bind="${instanceKey!}CustomAttrFiled(item)"
                          @click.native.stop="${instanceKey!}HandleNeedOperation(item, scope.row)">
                          <i class="btn-icon"
                            v-if="editTableBtnLeftIcon(item)"
                            :class="item.iconClassName"></i>
                          {{ item.label }}
                          <i class="btn-icon"
                            v-if="editTableBtnRightIcon(item)"
                            :class="item.iconClassName"></i>
                        </el-button>
                      </template>
                      <template v-if="${instanceKey!}ShowMoreBtn(scope)">
                          <el-dropdown class="lazy-container-buttons-right">
                            <!--更多按钮的样式参考第一个收入更多的按钮样式展示，若无styleName，参考主题上默认的文字按钮-->
                            <el-button
                             class="default-operation-btn jxd-button-item jxd_ins_elButton showMore"
                             :class="[ scope.row.moreBtnCols[0].styleName ? scope.row.moreBtnCols[0].styleName : 'elementui_JXDHTableV1_link_default']">
                              更多<i class="el-icon-arrow-down el-icon--right"></i>
                            </el-button>
                            <el-dropdown-menu class="__needoperation_showMore" slot="dropdown">
                              <template v-for="item in scope.row.moreBtnCols">
                                <el-dropdown-item
                                  :class="{'custom-button-container-is-disabled': editTableInMoreBtnDisabled(item, scope)}"
                                  :disabled="editTableInMoreBtnDisabled(item, scope)"
                                  @click.native.stop="${instanceKey!}HandleNeedOperation(item, scope.row)">
                                    <i class="btn-icon"
                                      v-if="editTableBtnLeftIcon(item)"
                                      :class="item.iconClassName"></i>
                                    {{ item.label.name ? item.label.name : item.label }}
                                    <i class="btn-icon"
                                      v-if="editTableBtnRightIcon(item)"
                                      :class="item.iconClassName"></i>
                                </el-dropdown-item>
                              </template>
                            </el-dropdown-menu>
                          </el-dropdown>
                      </template>
                    </div>
                  </template>
                  <template slot="header">
                    <#if (needOperationNameType == "string")>
                      ${needOperationName!}
                     <#elseif needOperationNameType == "newString">
                      ${needOperationNameInter!}
                      <#else>
                      {{ ${needOperationNameInter!} }}
                    </#if>
                    <div
                      class="h-table-draggable-item-line"
                      :data-fixed="${instanceKey!}NeedOperationFixed ? `right` : false"
                    ></div>
                  </template>
                </vxe-table-column>
            </template>
        </#if>
    <#--顶部按钮栏-->
    <#if topButton?? && topButton>
        <div slot="top-btn" class="top-btn-div">
            <template v-for="(item, index) in ${instanceKey!}TopButtons">
                <el-tooltip
                        :disabled="item.isOpen"
                        effect="light"
                        :content="item.label"
                        :visible-arrow="false"
                        placement="top">
                <el-button v-if="!item.showFn || item.showFn(item)"
                        :disabled="item.disabledFn ? item.disabledFn() : false"
                        class="default-operation-btn jxd-button-item jxd_ins_elButton"
                        :class="item.styleName"
                        v-dynamic-min-width
                        v-bind="${instanceKey!}CustomAttrFiled(item)"
                        @click.native.stop="${instanceKey!}HandleTopButton(item)"
                        @mouseenter.native="${instanceKey!}VisibilityChange($event, item)">
                    <i class="btn-icon"
                        v-if="editTableBtnLeftIcon(item)"
                        :class="item.iconClassName"></i>
                    {{ item.label }}
                    <i class="btn-icon"
                        v-if="editTableBtnRightIcon(item)"
                        :class="item.iconClassName"></i>
                </el-button>
                </el-tooltip>
            </template>
        </div>
    </#if>
</h-edit-table>
<#--分页组件-->
<#if isPagination?? && isPagination>
        <div class="page">
            <el-pagination
                background
            :key="${instanceKey!}paginationKey"
            @size-change="${instanceKey!}HandleSizeChange"
            @current-change="${instanceKey!}HandleCurrentChange"
            :page-size="${ListQuery}.size"
                <#if size?? && size! lt 10>
                :page-sizes="[${size?c!}, 10, 20, 50]"
                <#elseif size?? && size! gt 10 && size! lt 20>
                :page-sizes="[10, ${size?c!}, 20, 50]"
                <#elseif size?? && size! gt 20 && size! lt 50>
                :page-sizes="[10, 20, ${size?c!}, 50]"
                <#elseif size?? && size! gt 50>
                :page-sizes="[10, 20, 50, ${size?c!}]"
                <#else>
                :page-sizes="[10, 20, 50, 100]"
                </#if>
                <#if (layout??)>
                    :layout="${instanceKey!}Layout"
                </#if>
            :total="${TableTotal!}"
            :current-page="${ListQuery}.current">
        </el-pagination>
        </div>
</#if>
</div>
