<#macro editRender list>
    <#list list! as item>
        if(field === "${item.field!}") {
            return {
                <#if item.colEditComponent?? && item.colEditComponent! != '' && item.colEditComponent! !='empty' && item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'attachmentUpload' && item.instance?? && !item.instance!>
                    immediate: true,
                    <#--输入框-->
                    <#if item.colEditComponent?? && item.colEditComponent! == 'input' || item.colEditComponent! == 'dialog'>
                        name: 'input',
                        attrs: {type: 'text'},
                    <#--数字框-->
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'number'>
                        name: '$input',
                        props: {type: 'number'},
                    <#--日期-->
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'date'>
                        name: '$input',
                        props:{valueFormat: 'yyyy-MM-dd HH:mm:ss', type:'<#if item.selectFormat??>${item.selectFormat.dateFmtSelect!}</#if>'},
                    <#--下拉框-->
                    <#elseif item.colEditComponent?? && item.colEditComponent! == 'select'>
                        name: '$select',
                        props: {type: 'select'},
                        options: self.${instanceKey!}${item.field!?cap_first}Options,
                    </#if>
                     events: {
                        <#--合计行触发事件-->
                        <#if columnSummary?? && columnSummary>
                            input: self.${instanceKey!}UpdateFooterEvent,
                        </#if>
                        <#--数据展示替换-->
                        <#if item.showConfig?? && item.showConfig>
                            change: self.${instanceKey!}ReplaceData,
                        </#if>
                        <#--列弹框展示-->
                        <#if item.colEditComponent?? && item.colEditComponent! == 'dialog'>
                            focus: self.${instanceKey!}${item.field?cap_first}EditEvent,
                        </#if>
                    }
                <#elseif tableEditState?? && !tableEditState && item.colEditComponent?? && item.instance?? && !(item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'attachmentUpload' && !item.instance!)>
                    <#if item.colEditComponent == 'com.jxdinfo.elementui.JXDElSelect' || item.colEditComponent == 'com.jxdinfo.elementui.JXDElDateTimePicker' || item.colEditComponent == 'com.jxdinfo.elementui.JXDElInputNumber' || item.colEditComponent == 'com.jxdinfo.elementui.JXDElInput'>
                        type: 'default',
                        autofocus: 'input'
                    <#elseif item.colEditComponent == 'com.jxdinfo.extendelement.JXDElSwitch'>
                        type: 'visible'
                    <#else >
                        type: 'default'
                    </#if>
                <#elseif tableEditState?? && tableEditState && item.colEditComponent?? && item.instance?? && !(item.colEditComponent! != 'multipleUpload' && item.colEditComponent! != 'attachmentUpload' && !item.instance!)>
                    type: 'visible'
                </#if>
            };
        }
    </#list>
</#macro>

<@editRender list=allColumns!></@editRender>

<#if tableEditState?? && !tableEditState>
return {
    type: 'default'
    };
<#else>
return {
    type: 'visible'
    };
</#if>
