/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.constant.TaskFieldsConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.TableFieldUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDHTableV1.value")
@Scope(value="prototype")
public class HTableV1ValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONObject sumRow;
        Boolean sumRowExist;
        JSONArray colsJson = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
        JSONArray hiddenJson = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (ToolUtil.isNotEmpty((Object)colsJson)) {
            List colsList = TableFieldUtil.getRealAllTableFieldList(Collections.singletonList("opt_cols"), (LcdpComponent)this.lcdpComponent);
            colsList.forEach(col -> {
                if (!col.getRowSummary()) {
                    map.put(col.getId(), col.getField());
                }
            });
        }
        if (ToolUtil.isNotEmpty((Object)hiddenJson)) {
            List hiddenColsList = hiddenJson.toJavaList(TableOptColsAnalysis.class);
            hiddenColsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        if (null != (sumRowExist = (Boolean)this.lcdpComponent.getProps().get("columnSummary")) && sumRowExist.booleanValue() && null != (sumRow = (JSONObject)this.lcdpComponent.getProps().get("columnCalculate")) && ToolUtil.isNotEmpty((Object)sumRow.get((Object)"columnFields"))) {
            JSONArray columnFields = sumRow.getJSONArray("columnFields");
            for (int i = 0; i < columnFields.size(); ++i) {
                map.put(columnFields.getString(i), columnFields.getString(i));
            }
        }
        map.put("page", "current");
        map.put("pageSize", "size");
        map.put("total", "total");
        return map;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        ComponentData data = new ComponentData();
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        if ("formula".equals(eventParamConfig.getType())) {
            String renderValue = this.lcdpComponent.getEventParamInputParamSuffix(eventParamConfig.getEventParamType());
            Map<String, String> componentColMapping = this.getComponentColMapping();
            String configData = eventParamConfig.getConfigData();
            if (ToolUtil.isNotEmpty(componentColMapping) && ToolUtil.isNotEmpty((Object)componentColMapping.get(configData))) {
                String colField = componentColMapping.get(configData);
                if (ToolUtil.isNotEmpty((Object)colField)) {
                    data.setRenderValue(renderValue + "." + colField);
                } else {
                    data.setRenderValue(renderValue);
                }
            } else if (ToolUtil.isNotEmpty((Object)configData)) {
                if (DataFromEnum.PROPERTY.getValue().equals(configData)) {
                    data.setRenderValue("property");
                } else {
                    data.setRenderValue(configData);
                }
            } else {
                data.setRenderValue(renderValue);
            }
        } else {
            data.setDataType(eventParamConfig.getDataType());
            String renderValue = this.lcdpComponent.getEventParamInputParamSuffix(eventParamConfig.getEventParamType());
            if (eventParamConfig.getEventParamData().size() > 1) {
                String[] taskFields;
                String colField;
                Map<String, String> componentColMapping = this.getComponentColMapping();
                if (ToolUtil.isNotEmpty(componentColMapping) && ToolUtil.isNotEmpty((Object)componentColMapping.get(eventParamConfig.getEventParamData().get(1))) && ToolUtil.isNotEmpty((Object)(colField = componentColMapping.get(eventParamConfig.getEventParamData().get(1))))) {
                    data.setRenderValue(renderValue + "." + colField);
                }
                for (String taskField : taskFields = TaskFieldsConstant.TASK_FIELDS) {
                    String colField2;
                    if (!taskField.equals(eventParamConfig.getEventParamData().get(1)) || !ToolUtil.isNotEmpty((Object)(colField2 = (String)eventParamConfig.getEventParamData().get(1)))) continue;
                    data.setRenderValue(renderValue + "." + colField2);
                }
            } else if (DataFromEnum.PROPERTY.getValue().equals(eventParamConfig.getEventParamData().get(0))) {
                data.setRenderValue("property");
            } else if ("data".equals(eventParamConfig.getEventParamData().get(0))) {
                data.setRenderValue(renderValue);
            } else {
                data.setRenderValue((String)eventParamConfig.getEventParamData().get(0));
            }
        }
        return data;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "[]";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "summaryTotal": {
                    this.getSummaryTotalData(dataItems, data);
                    break;
                }
                case "summary": {
                    this.getSummaryData(dataItems, data);
                    break;
                }
                case "pagination": {
                    this.getPageData(dataItems, data);
                    break;
                }
                case "total": {
                    data.setDataType(ComponentData.DataTypeEnum.INTEGER);
                    data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_TOTAL.getType(), dataItems));
                    break;
                }
                case "data": 
                case "value": {
                    this.getSelectAndTableData(dataItems, data, dataItem);
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("value");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem));
        }
        return data;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    private void getSelectAndTableData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String dataValue;
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        if (dataItem.equals("data")) {
            currDataItem.add("data");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_DATA_CHECKED.getType(), currDataItem);
        } else {
            currDataItem.add("value");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem);
        }
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
            JSONArray hiddenCols = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
            this.getOptColData(dataItems, data, dataValue, cols);
            this.getHiddenColData(dataItems, data, dataValue, hiddenCols);
            this.getTaskSysColData(dataItems, data, dataValue);
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getTaskSysColData(List<String> dataItems, ComponentData data, String dataValue) {
        String[] taskFields;
        for (String taskField : taskFields = TaskFieldsConstant.TASK_FIELDS) {
            if (!taskField.equals(dataItems.get(1))) continue;
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => {\nif (item." + taskField + ") {\nresult.push(item." + taskField + ");}\n});return result;}()");
            break;
        }
    }

    private void getHiddenColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray hiddenCols) {
        if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
            List hiddenColsList = hiddenCols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : hiddenColsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                data.setDataType(col.getDataType());
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }

    private void getOptColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray cols) {
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List colsList = TableFieldUtil.getRealAllTableFieldList(Collections.singletonList("opt_cols"), (LcdpComponent)this.lcdpComponent);
            for (TableOptColsAnalysis col : colsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                if (col.getRowSummary() && ToolUtil.isNotEmpty((Object)col.getRowCalculate())) {
                    String colTemp = "";
                    colTemp = ToolUtil.isNotEmpty((Object)col.getRowCalculate().getEditFormulaReplace()) ? col.getRowCalculate().getEditFormulaReplace() : "row." + col.getField();
                    data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((row) => result.push(" + colTemp + "));return result;}()");
                    break;
                }
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }

    private void getPageData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> pageDataItem = new ArrayList<String>();
        pageDataItem.add("pagination");
        String pageValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_PAGE_DATA.getType(), pageDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.INTEGER);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            if ("page".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".current");
            } else if ("pageSize".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".size");
            } else if ("total".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".TableTotal");
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(pageValue);
        }
    }

    private void getSummaryData(List<String> dataItems, ComponentData data) {
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.DOUBLE);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + "ColumnFieldsAssignment." + dataItems.get(1).replace("sum(", "").replace(")", ""));
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + "ColumnFieldsAssignment");
        }
    }

    private void getSummaryTotalData(List<String> dataItems, ComponentData data) {
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.DOUBLE);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + "SummaryTotalAssignment." + dataItems.get(1).replace("sum(", "").replace(")", ""));
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + "SummaryTotalAssignment");
        }
    }

    private JSONArray getAllCols(JSONArray cols) {
        JSONArray allCols = new JSONArray();
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            if (Boolean.TRUE.equals(colObj.getBoolean("isParent"))) {
                JSONArray allChildCols = this.getAllCols(colObj.getJSONArray("children"));
                for (Object childCol : allChildCols) {
                    JSONObject childColObj = (JSONObject)childCol;
                    allCols.add((Object)childColObj);
                }
                continue;
            }
            allCols.add((Object)colObj);
        }
        return allCols;
    }

    private String isThisCol(List<String> dataItems, JSONObject colObj) {
        if (colObj.getString("id").equals(dataItems.get(1))) {
            if (dataItems.size() == 3 && "tableAddAssignment".equals(dataItems.get(2))) {
                return "data." + colObj.getString("field");
            }
            if (Boolean.TRUE.equals(colObj.getBoolean("rowSummary")) && ToolUtil.isNotEmpty((Object)colObj.get((Object)"rowCalculate"))) {
                return "function(){\nlet result = '';self." + this.lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_DATA_CHECKED.getType() + '.' + "forEach((row) => result +=`${" + colObj.getJSONObject("rowCalculate").getString("editFormulaReplace") + "},`);return result.substring(0,result.length-1);}()";
            }
            return "function(){\nlet result = '';self." + this.lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_DATA_CHECKED.getType() + '.' + "forEach((item) => result +=`${item." + colObj.getString("field") + "},`);return result.substring(0,result.length-1);}()";
        }
        return "false";
    }
}

