/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.update;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComparableVersionUtil;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.formdesign.upgrade.factory.UpgradeFactory;
import com.jxdinfo.hussar.formdesign.upgrade.service.UpdateConfigService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class VueUpdateConfigServiceImpl
implements UpdateConfigService {
    private List<UpgradeConfig> upgradeConfig;
    @Resource
    private LcdpVersionProperties lcdpVersionProperties;

    @PostConstruct
    public void register() {
        UpgradeFactory.registerUpgrade((String)"vue", VueUpdateConfigServiceImpl.class);
    }

    public List<UpgradeConfig> getUpgradeConfig() {
        if (this.upgradeConfig == null) {
            String updateConfigs = ToolUtil.loadResource(this.getClass(), (String)"/updateConfigs.json");
            this.upgradeConfig = HussarUtils.isNotBlank((CharSequence)updateConfigs) ? JSONArray.parseArray((String)updateConfigs, UpgradeConfig.class).stream().filter(config -> new ComparableVersionUtil(this.lcdpVersionProperties.getLcdpVersion()).compareTo(new ComparableVersionUtil(config.getUpgradeVersion())) >= 0).collect(Collectors.toList()) : new ArrayList<UpgradeConfig>();
        }
        return this.upgradeConfig;
    }

    public List<UpgradeConfig> queryConfigsByPage(String currentVersion, List<String> replacedId) {
        List<UpgradeConfig> upgradeConfigs;
        if (replacedId == null) {
            replacedId = new ArrayList<String>();
        }
        if (HussarUtils.isEmpty(upgradeConfigs = this.getUpgradeConfig())) {
            return new ArrayList<UpgradeConfig>();
        }
        List<String> finalReplacedId = replacedId;
        List<Object> resultConfigs = upgradeConfigs.stream().filter(config -> !finalReplacedId.contains(config.getUpgradeId())).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty((Object)currentVersion)) {
            resultConfigs = resultConfigs.stream().filter(config -> new ComparableVersionUtil(currentVersion).compareTo(new ComparableVersionUtil(config.getUpgradeVersion())) < 0).collect(Collectors.toList());
        }
        return resultConfigs;
    }

    public List<UpgradeConfig> queryConfigs(List<UpgradeConfig> upgradeConfigs, String componentName) {
        if (HussarUtils.isEmpty(upgradeConfigs)) {
            return new ArrayList<UpgradeConfig>();
        }
        if (ToolUtil.isEmpty((Object)componentName)) {
            return new ArrayList<UpgradeConfig>();
        }
        List<UpgradeConfig> resultConfigs = upgradeConfigs.stream().filter(config -> HussarUtils.equals((Object)config.getComponentCode(), (Object)componentName)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(resultConfigs)) {
            HashSet<String> pIds = new HashSet<String>();
            for (UpgradeConfig config2 : resultConfigs) {
                if (!HussarUtils.isNotEmpty((Object)config2.getpId())) continue;
                pIds.add(config2.getpId());
            }
            resultConfigs.addAll(this.getPid(pIds, this.upgradeConfig));
        }
        return resultConfigs;
    }

    private List<UpgradeConfig> getPid(Set<String> ids, List<UpgradeConfig> upgradeConfig) {
        List<UpgradeConfig> upgradeConfigs = upgradeConfig.stream().filter(config -> ids.contains(config.getUpgradeId())).collect(Collectors.toList());
        HashSet<String> pIds = new HashSet<String>();
        for (UpgradeConfig config2 : upgradeConfigs) {
            if (!HussarUtils.isNotEmpty((Object)config2.getpId())) continue;
            pIds.add(config2.getpId());
        }
        if (HussarUtils.isNotEmpty(ids)) {
            upgradeConfigs.addAll(this.getPid(pIds, upgradeConfig));
        }
        return upgradeConfigs;
    }
}

