/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.extend.parser;

import com.jxdinfo.hussar.formdesign.common.constant.ExtendScriptTypeEnum;
import com.jxdinfo.hussar.formdesign.common.model.script.ExtendWScript;
import com.jxdinfo.hussar.formdesign.common.parser.ScriptParser;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.elementui.extend.model.ExtendWVue;
import com.jxdinfo.hussar.formdesign.extend.factory.ScriptParseFactory;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueEvent;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueEventParam;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueProp;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class VueParser
implements ScriptParser {
    private static final Pattern PROP_PATTERN = Pattern.compile("(props)(:)(\\s*)(\\{([\\s\\S]*)\\},)");
    private static final Pattern METHOD_NAME_PARAM_PATTERN = Pattern.compile("(\\$emit)(\\s*)(\\((.*?)\\))");
    private static final Pattern NAME_PATTERN = Pattern.compile("(@name)(.*?)(\\*)");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(@description)(.*?)(\\*)");

    @PostConstruct
    public void register() {
        ScriptParseFactory.register((String)ExtendScriptTypeEnum.VUE_SCRIPT.getType(), (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public ExtendWScript parseScript(String editorNote) {
        ExtendWVue extendWVue = new ExtendWVue();
        ArrayList<ExtendCustomVueProp> props = new ArrayList<ExtendCustomVueProp>();
        ArrayList<ExtendCustomVueEvent> events = new ArrayList<ExtendCustomVueEvent>();
        if (StringUtil.isEmpty((Object)(editorNote = ParsingUtil.removeAnnotation((String)editorNote)))) {
            extendWVue.setEvents(events);
            extendWVue.setProps(props);
            return extendWVue;
        }
        Matcher propsMather = PROP_PATTERN.matcher(editorNote);
        StringBuilder propGroup = new StringBuilder();
        while (propsMather.find()) {
            String str = propsMather.group();
            String newStr = propsMather.group();
            str = new StringBuilder(str).replace(str.indexOf("{"), str.indexOf("{") + 1, " ").toString();
            while (str.indexOf("{") < str.indexOf("}")) {
                StringBuilder sb = new StringBuilder(str);
                sb.replace(str.indexOf("{"), str.indexOf("{") + 1, " ");
                sb.replace(str.indexOf("}"), str.indexOf("}") + 1, " ");
                str = sb.toString();
            }
            newStr = newStr.substring(newStr.indexOf("{") + 1, str.indexOf("}"));
            propGroup.append(newStr);
        }
        if (StringUtil.isEmpty((Object)propGroup.toString())) {
            extendWVue.setEvents(events);
            extendWVue.setProps(props);
            return extendWVue;
        }
        String[] prop = propGroup.toString().replaceAll("\n*", "").replace(" ", "").replaceAll("default:\\s*'[^']*'\\s*,?", "").split(",");
        for (int i = 0; i < prop.length; ++i) {
            String[] propss;
            ExtendCustomVueProp extendCustomVueProp = new ExtendCustomVueProp();
            if (prop[i].contains("}") && !prop[i].contains("{")) continue;
            if (prop[i].contains("{")) {
                if (prop[i].contains("type")) {
                    propss = prop[i].split(":");
                    extendCustomVueProp.setName(propss[0]);
                    extendCustomVueProp.setType(propss[2]);
                } else {
                    propss = prop[i].split(":");
                    extendCustomVueProp.setName(propss[0]);
                    String[] propsss = prop[i + 1].split(":");
                    extendCustomVueProp.setType(propsss[1].replace("}", ""));
                }
            } else {
                propss = prop[i].split(":");
                extendCustomVueProp.setName(propss[0]);
                extendCustomVueProp.setType(propss[1]);
            }
            props.add(extendCustomVueProp);
        }
        Matcher emitMethodMather = METHOD_NAME_PARAM_PATTERN.matcher(editorNote);
        StringBuilder emitMethodGroup = new StringBuilder();
        while (emitMethodMather.find()) {
            emitMethodGroup.append(emitMethodMather.group());
        }
        String[] emitMethodName = emitMethodGroup.toString().split("(\\$)");
        ArrayList<String> methodNames = new ArrayList<String>();
        for (String s : emitMethodName) {
            if (!ToolUtil.isNotEmpty((Object)s)) continue;
            if (s.indexOf(",") > 0) {
                s = s.substring(s.indexOf("(") + 1, s.indexOf(","));
                s = s.trim().substring(1, s.length() - 1);
            } else {
                s = s.substring(s.indexOf("(") + 1, s.indexOf(")"));
                s = s.trim().substring(1, s.length() - 1);
            }
            methodNames.add(s);
        }
        List<String> method = Arrays.asList(emitMethodName);
        String cname = "(@name)(.*?)(\\$emit)(\\s*)(\\((.*?)\\))";
        Pattern cnamePattern = Pattern.compile(cname);
        Matcher nameNotesMatcher = cnamePattern.matcher(editorNote);
        StringBuilder nameNotesGroup = new StringBuilder();
        while (nameNotesMatcher.find()) {
            nameNotesGroup.append(nameNotesMatcher.group());
        }
        String[] chineseNames = null;
        String[] chineseNameMethodName = null;
        if (!ToolUtil.isEmpty((Object)nameNotesGroup)) {
            Matcher nameMatcher = NAME_PATTERN.matcher(nameNotesGroup.toString());
            StringBuilder chineseNameGroup = new StringBuilder();
            while (nameMatcher.find()) {
                chineseNameGroup.append(nameMatcher.group());
            }
            chineseNames = chineseNameGroup.toString().replaceAll("\\*", "&&,&&,&&").replaceAll("@name", "").split("&&,&&,&&");
            Matcher chineseNameMatcher = METHOD_NAME_PARAM_PATTERN.matcher(nameNotesGroup.toString());
            StringBuilder chineseGroup = new StringBuilder();
            while (chineseNameMatcher.find()) {
                chineseGroup.append(chineseNameMatcher.group());
            }
            chineseNameMethodName = chineseGroup.toString().replaceAll(" ", "").split("\\$");
        }
        String desc = "(@description)(.*?)(\\$emit)(\\s*)(\\((.*?)\\))";
        Pattern descPattern = Pattern.compile(desc);
        Matcher descriptionNotesMatcher = descPattern.matcher(editorNote);
        StringBuilder descriptionNotesGroup = new StringBuilder();
        while (descriptionNotesMatcher.find()) {
            descriptionNotesGroup.append(descriptionNotesMatcher.group());
        }
        String[] descriptions = null;
        String[] descriptionMethodName = null;
        if (!ToolUtil.isEmpty((Object)descriptionNotesGroup)) {
            Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(descriptionNotesGroup.toString());
            StringBuilder descriptionGroup = new StringBuilder();
            while (descriptionMatcher.find()) {
                descriptionGroup.append(descriptionMatcher.group());
            }
            descriptions = descriptionGroup.toString().replaceAll("\\*", "&&,&&,&&").replaceAll("@description", "").trim().split("&&,&&,&&");
            Matcher functionDescriptionMatcher = METHOD_NAME_PARAM_PATTERN.matcher(descriptionNotesGroup.toString());
            StringBuilder functionDescriptionGroup = new StringBuilder();
            while (functionDescriptionMatcher.find()) {
                functionDescriptionGroup.append(functionDescriptionMatcher.group());
            }
            descriptionMethodName = functionDescriptionGroup.toString().replaceAll(" ", "").split("\\$");
        }
        for (int i = 0; i < method.size(); ++i) {
            String[] paramDescription;
            if (ToolUtil.isEmpty((Object)method.get(i))) continue;
            ExtendCustomVueEvent extendCustomVueEvent = new ExtendCustomVueEvent();
            ArrayList paramList = new ArrayList();
            String param = "(@param)(.*?)(\\$emit)(\\s*)(\\((.*?)\\))";
            Pattern paramPattern = Pattern.compile(param);
            Matcher paramMatcher = paramPattern.matcher(editorNote);
            StringBuilder paramGroup = new StringBuilder();
            while (paramMatcher.find()) {
                paramGroup.append(paramMatcher.group()).append("&&,&&,&&");
            }
            for (String s : paramDescription = paramGroup.toString().replaceAll("@param ", "").replaceAll("\\*\\/", "&&;&&").replaceAll("\\*", "&&&&").split("&&,&&,&&")) {
                if (ToolUtil.isEmpty((Object)s)) continue;
                String[] MethodParamNotes = s.split("&&;&&")[0].trim().split("&&&&");
                ArrayList<ExtendCustomVueEventParam> paramLists = new ArrayList<ExtendCustomVueEventParam>();
                for (String sss : method) {
                    if (ToolUtil.isEmpty((Object)sss)) continue;
                    for (int j = 0; j < MethodParamNotes.length; ++j) {
                        ExtendCustomVueEventParam extendCustomVueEventParam = new ExtendCustomVueEventParam();
                        String[] MethodParamNotess = MethodParamNotes[j].trim().split(" ");
                        String[] oneMethodParamNotes = new String[]{"", "", ""};
                        System.arraycopy(MethodParamNotess, 0, oneMethodParamNotes, 0, MethodParamNotess.length);
                        if (s.split("&&;&&")[1].contains(sss.trim())) {
                            if (ToolUtil.isEmpty((Object)oneMethodParamNotes[0])) {
                                extendCustomVueEventParam.setType("String");
                            } else if (oneMethodParamNotes[0].contains("{") && oneMethodParamNotes[0].contains("}")) {
                                extendCustomVueEventParam.setType(oneMethodParamNotes[0].substring(oneMethodParamNotes[0].indexOf("{") + 1, oneMethodParamNotes[0].indexOf("}")));
                            }
                            if (ToolUtil.isEmpty((Object)oneMethodParamNotes[1])) {
                                extendCustomVueEventParam.setName("eventParam" + (j + 1));
                            } else {
                                extendCustomVueEventParam.setName(oneMethodParamNotes[1]);
                            }
                            extendCustomVueEventParam.setAnnotation(oneMethodParamNotes[2]);
                            extendCustomVueEventParam.setDesc(oneMethodParamNotes[2]);
                        }
                        paramLists.add(extendCustomVueEventParam);
                    }
                }
                if (!s.split("&&;&&")[1].contains(method.get(i))) continue;
                paramList.addAll(paramLists);
            }
            extendCustomVueEvent.setParams(paramList);
            if (descriptionMethodName != null) {
                for (int j = 0; j < descriptionMethodName.length; ++j) {
                    if (!descriptionMethodName[j].equals(method.get(i).replaceAll(" ", "")) || !ToolUtil.isNotEmpty((Object)descriptionMethodName[j].replaceAll(" ", ""))) continue;
                    extendCustomVueEvent.setDesc(descriptions[j - 1].trim());
                    extendCustomVueEvent.setName((String)methodNames.get(i - 1));
                }
            }
            if (chineseNameMethodName != null) {
                for (int j = 0; j < chineseNameMethodName.length; ++j) {
                    if (!chineseNameMethodName[j].equals(method.get(i).replaceAll(" ", "")) || !ToolUtil.isNotEmpty((Object)chineseNameMethodName[j].replaceAll(" ", ""))) continue;
                    extendCustomVueEvent.setAnnotation(chineseNames[j - 1].trim());
                }
            }
            events.add(extendCustomVueEvent);
        }
        if (StringUtil.isEmpty((Object)propGroup.toString())) {
            extendWVue.setEvents(events);
            extendWVue.setProps(props);
            return extendWVue;
        }
        extendWVue.setEvents(events);
        extendWVue.setProps(props);
        return extendWVue;
    }
}

