/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.extend.cascade;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.JsScript.cascade")
public class JsCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.JsScript.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldfilePath = this.getOldVuePath(baseFile.getId(), strategy);
        String newFilePath = this.getNeWVuePath(baseFile.getId(), baseFile.getName(), strategy);
        File newFile = new File(newFilePath);
        File oldFile = new File(oldfilePath);
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeDelete(String id) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File file = new File(oldVueFilePath);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
                ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
                resourceCascadeService.deleteVuePublishFile(id);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldVueFilePath);
            }
        }
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String modelPath = fileMappingService.getFormatPath(id);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String extendScriptPath = pathStrategy.vuePathService().getExtendScriptPath();
        String rootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{extendScriptPath});
        return FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendJavaScriptPath(), modelPath + ".js"});
    }

    String getNeWVuePath(String id, String pageName, Integer strategy) throws LcdpException {
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String modelPath = fileMappingService.getFormatParentPath(id);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String extendScriptPath = pathStrategy.vuePathService().getExtendScriptPath();
        String rootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{extendScriptPath});
        return FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendJavaScriptPath(), modelPath, pageName + ".js"});
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }
}

