/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientKind(kind="com.jxdinfo.Module.cascade")
public class ModuleCascadeImpl
implements ResourceCascadeVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ModuleCascadeImpl.class);
    public static final String KIND = "com.jxdinfo.Module.cascade";
    private static final String CASCADE_PROCESSING_WARNING = "\u8b66\u544a: {}\uff0c\u5df2\u8df3\u8fc7\u8be5\u5904\u7406\u6b65\u9aa4";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String path = this.getMetaPath(baseFile.getId());
        String parentPath = this.getMetaPath(baseFile.getParentId());
        File newFile = new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getName(), rootPath));
        File oldFile = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        this.moduleEdit(oldFile, newFile);
        String apiRootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getFrontApiPath()});
        String apiPath = this.getMetaPath(baseFile.getId());
        String apiParentPath = this.getMetaPath(baseFile.getParentId());
        File apiNewFile = new File(this.relativeToAbsolute(apiParentPath + File.separator + baseFile.getName(), apiRootPath));
        File apiOldFile = new File(FileUtil.systemPath((String[])new String[]{apiRootPath, apiPath}));
        this.moduleEdit(apiOldFile, apiNewFile);
        String extendRootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getExtendScriptPath()});
        File extendnewFile = new File(extendRootPath);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        this.iteratorDirectory(extendnewFile, baseFile, fileMappingService.getFileName(baseFile.getId()));
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeEdit(baseFile);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeEdit(baseFile);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        String oldbackJavaPath = FileUtil.systemPath((String[])new String[]{pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), fileMappingService.getFormatPath(baseFile.getId())});
        File oldJavaPath = new File(oldbackJavaPath);
        String newbackJavaPath = FileUtil.systemPath((String[])new String[]{pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), this.getMetaPath(baseFile.getParentId()), baseFile.getName()});
        File newJavaPath = new File(newbackJavaPath);
        this.moduleEdit(oldJavaPath, newJavaPath);
    }

    public void iteratorDirectory(File extendnewFile, BaseFile baseFile, String oldName) {
        if (ToolUtil.isNotEmpty((Object)extendnewFile) && ToolUtil.isNotEmpty((Object)FileUtils.listFiles((File)extendnewFile))) {
            for (File file : FileUtils.listFiles((File)extendnewFile)) {
                if (!FileUtils.isDirectory((File)file)) continue;
                if (file.getName().equals(oldName)) {
                    File newFile = new File(file.getParent() + File.separator + baseFile.getName());
                    if (FileUtils.exists((File)newFile)) continue;
                    this.fixName(file, newFile);
                    continue;
                }
                this.iteratorDirectory(file, baseFile, oldName);
            }
        }
    }

    public void moduleEdit(File oldFile, File newFile) {
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String path = this.getMetaPath(id);
        String parentPath = this.getMetaPath(parentId);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && parentPath.length() > path.length()) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.forceMkdir((File)to);
            }
            FileUtils.copyDirectoryToDirectory((File)from, (File)to);
        }
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeCopy(id, newId, newName, parentId);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeCopy(id, newId, newName, parentId);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String parentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, parentPath, rootPath, newName, parentId);
        String apiRootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getFrontApiPath()});
        String apiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, apiParentPath, apiRootPath, newName, parentId);
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeMove(id, newName, parentId);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeMove(id, newName, parentId);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), fileMappingService.getFormatPath(id)});
        File javaFrom = new File(backJavaPath);
        File javaTo = new File(this.relativeToAbsolute(parentPath, pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath()));
        if (FileUtils.exists((File)javaFrom)) {
            if (!FileUtils.exists((File)javaTo)) {
                FileUtils.forceMkdir((File)javaTo);
            }
            if (!FileUtils.exists((File)(javaTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName, pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath()))))) {
                FileUtils.moveDirectory((File)javaFrom, (File)javaTo);
            } else {
                FileUtils.moveFileToDirectory((File)javaFrom, (File)javaTo, (boolean)false);
            }
        }
    }

    public void moveFrontFile(String id, String parentPath, String rootPath, String newName, String parentId) throws LcdpException, IOException {
        String path = this.getMetaPath(id);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.moveDirectory((File)from, (File)to);
            } else {
                FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)false);
            }
        }
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        BaseFile baseFile = fileMappingService.getPageInfoById(parentId);
        if (ToolUtil.isNotEmpty((Object)baseFile) && !"#".equals(baseFile.getParentId())) {
            if (id.equals(baseFile.getId())) {
                return true;
            }
            return this.copyCheck(id, baseFile.getParentId());
        }
        return false;
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        String saveJavaFilePathPrefix;
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getVueCodePath(strategy)})});
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        String path = this.getMetaPath(id);
        File f = new File(this.relativeToAbsolute(path, rootPath));
        this.moduleDelete(f);
        String apiRootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getFrontApiPath()});
        File apif = new File(this.relativeToAbsolute(path, apiRootPath));
        this.moduleDelete(apif);
        String extendRootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getExtendScriptPath()});
        this.extendModuleDelete(extendRootPath, path);
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeDelete(id);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        try {
            CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeDelete(id);
        }
        catch (RuntimeException e) {
            logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
        }
        File code = new File(FileUtil.posixPath((String[])new String[]{pathStrategy.resourcePathService().getProjectAndCodePath(), path}));
        this.iteratorFile(code);
        String backProjectPath = pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath();
        File bf = new File(this.relativeToAbsolute(path, backProjectPath));
        if (FileUtils.exists((File)bf)) {
            try {
                FileUtils.forceDelete((File)bf);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, bf.getAbsolutePath());
            }
        }
        if (FileUtils.exists((File)new File(saveJavaFilePathPrefix = pathStrategy.javaPathService().backProjectJava(new String[]{"bpmvisitor", path}).getLocalPath().toLowerCase()))) {
            FileUtils.forceDelete((File)new File(saveJavaFilePathPrefix));
        }
        ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
        resourceCascadeService.deleteModulePublishFile(id);
    }

    private void moduleDelete(File f) throws LcdpException {
        if (FileUtils.exists((File)f)) {
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
            }
        }
    }

    private void extendModuleDelete(String rootPath, String path) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String jsPath = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendJavaScriptPath(), path});
        this.moduleDelete(new File(jsPath));
        String vuePath = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendVuePath(), path});
        this.moduleDelete(new File(vuePath));
        String cssPath = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendCssScriptPath(), path});
        this.moduleDelete(new File(cssPath));
    }

    private void iteratorFile(File file) throws IOException, LcdpException {
        block5: {
            JSONObject dataModelJson;
            List operationList;
            String type;
            block7: {
                block6: {
                    if (!FileUtils.exists((File)file)) break block5;
                    if (!FileUtils.isDirectory((File)file)) break block6;
                    File[] files = FileUtils.listFiles((File)file);
                    if (files == null) break block5;
                    for (File childFile : files) {
                        this.iteratorFile(childFile);
                    }
                    break block5;
                }
                if (!file.getName().endsWith(".meta")) break block5;
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                type = jsonObject.get((Object)"type").toString();
                try {
                    CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(type)).cascadeDelete(id);
                }
                catch (RuntimeException e) {
                    logger.error(CASCADE_PROCESSING_WARNING, (Object)e.getMessage());
                }
                if (!"WebPage".equals(type) && !"MobilePage".equals(type) && !"UniPage".equals(type)) break block7;
                SysQuoteRelationService sysQuoteRelationService = (SysQuoteRelationService)SpringContextUtil.getBean(SysQuoteRelationService.class);
                sysQuoteRelationService.deleteQuoteRelationByReferResid(id);
                ResourcePublishService resourcePublishService = (ResourcePublishService)SpringContextUtil.getBean(ResourcePublishService.class);
                resourcePublishService.deleteMenu(id);
                ISysPublishRecordService sysPublishRecordService = (ISysPublishRecordService)SpringContextUtil.getBean(ISysPublishRecordService.class);
                Long resourceId = sysPublishRecordService.getResourceIdBySourceId(id);
                if (!ToolUtil.isNotEmpty((Object)resourceId)) break block5;
                ISysResManageService resManageService = (ISysResManageService)SpringContextUtil.getBean(ISysResManageService.class);
                resManageService.deleteResource(String.valueOf(resourceId));
                break block5;
            }
            if ("DataModel".equals(type) && ToolUtil.isNotEmpty((Object)(operationList = ToolUtil.castListMap((Object)(dataModelJson = JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(file.getAbsolutePath().replace(".meta", "")), (String)"UTF-8"))).get((Object)"operations"), String.class, Object.class)))) {
                for (Map map : operationList) {
                    ISysPublishRecordService sysPublishRecordService = (ISysPublishRecordService)SpringContextUtil.getBean(ISysPublishRecordService.class);
                    Long resourceId = sysPublishRecordService.getResourceIdBySourceId((String)map.get("id"));
                    if (!ToolUtil.isNotEmpty((Object)resourceId)) continue;
                    ISysResManageService resManageService = (ISysResManageService)SpringContextUtil.getBean(ISysResManageService.class);
                    resManageService.deleteResource(String.valueOf(resourceId));
                }
            }
        }
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String parentPath = (String)fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }
}

