<#--表单验证方法-->
<#list checkList! as checkItem >
<#--正则验证表达式-->
<#if checkItem.type == "reg">
	const reg${checkItem_index} = ${checkItem.value};
	if ((value || value === 0) && !reg${checkItem_index}.test(value)) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
	}
<#--必填-->
<#elseif checkItem.type == "required">
	if (value === null || value === undefined || !/[\S]+/.test(value)) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
	}
<#--自定义正则-->
<#elseif checkItem.type == "customRegular">
	const reg${checkItem_index} = ${checkItem.customValue!};
	if ((value || value === 0) && !reg${checkItem_index}.test(value)) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
	}
<#--长度限制自定义-->
<#elseif checkItem.type == "lengthLimit">
	const reg${checkItem_index} = ${checkItem.customValue!};
	if ((value || value === 0) && !reg${checkItem_index}.test(value.toString().replace(/\s*/g, ''))) {
	return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
	}
<#--后端验证-->
<#elseif checkItem.type == "http">
<#--唯一性-->
<#elseif checkItem.type == "unique">
	const uniqueMsg = "${checkItem.errorMsg}";
<#--外部js引用-->
<#elseif checkItem.type == "implementFunction" && checkItem.fileIdentify != "" && checkItem.functionName != "">
    const that = Object.assign(self, { ${insKey}CheckValue: value, ${insKey}CheckField: "${field}"});
	const res${checkItem_index} = await ${checkItem.fileIdentify!}.${checkItem.functionName!}.bind(that)(
	<#list checkItem.paramName! as param>
		<#if (param_index == (checkItem.paramName?size-1))>
			${param!}
		<#else>
			${param!},
		</#if>
	</#list>
	);
	if (!res${checkItem_index}) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
	}
</#if>
</#list>
<#-- 如果有异步校验规则 则需要额外生成代码 去调用后端进行异步校验-->
<#if isBackAsync?? && isBackAsync == true>
	if (name) {
		const checkParams = [];
		checkParams.push(self.${structureInParamMethodName}(name, value));
		verifyResults = await self.${backAsyncMethodsName}(checkParams);
	}
	if (verifyResults && verifyResults.length) {
		const verifyResult = verifyResults.find((item) => item.field === '${field}');
		if (verifyResult && !verifyResult.result) {
			return { result: verifyResult.result, errorMsg: uniqueMsg, field: '${field}' };
		}
	}
</#if>

<#if editTableKey??>
const validResult = await self.${editTableKey}ValidEvent();
if (!validResult) {
	return { result: false, errorMsg: '', field: "${field}" };
}
</#if>
<#--走到最后返回验证成功信息-->
if (self.${methodName!}_extension) {
const verifyResults = [];
return await self.${methodName!}_extension(value, verifyResults, "${field}");
}
return { result: true, errorMsg: "", field: "${field}" };