${exegesisResult!}
<#macro colTree colList>
    <#list colList as item>
        <#-- 表头处理 isParent多级表头标识 -->
        <#if item.isParent??>
            ++level;
            <@colTree colList=item.children></@colTree>
            tableHead.push({
                <#if item.title?is_hash>
                    <#if item.title.international?? && item.title.international>
                        "title" : `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                    <#else>
                        "title" : "${item.title.name!}",
                    </#if>
                <#else>
                    "title" : '${item.title?js_string}',
                </#if>
                "id" : '${item.id}',
                "horizontal" : '${item.align!}',
                "colspan" : ${item.colspan!1},
                "rowspan" : ${item.rowspan!1},
                "level" : level
            });
        <#elseif item.colsMode?? && item.colsMode == 'isExtend'>
        <#else>
            tableHead.push({
                <#if item.title?is_hash>
                    <#if item.title.international?? && item.title.international>
                        "title" : `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                    <#else>
                        "title" : "${item.title.name!}",
                    </#if>
                <#else>
                    "title" : '${item.title?js_string}',
                </#if>
                "id" : '${item.id}',
                "field" : '${item.field}',
                "horizontal" : '${item.align!}',
                "colspan" : ${item.colspan!1},
                "rowspan" : <#if item.rowspan??>${item.rowspan}<#else>${maxRowSpan!1}</#if>,
                "level" : level
            });
            const ${item.field!}Index = tableField.indexOf('${item.field!}');
            const ${item.field!}Letter = excelDownloadForArea(${item.field!}Index);
            <#-- colComponent列格式化数据方式 -->
            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                colArray.push({
                    "letter": ${item.field!}Letter,
                    "field" : '${item.field}',
                    "horizontal": '${item.bodyAlign!}',
                    "dataType": "date",
                    "length": '${item.selectType.dateFmtSelect!}'.length
                });
            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                colArray.push({
                    "letter": ${item.field!}Letter,
                    "field" : '${item.field}',
                    "horizontal": '${item.bodyAlign!}',
                    "dataType": "number",
                    "length": '${item.selectType.numberFmtSelect!}'.length
                });
            <#else>
                colArray.push({
                    "letter": ${item.field!}Letter,
                    "field" : '${item.field}',
                    "horizontal": '${item.bodyAlign!}',
                    "dataType": "string",
                    "length": 0
                });
            </#if>
        </#if>
    </#list>
    --level;
</#macro>
<#macro tableHead>
    for (let i = 0; i < realTableHead.length; i++){
        if (realTableHead[i].rowspan + realTableHead[i].level - 1> maxLevel){
            realTableHead[i].rowspan = maxLevel - realTableHead[i].level + 1;
        }
    }
    const excelCell = [];
    const rows = [];
    for (let i = 0;i < tableField.length; i++){
        for (let j = 0; j < maxLevel; j++){
            const cell = {"xAxis":i,"yAxis":j,isEdit:false};
            excelCell.push(cell);
        }
    }
    for (let i = 0;i < maxLevel; i++){
        let x = 0;
        const row = [];
        for (let j=0;j < realTableHead.length; j++){
            const index = excelCell.findIndex(function(value, index, arr) {
                return value.isEdit === false && value.yAxis === i;
            });
            if (index !== -1) {
                x = excelCell.find(function(value, index, arr) {    
                    return value.isEdit === false && value.yAxis === i;
                }).xAxis;
            }
            if ( realTableHead[j].level - 1 === i){
                const startArea = excelDownloadForArea(x) + (1 + i);
                const endArea = excelDownloadForArea(x + realTableHead[j].colspan - 1) + (realTableHead[j].rowspan + i);
                for (let k = x; k < x + realTableHead[j].colspan; k++){
                    for (let m = i;m < realTableHead[j].rowspan + i; m++){
                        excelCell.find(function(value, index, arr) {
                            return value.xAxis === k && value.yAxis === m;
                        }).isEdit = true;
                    }
                }
                while (row.length < x){
                    row.push("");
                }
                row[x] = realTableHead[j].title;
    realTableHead[j].merge = startArea + ":" + endArea;
            }
        }
        rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j=0;j < realTableHead.length; j++){
        worksheet.mergeCells(realTableHead[j].merge);
        worksheet.getCell(realTableHead[j].merge.split(":")[0]).alignment = {
            vertical: 'middle',
            horizontal: realTableHead[j].horizontal
        };
    }
    for (let i = 0; i < realColArray.length; i++){
        for (let j = maxLevel + 1; j < self.${instanceKey!}TableTotal + 100; j++) {
            worksheet.getCell(realColArray[i].letter + j).alignment = { horizontal: realColArray[i].horizontal };
            if (realColArray[i].dataType === "date"){
                const cell = worksheet.getCell(realColArray[i].letter+j)
                cell.value = cell.value !== null ? cell.value.substr(0,realColArray[i].length) : null;
            }
        }
    }
</#macro>

<#if componentName?? && componentName != "">
    self.${instanceKey!}dataModelName = self.${instanceKey!}ExportColsData?.filename ? self.${instanceKey!}ExportColsData?.filename : self.${instanceKey!}ExportColsDataFileName;
    if (self.${myDataEventId!}ExportTableDialog) {
    self.${instanceKey!}IsExportTemp = false;
    self.${instanceKey!}ColumnsColsData = self.${instanceKey!}ExportColsData;
    if (self.${instanceKey!}ExportColsData?.filename) {
    self.${instanceKey!}dataModelName = self.${instanceKey!}ExportColsData?.filename;
    }
    self.${instanceKey!}ExportTempalteDialogVisible = true;
    } else {
    <#if showCustomList?? && showCustomList!>
        <#--  列表头-列名 -->
        let tableData = [];
        <#-- 列表头-字段值 -->
        let tableField = [];
        if (self.${instanceKey!}IsUserCustom) {
            function getExportCols(cols) {
                cols.forEach((col) => {
                    if (col.children && col.children.length > 0) {
                        getExportCols(col.children);
                    } else {
                        tableData.push(col.label);
                        tableField.push(col.prop);
                    }
                });
            }
            self.${instanceKey!}CustomOptions.customList.forEach((item) => {
                if (item.children && item.children.length > 0) {
                    getExportCols(item.children);
                } else {
                    tableData.push(item.label);
                    tableField.push(item.prop);
                }
            });
            <#-- 隐藏列 -->
            <#if isHiddenCols?? && isHiddenCols! && isAddHiddenCols?? && isAddHiddenCols!>
                <#list tableHiddenFields as item>
                    tableData.push(`${item.title}`);
                    tableField.push(`${item.field}`);
                </#list>
            </#if>
        } else {
            <#--  列表头-列名 -->
            tableData = [
            <#list tableFields! as item>
              <#if (item_index != (tableFields?size-1))>
                  <#if item.title?is_hash>
                      <#if item.title.international?? && item.title.international>
                          `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                      <#else>
                          "${item.title.name}",
                      </#if>
                  <#else>
                      "${item.title}",
                  </#if>
              <#else>
                  <#if item.title?is_hash>
                      <#if item.title.international?? && item.title.international>
                          `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`
                      <#else>
                          "${item.title.name}"
                      </#if>
                  <#else>
                      "${item.title}"
                  </#if>
              </#if>
            </#list>
            ];
            <#-- 列表头-字段值 -->
            tableField = [
            <#list tableFields! as item>
                <#if (item_index != (tableFields?size-1))>
                    "${item.field}",
                <#else>
                    "${item.field}"
                </#if>
            </#list>
            ];
        }
    <#else>
    <#--  列表头-列名 -->
    const tableData = [
        <#list tableFields! as item>
            <#if (item_index != (tableFields?size-1))>
                <#if item.title?is_hash>
                    <#if item.title.international?? && item.title.international>
                        `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                    <#else>
                        "${item.title.name}",
                    </#if>
                <#else>
                    "${item.title}",
                </#if>
            <#else>
                <#if item.title?is_hash>
                    <#if item.title.international?? && item.title.international>
                        `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`
                    <#else>
                        "${item.title.name}"
                    </#if>
                <#else>
                    "${item.title}"
                </#if>
            </#if>
        </#list>
    ];
    <#-- 列表头-字段值 -->
    const tableField = [
        <#list tableFields! as item>
            <#if (item_index != (tableFields?size-1))>
                "${item.field}",
            <#else>
                "${item.field}"
            </#if>
        </#list>
    ];
    </#if>
    const columns = [];
    for (let i=0; i<tableData.length ; i++){
        const excelCol = {};
        // excelCol.header = tableData[0][i];
        excelCol.key = tableField[i];
        excelCol.width = 30;
        columns.push(excelCol);
    }
    const Excel = require("exceljs");
    const workbook = new Excel.Workbook();
    const worksheet = workbook.addWorksheet("sheet1");
    <#if exportExcelName?? && exportExcelName != ''>
        const fileName = "${exportExcelName!}.xlsx";
    <#else>
        const fileName = (self.${instanceKey!}dataModelName || 'data') + '.xlsx';
    </#if>
    workbook.created = new Date();
    workbook.modified = new Date();
    worksheet.columns = columns;
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            <#if item.isConfigComplete>
                const dicts = [];
                const relates = [];
                <#break>
            <#elseif showConfigItemInfos??>
                <#list item.mappingRelates! as mapping>
                    <#if mapping.field == key>
                        const dicts = [];
                        const relates = [];
                        <#break>
                    </#if>
                </#list>
            </#if>
        </#list>
    </#if>
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            <#if item.isConfigComplete && item.commonModelType?? >
                const dict${item_index} = [];
                const relate${item_index} = [];
                <#if !item.dictType?? || item.dictType == "">
                    const ${item.importName!}Obj${item_index} = {};
                <#else>
                    const ${item.importName!}Obj${item_index} = {
                    typeName: '${item.dictType}',
                    };
                </#if>
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示字典表
                if (data${item_index} && data${item_index}.length > 0) {
                for (let i = 0; i < data${item_index}.length; i++) {
                dict${item_index}.push({
                field: '${item.tableFieldWhere!}${item.tableFieldWhere!}',
                value: data${item_index}[i].value,
                label: data${item_index}[i].label
                });
                }
                relate${item_index}.push({
                tableFieldWhere: '${item.tableFieldWhere!}',
                field: '${item.tableFieldWhere!}'
                });
                }
                } else {
                  HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            <#elseif item.isConfigComplete>
                const dict${item_index} = [];
                const relate${item_index} = [];
                const ${item.importName!}Obj${item_index} = {
                inValues: '',
                ${item.queryObjectAttr!}
                };
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示数据模型
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                for (let i = 0; i < data${item_index}.data.length; i++) {
                <#list item.mappingRelates! as mapping>
                    dict${item_index}.push({
                    field: '${item.tableFieldWhere!}${mapping.field!}',
                    value: data${item_index}.data[i].${item.relateTableFieldWhere!},
                    label: data${item_index}.data[i].${mapping.relateField!}
                    });
                </#list>
                }
                <#list item.mappingRelates! as mapping>
                    relate${item_index}.push({
                    tableFieldWhere: '${item.tableFieldWhere!}',
                    field: '${mapping.field!}'
                    });
                </#list>
                }
                } else {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            </#if>
        </#list>
    </#if>

    <#if importName != "" && dbdHaveMethod?? && dbdHaveMethod>
        const exportDataFun = function() {
        const ${importName!}Obj = {
    <#--无分页不带分页参数-->
        <#if isPagination?? && isPagination>
        ...cloneListQyery,
        </#if>
        ${queryAttr!}
    };
    <#if isPagination?? && isPagination>
        if(!isClose) return;
    </#if>
    <#if showFilter?? && showFilter>
       const queryConditions = self.${instanceKey!}GetQueryConditions(${importName!}Obj);
       if (queryConditions && queryConditions.length) {
         ${importName!}Obj.superQueryConditionDto = queryConditions;
       }
    </#if>
    <#if isPagination?? && isPagination>
        let importMethod;
        if(flag) {
            importMethod = "${importMethodA!}"
        } else {
            importMethod = "${importMethod!}"
        }
    <#else>
        const importMethod = "${importMethod!}";
    </#if>
    ${importName!}[importMethod](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data) {
        const convert = [];
        self.${instanceKey!}TableTotal = res.data.count || 0;
        self.${instanceKey!}ReturnData = res.data.data;
        (res.data.data).forEach((item) => {
        <#assign map=colFields/>
        <#assign keys=map?keys/>
        <#list keys! as key>
            <#assign flag=false/>
            <#if (key_index != (keys?size-1))>
                <#if showConfigItemInfos??>
                    <#list showConfigItemInfos! as item>
                        <#if item.isConfigComplete && item.commonModelType?? >
                            <#if item.tableFieldWhere == key>
                                let ${key} = '';
                                const ${key}Arr = [];
                                if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                                    item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                        const definedValue = dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                        }) !== undefined;
                                        if (definedValue) {
                                            ${key}Arr.push(dicts.find(function(dictItem) {
                                                return dictItem.field == '${item.tableFieldWhere}';
                                            }).dict.find(function(dictItem) {
                                                return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                            }).label);
                                        } else {
                                            ${key}Arr.push(value);
                                        }
                                    });
                                    ${key} = ${key}Arr.join(',');
                                } else {
                                    const definedValue = dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                    }) !== undefined;
                                    if (definedValue) {
                                        ${key} = dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                        }).label;
                                    } else {
                                        ${key} = item.${item.tableFieldWhere};
                                    }
                                }
                                <#assign flag=true/>
                            </#if>
                        <#elseif showConfigItemInfos??>
                            <#list item.mappingRelates! as mapping>
                                <#if mapping.field == key>
                                    let ${key} = '';
                                    const ${key}Arr = [];
                                    if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                                        item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                            const definedValue = dicts.find(function(dictItem) {
                                                return dictItem.field == '${item.tableFieldWhere}';
                                            }).dict.find(function(dictItem) {
                                                return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                            }) !== undefined;
                                            if (definedValue) {
                                                ${key}Arr.push(dicts.find(function(dictItem) {
                                                    return dictItem.field == '${item.tableFieldWhere}';
                                                }).dict.find(function(dictItem) {
                                                    return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                                }).label);
                                            } else {
                                                ${key}Arr.push(value);
                                            }
                                        });
                                        ${key} = ${key}Arr.join(',');
                                    } else {
                                        const definedValue = dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                        }) !== undefined;
                                        if (definedValue) {
                                            ${key} = dicts.find(function(dictItem) {
                                                return dictItem.field == '${item.tableFieldWhere}';
                                            }).dict.find(function(dictItem) {
                                                return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                            }).label;
                                        } else {
                                            ${key} = item.${item.tableFieldWhere};
                                        }
                                    }
                                    <#assign flag=true/>
                                </#if>
                            </#list>
                        </#if>
                    </#list>
                </#if>
            <#else>
                <#if showConfigItemInfos??>
                    <#list showConfigItemInfos! as item>
                        <#if item.isConfigComplete && item.commonModelType?? >
                            <#if item.tableFieldWhere == key>
                                let ${key} = '';
                                const ${key}Arr = [];
                                if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                                    item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                        const definedValue = dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                        }) !== undefined;
                                        if (definedValue) {
                                            ${key}Arr.push(dicts.find(function(dictItem) {
                                                return dictItem.field == '${item.tableFieldWhere}';
                                            }).dict.find(function(dictItem) {
                                                return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                            }).label);
                                        } else {
                                            ${key}Arr.push(value);
                                        }
                                    });
                                    ${key} = ${key}Arr.join(',');
                                } else {
                                    const definedValue = dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                    }) !== undefined;
                                    if (definedValue) {
                                        ${key} = dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                        }).label;
                                    } else {
                                        ${key} = item.${item.tableFieldWhere};
                                    }
                                }
                                <#assign flag=true/>
                            </#if>
                        <#elseif showConfigItemInfos??>
                            <#list item.mappingRelates! as mapping>
                                <#if mapping.field == key>
                                    let ${key} = '';
                                    const ${key}Arr = [];
                                    if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                                        item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                            const definedValue = dicts.find(function(dictItem) {
                                                return dictItem.field == '${item.tableFieldWhere}';
                                            }).dict.find(function(dictItem) {
                                                return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                            }) !== undefined;
                                            if (definedValue) {
                                                ${key}Arr.push(dicts.find(function(dictItem) {
                                                    return dictItem.field == '${item.tableFieldWhere}';
                                                }).dict.find(function(dictItem) {
                                                    return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                                }).label);
                                            } else {
                                                ${key}Arr.push(value);
                                            }
                                        });
                                        ${key} = ${key}Arr.join(',');
                                    }else {
                                        const definedValue = dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                        }) !== undefined;
                                        if (definedValue) {
                                            ${key} = dicts.find(function(dictItem) {
                                                return dictItem.field == '${item.tableFieldWhere}';
                                            }).dict.find(function(dictItem) {
                                                return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}${key}';
                                            }).label;
                                        } else {
                                            ${key} = item.${item.tableFieldWhere};
                                        }
                                    }
                                    <#assign flag=true/>
                                </#if>
                            </#list>
                        </#if>
                    </#list>
                </#if>
            </#if>
        </#list>
        convert.push({
                    <#assign map=colFields/>
                    <#assign  keys=map?keys/>
                    <#list keys! as key>
                        <#assign flag=false/>
                        <#if (key_index != (keys?size-1))>
                            <#if showConfigItemInfos??>
                                <#list showConfigItemInfos! as item>
                                    <#if item.isConfigComplete && item.commonModelType?? >
                                        <#if item.tableFieldWhere == key>
                                        ${key}: ${key},
                                        <#assign flag=true/>
                                        </#if>
                                    <#elseif showConfigItemInfos??>
                                        <#list item.mappingRelates! as mapping>
                                            <#if mapping.field == key>
                                                ${key}: ${key},
                                                <#assign flag=true/>
                                            </#if>
                                        </#list>
                                    </#if>
                                </#list>
                            </#if>
                            <#if flag == false>
                                <#assign flag1=false/>
                                <#if tableShowFields??>
                                    <#list tableShowFields! as item>
                                        <#if item.field == key && item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                            ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' || (item.${map[key]} + '') === '' ? '': self.$dayjs(item.${map[key]}).format('${item.selectType.dateFmtSelect!}')),
                                            <#assign flag1=true/>
                                        </#if>
                                        <#if item.field == key && item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                            ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' || (item.${map[key]} + '') === '' ? '': self.$numeral(item.${map[key]}).format('${item.selectType.numberFmtSelect!}')),
                                            <#assign flag1=true/>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if flag1 == false>
                                    ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' ? '': (item.${map[key]} + '').trim()),
                                </#if>
                            </#if>
                        <#else>
                            <#if showConfigItemInfos??>
                                <#list showConfigItemInfos! as item>
                                    <#if item.isConfigComplete && item.commonModelType?? >
                                        <#if item.tableFieldWhere == key>
                                            ${key}: ${key},
                                            <#assign flag=true/>
                                        </#if>
                                    <#elseif showConfigItemInfos??>
                                        <#list item.mappingRelates! as mapping>
                                            <#if mapping.field == key>
                                                ${key}: ${key},
                                                <#assign flag=true/>
                                            </#if>
                                        </#list>
                                    </#if>
                                </#list>
                            </#if>
                            <#if flag == false>
                                <#assign flag1=false/>
                                <#if tableShowFields??>
                                    <#list tableShowFields! as item>
                                        <#if item.field == key && item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                            ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' || (item.${map[key]} + '') === '' ? '': self.$dayjs(item.${map[key]}).format('${item.selectType.dateFmtSelect!}')),
                                            <#assign flag1=true/>
                                        </#if>
                                        <#if item.field == key && item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                            ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' || (item.${map[key]} + '') === '' ? '': self.$numeral(item.${map[key]}).format('${item.selectType.numberFmtSelect!}')),
                                            <#assign flag1=true/>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if flag1 == false>
                                    ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' ? '': (item.${map[key]} + '').trim()),
                                </#if>
                            </#if>
                        </#if>
                    </#list>
    })
    });
        worksheet.insertRows(1, convert);
        const colArray = [];
        const tableHead = [];
        let level = 1;
        // eslint-disable-next-line
        let maxLevel = 1;
        <@colTree colList=tableShowFields!></@colTree>
        <#if showCustomList?? && showCustomList!>
        let realTableHead = [];
        let realColArray = [];
        if (self.${instanceKey!}IsUserCustom) {
            const getRealHead = function (arr, colData) {
                arr.forEach((child) => {
                    if (child.children && child.children.length > 0) {
                        getRealHead(child.children, colData);
                    }
                    if (child.prop === colData.field && child.label === colData.title) {
                        realTableHead.push({
                        ...colData,
                        ...(child.align ? { horizontal: child.align } : {})
                        });
                    }
                });
            };
            const getRealCol = function (arr, colData) {
                arr.forEach((child) => {
                    if (child.children && child.children.length > 0) {
                        getRealCol(child.children, colData);
                    }
                    if (child.prop === colData.field) {
                        realColArray.push({
                        ...colData,
                        ...(child.align ? { horizontal: child.align } : {})
                        });
                    }
                });
            };
            self.${instanceKey!}CustomOptions.customList.forEach((col) =>{
                tableHead.forEach((item) => {
                    if (col.children && col.children.length > 0) {
                        getRealHead(col.children, item);
                    }
                    if (col.prop === item.field && col.label === item.title) {
                        realTableHead.push({
                            ...item,
                            ...(col.align ? { horizontal: col.align } : {}),
                        })
                    }
                });
                colArray.forEach((item) => {
                    if (col.children && col.children.length > 0) {
                        getRealCol(col.children, item);
                    }
                    if (col.prop === item.field) {
                        realColArray.push({
                            ...item,
                            ...(col.align ? { horizontal: col.align } : {}),
                        })
                    }
                });
            });
        } else {
            realTableHead = tableHead;
            realColArray = colArray;
        }
        <#else>
            const realTableHead = tableHead;
            const realColArray = colArray;
        </#if>
        for (let i = 0; i < realTableHead.length; i++){
            if (realTableHead[i].level > maxLevel){
                maxLevel = realTableHead[i].level;
            }
        }
        <#if isHiddenCols?? && isHiddenCols! && isAddHiddenCols?? && isAddHiddenCols!>
            <#list tableHiddenFields as item>
            tableHead.push({
                <#if item.title?is_hash>
                    <#if item.title.international?? && item.title.international>
                        "title" : `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                    <#else>
                        "title" : "${item.title.name!}",
                    </#if>
                <#else>
                    "title" : '${item.title!}',
                </#if>
                "horizontal" : '${item.align!"center"}',
                "colspan" : 1,
                "rowspan" : maxLevel,
                "level" : 1
            });
            const ${item.field!}Index = tableField.indexOf('${item.field!}');
            const ${item.field!}Letter = excelDownloadForArea(${item.field!}Index);
                <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
            realColArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "date",
                "length": '${item.selectType.dateFmtSelect!}'.length
            });
                <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
            realColArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "number",
                "length": '${item.selectType.numberFmtSelect!}'.length
            });
                <#else>
            realColArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "string",
                "length": 0
            });
                </#if>
            </#list>
        </#if>
        <@tableHead></@tableHead>
        workbook.xlsx.writeBuffer().then(function (buffer) {
            saveAs(new Blob([buffer], {
                type: 'application/octet-stream'
            }), fileName);
        });
        ${asyncBodyCode!}
    } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsFailed', fallbackStr: '表格数据请求失败'}), 'error');
        self.${instanceKey!}TableLoading = false;
    }
    }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsAbnormal', fallbackStr: '表格数据请求异常'}), 'error');
        self.${instanceKey!}TableLoading = false;
    });
        }
        <#if isPagination?? && isPagination>
            const cloneListQyery = Object.assign(
                Object.create(Object.getPrototypeOf(self.${instanceKey!}ListQuery)),
                self.${instanceKey!}ListQuery
            );
            let isClose = true;
            let flag = true;
            <#if showCustomList?? && showCustomList!>
            if (self.${instanceKey!}ListQuery.size > 0 && (self.${instanceKey!}TableTotal/self.${instanceKey!}ListQuery.size > 1 ) && !self.${instanceKey!}CustomOptions.pageType) {
                self.$confirm(self.hussar_t({key: 'vfg.exportPage', fallbackStr: '请选择导出数据范围？'}), self.hussar_t({key: 'vfg.notice', fallbackStr: '提示'}), {
                    distinguishCancelAndClose: true,
                    confirmButtonText: self.hussar_t({key: 'noCode-currentPageData', fallbackStr: '当前页数据'}),
                    cancelButtonText: self.hussar_t({key: 'noCode-allData', fallbackStr: '全部数据'}),
                    type: 'warning'
                })
                .then(() => {
                      // 用户点击确认按钮时的处理
                      exportDataFun();
                    })
                    .catch((action) => {
                        if (action === 'cancel') {
                          flag = false;
                          exportDataFun();
                        }
                  });
            } else if (self.${instanceKey!}CustomOptions.pageType) {
                flag = false;
                HussarRouter.showMsg(self, "正在导出所有页", 'success');
                exportDataFun();
            } else {
                exportDataFun();
            }
            <#else>
            if (self.${instanceKey!}ListQuery.size > 0 && self.${instanceKey!}TableTotal/self.${instanceKey!}ListQuery.size > 1) {
                self.$confirm(self.hussar_t({key: 'vfg.exportPage', fallbackStr: '请选择导出数据范围？'}), self.hussar_t({key: 'vfg.notice', fallbackStr: '提示'}), {
                    distinguishCancelAndClose: true,
                    confirmButtonText: self.hussar_t({key: 'noCode-currentPageData', fallbackStr: '当前页数据'}),
                    cancelButtonText: self.hussar_t({key: 'noCode-allData', fallbackStr: '全部数据'}),
                    type: 'warning'
                })
                .then(() => {
                      // 用户点击确认按钮时的处理
                      exportDataFun();
                    })
                    .catch((action) => {
                        if (action === 'cancel') {
                          flag = false;
                          exportDataFun();
                        }
                  });
            } else {
                exportDataFun();
            }
            </#if>
        <#else>
            exportDataFun();
        </#if>
    <#else>
        worksheet.insertRows(1, ${dataName!});
        const colArray = [];
        const tableHead = [];
        const realTableHead = tableHead;
        const realColArray = colArray;
        let level = 1;
        // eslint-disable-next-line
        let maxLevel = 1;
        <@colTree colList=tableShowFields!></@colTree>
        for (let i = 0; i < realTableHead.length; i++) {
        if (realTableHead[i].level > maxLevel) {
        maxLevel = realTableHead[i].level;
        }
        }
        <#if isHiddenCols?? && isHiddenCols! && isAddHiddenCols?? && isAddHiddenCols!>
            <#list tableHiddenFields as item>
            tableHead.push({
                <#if item.title?is_hash>
                    <#if item.title.international?? && item.title.international>
                        "title" : `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                    <#else>
                        "title" : "${item.title.name!}",
                    </#if>
                <#else>
                    "title" : '${item.title!}',
                </#if>
                "horizontal" : '${item.align!"center"}',
                "colspan" : 1,
                "rowspan" : maxLevel,
                "level" : 1
            });
            const ${item.field!}Index = tableField.indexOf('${item.field!}');
            const ${item.field!}Letter = excelDownloadForArea(${item.field!}Index);
                <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
            realColArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "date",
                "length": '${item.selectType.dateFmtSelect!}'.length
            });
                <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
            realColArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "number",
                "length": '${item.selectType.numberFmtSelect!}'.length
            });
                <#else>
            realColArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!"center"}',
                "dataType": "string",
                "length": 0
            });
                </#if>
            </#list>
        </#if>
        <@tableHead></@tableHead>
        workbook.xlsx.writeBuffer().then(function (buffer) {
            saveAs(new Blob([buffer], {
                type: 'application/octet-stream'
            }), fileName);
        });
    </#if>
    }
</#if>
