/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.extend.publish;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.ScriptCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ScriptPublisher;
import com.jxdinfo.hussar.formdesign.elementui.extend.model.ExtendWVue;
import com.jxdinfo.hussar.formdesign.elementui.extend.result.JsScriptCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

@ClientKind(kind="com.jxdinfo.VueScript.extend.publish")
public class CustomVuePublishImpl
implements ScriptPublisher {
    public static final String KIND = "com.jxdinfo.VueScript.extend.publish";
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static final String VUE_SUFFIX = ".vue";

    public void publish(ScriptCtx<CodeResult> scriptCtx) throws LcdpException {
        BaseFile baseFile = scriptCtx.getBaseFile();
        ExtendWVue extendWVue = (ExtendWVue)((Object)JSON.parseObject((String)baseFile.getData(), ExtendWVue.class));
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String modelPath = fileMappingService.getFormatParentPath(baseFile.getId());
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String extendScriptPath = pathStrategy.vuePathService().getExtendScriptPath();
        String rootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{extendScriptPath});
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String path = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendVuePath(), modelPath, baseFile.getName() + VUE_SUFFIX});
        if (HussarUtils.isNotEmpty((Object)extendWVue.getEditorNote())) {
            filePublishService.writeStringToFile(extendWVue.getEditorNote(), path, baseFile.getId());
        }
        JsScriptCodeResult jsScriptCodeResult = new JsScriptCodeResult();
        jsScriptCodeResult.setFilePath(path);
        jsScriptCodeResult.setResultType(ResultBeanEnum.VUE_RESULT);
        jsScriptCodeResult.setId(baseFile.getId());
        scriptCtx.addGenCodeResults((CodeResult)jsScriptCodeResult);
    }
}

