/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.DataModel.cascade")
public class ModelCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.DataModel.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldfilePath = this.getOldJSPath(baseFile.getId(), strategy);
        String newFilePath = this.getNewJSPath(baseFile.getId(), baseFile.getName().toLowerCase(), strategy);
        File newFile = new File(newFilePath);
        File oldFile = new File(oldfilePath);
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileDataModelJs")).cascadeEdit(baseFile);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniDataModelJs")).cascadeEdit(baseFile);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), fileMappingService.getFormatPath(baseFile.getId())});
        File backJavaFile = new File(backJavaPath);
        String oldName = backJavaPath.substring(backJavaPath.lastIndexOf(File.separator) + 1);
        this.iteratorFile(backJavaFile, oldName, baseFile.getName());
        File newBackJavaFile = new File(FileUtil.systemPath((String[])new String[]{backJavaPath.substring(0, backJavaPath.lastIndexOf(File.separator)), baseFile.getName().toLowerCase()}));
        if (FileUtils.exists((File)backJavaFile) && !FileUtils.exists((File)newBackJavaFile)) {
            this.fixName(backJavaFile, newBackJavaFile);
        }
        File publishFile = new File(this.getPublishFilePathById());
        this.iteratorDirectory(publishFile, oldName, baseFile.getName(), baseFile.getId().replace("_", "/"));
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        String oldName;
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        newName = newName.toLowerCase();
        String oldfilePath = this.getOldJSPath(id, strategy);
        File jsFrom = new File(oldfilePath);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getFrontApiPath()});
        File jsTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        this.modelMove(jsFrom, jsTo, newName, parentPath, rootPath);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniDataModelJs")).cascadeMove(id, newName, parentId);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileDataModelJs")).cascadeMove(id, newName, parentId);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), fileMappingService.getFormatPath(id).toLowerCase()});
        File javaFrom = new File(backJavaPath);
        File javaTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName, pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath()));
        if (FileUtils.exists((File)javaFrom)) {
            if (!FileUtils.exists((File)javaTo)) {
                FileUtils.moveDirectory((File)javaFrom, (File)javaTo);
            } else {
                FileUtils.moveDirectoryToDirectory((File)javaFrom, (File)javaTo, (boolean)false);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(oldName = backJavaPath.substring(backJavaPath.lastIndexOf(File.separator) + 1))) && ToolUtil.isNotEmpty((Object)newName) && !oldName.equals(newName)) {
            this.iteratorFile(javaTo, oldName, newName);
            File publishFile = new File(this.getPublishFilePathById());
            this.iteratorDirectory(publishFile, oldName, newName, id.replace("_", "/"));
        }
    }

    public void modelMove(File jsFrom, File jsTo, String newName, String parentPath, String rootPath) throws IOException, LcdpException {
        if (FileUtils.exists((File)jsFrom)) {
            if (!FileUtils.exists((File)jsTo)) {
                FileUtils.forceMkdir((File)jsTo);
            }
            if (newName != null && !newName.isEmpty()) {
                jsTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + ".js", rootPath));
                if (!FileUtils.exists((File)jsTo)) {
                    try {
                        FileUtils.moveFile((File)jsFrom, (File)jsTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)jsFrom, (File)jsTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldJSFilePath = this.getOldJSPath(id, strategy);
        File file = new File(oldJSFilePath);
        this.modelJsDel(file, oldJSFilePath);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileDataModelJs")).cascadeDelete(id);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniDataModelJs")).cascadeDelete(id);
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), fileMappingService.getFormatPath(id)});
        File backJavaFile = new File(backJavaPath);
        if (FileUtils.exists((File)backJavaFile)) {
            try {
                FileUtils.forceDelete((File)backJavaFile);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, backJavaFile.getAbsolutePath());
            }
        }
        ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
        resourceCascadeService.deleteModelPublishFile(id);
    }

    public void modelJsDel(File file, String oldJSFilePath) throws LcdpException {
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldJSFilePath);
            }
        }
    }

    String getOldJSPath(String id, Integer strategy) throws LcdpException {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String oldJsPath = fileMappingService.getFormatPath(id);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getPublishFilePathById() {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        return FileUtil.posixPath((String[])new String[]{pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor"});
    }

    private void iteratorFile(File file, String oldName, String newName) throws IOException {
        if (FileUtils.exists((File)file)) {
            if (FileUtils.isDirectory((File)file)) {
                File[] files = FileUtils.listFiles((File)file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, oldName, newName);
                    }
                }
            } else if (!file.getName().contains(this.getBackFileName(oldName + "SysTask"))) {
                if (file.getName().contains(this.getBackFileName(oldName + "Master"))) {
                    oldName = oldName + "Master";
                    newName = newName + "Master";
                    if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                        oldName = oldName + "VO";
                        newName = newName + "VO";
                    }
                } else if (file.getName().contains(this.getBackFileName(oldName + "Task"))) {
                    oldName = oldName + "Task";
                    newName = newName + "Task";
                    if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                        oldName = oldName + "VO";
                        newName = newName + "VO";
                    } else if (file.getName().contains(this.getBackFileName(oldName + "TotalQuery"))) {
                        oldName = oldName + "TotalQuery";
                        newName = newName + "TotalQuery";
                    }
                } else if (file.getName().contains(this.getBackFileName(oldName + "TotalQuery"))) {
                    oldName = oldName + "TotalQuery";
                    newName = newName + "TotalQuery";
                } else if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                    oldName = oldName + "VO";
                    newName = newName + "VO";
                }
                oldName = this.getBackFileName(oldName);
                newName = this.getBackFileName(newName);
                if (FileUtils.exists((File)file) && file.isFile()) {
                    String oldPath = file.getAbsolutePath();
                    String newPath = oldPath.replaceFirst(oldName, newName);
                    File newFile = new File(newPath);
                    FileUtils.fixName((File)file, (File)newFile);
                }
            }
        }
    }

    private void iteratorDirectory(File file, String oldName, String newName, String id) throws IOException {
        if (FileUtils.exists((File)file) && FileUtils.isDirectory((File)file)) {
            if (file.getName().contains(id)) {
                if (!file.getName().contains(this.getBackFileName(oldName + "SysTask"))) {
                    if (file.getName().contains(this.getBackFileName(oldName + "Master"))) {
                        oldName = oldName + "Master";
                        newName = newName + "Master";
                        if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                            oldName = oldName + "VO";
                            newName = newName + "VO";
                        }
                    } else if (file.getName().contains(this.getBackFileName(oldName + "Task"))) {
                        oldName = oldName + "Task";
                        newName = newName + "Task";
                        if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                            oldName = oldName + "VO";
                            newName = newName + "VO";
                        }
                    } else if (file.getName().contains(this.getBackFileName(oldName + "TotalQuery"))) {
                        oldName = oldName + "TotalQuery";
                        newName = newName + "TotalQuery";
                    } else if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                        oldName = oldName + "VO";
                        newName = newName + "VO";
                    }
                    String oldPath = file.getAbsolutePath();
                    String newPath = oldPath.replace(oldName, newName);
                    oldName = this.getBackFileName(oldName);
                    newName = this.getBackFileName(newName);
                    newPath = newPath.replace(oldName, newName);
                    File newFile = new File(newPath);
                    FileUtils.fixName((File)file, (File)newFile);
                }
            } else {
                File[] files = FileUtils.listFiles((File)file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorDirectory(childFile, oldName, newName, id);
                    }
                }
            }
        }
    }

    String getBackFileName(String name) {
        return ToolUtil.firstLetterToUpper((String)NamingStrategy.underlineToCamel((String)name));
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String parentPath = (String)fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

