const seriesResult = [];
<#--主题颜色-->
const colorValue = ${topicColorStr!};
<#--标题-->
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
  const titleLength = oldTitle.length;
  const provideLength = numberOfRow;
  const rowNumber = Math.ceil(titleLength / provideLength);
  if (titleLength > provideLength) {
    for (let i = 0; i < rowNumber; i++) {
      let tempStr = ' ';
      const start = i * provideLength;
      const end = start + provideLength;
      if (i === rowNumber - 1) {
        tempStr = oldTitle.substring(start, titleLength);
      } else {
        tempStr = oldTitle.substring(start, end)+'\n';
      }
      newTitle += tempStr;
    }
  } else {
    newTitle = oldTitle;
  }
}
const echatrsTitle = {
  text: newTitle,
  textStyle: {
    color: '${titleColor!}',
    fontSize: '${titleFontSize!}',
    fontFamily: '${fontFamily!}',
    fontWeight: '${fontWeight!}',
  },
  left: '${titleAlign!}',
  top: '${titleTop!}',
  <#if (titleBackgroundColor?? && titleBackgroundColor != "")>
  backgroundColor: '${titleBackgroundColor!}',
  </#if>
};
<#--提示信息-->
const echatrsTooltip = {
  trigger: 'item',
  backgroundColor: '${tooltipBgColor!}',
  show: ${toolShow?string!},
  textStyle: {
    color: '${toolColor!}',
    fontSize: '${toolFontSize!}',
    fontFamily: '${toolFontFamily!}',
    fontWeight: '${toolFontWeight!}',
    fontStyle: '${toolFontStyle!}',
    lineHeight: '${toolLineHeight!}',
  },
  padding: ['${toolPaddingTop!}', '${toolPaddingLeft!}'],
  extraCssText: 'box-shadow: ${toolShadow!};'
};
<#--图例样式-->
const textStyle = {
  color: '${legendColor!}',
  fontSize: '${legendFontSize!}',
  fontFamily: '${legendFontFamily!}',
  fontWeight: '${legendFontWeight!}',
  fontStyle: '${legendFontStyle!}',
};
<#--指示器名称(轴名称)样式-->
const radarName = {
  show: ${isShowName?string!},
  color: '${indicatorNameColor!}',
  textStyle:{
    fontSize: '${indicatorNameFontSize!}',
    fontFamily: '${indicatorNameFontFamily!}',
    fontWeight: '${indicatorNameFontWeight!}',
    fontStyle: 'normal'
  }
};
<#--坐标轴-->
const axisLine = {
  lineStyle: {
    color: '${axisLineColor!}',
    width: '${axisLineWidth!}',
    type: '${axisLineType!}',
  }
};
<#--分割线颜色splitLineColor-->
<#assign sub = '${splitLineColor!}'/>
<#--分割设置-->
const splitLine = {
  lineStyle:{
    <#if sub != "">
      color: '${splitLineColor!}',
      width: '${splitLineWidth!}',
      type: '${splitLineType!}',
    </#if>
  }
};
<#--分割面积样式-->
const splitArea = {
  show: ${splitAreaShow?string!},
  areaStyle: {
    color: ['${splitAreaColorOne!}','${splitAreaColorTwo!}'],
    opacity: '${splitAreaOpacity!}'
  }
};
<#--刻度线标签样式-->
const axisLabel = {
  show: ${axisLabelShow?string!},
  margin:'${axisLabelMargin!}',
  color: '${axisLabelColor!}',
  fontSize: '${axisLabelFontSize!}',
  fontFamily: '${axisLabelFontFamily!}',
  formatter(value) {
    if (!isNaN(value)) {
      return parseFloat(value).toFixed(2);
    }
  }
};
const axisTick = {
  show: ${axisTickShow?string!},
  length: '${axisTickLength!}',
}
const seriesData = [];
${optionData!}.indicatorData.forEach((item, index) => {
  seriesData.push({
    value: ${optionData!}.itemValue[index],
    name: item,
  })
})
const indicatorData = [];
${optionData!}.itemName.forEach((item, index) => {
  indicatorData.push({
    name: item,
    max: self.${itemMaxValue!}[index],
  })
})

return{
  title: echatrsTitle,
  tooltip: echatrsTooltip,
  radar: {
    shape: '${radarShape!}',
    splitNumber: ${splitNumber!},
    name: radarName,
    nameGap: '${indicatorNameGap!}',
    indicator: indicatorData,
    splitLine: splitLine,
    axisLine: axisLine,
    splitArea: splitArea,
    axisLabel: axisLabel,
    axisTick: axisTick,
    radius: ${radarRadius!},
  },
  legend: {
    show: ${isShowFlag?string!},
    left: '${legendLocation!}',
    textStyle: textStyle,
    itemWidth: ${itemWidth!},
    itemHeight: ${itemHeight!},
    itemGap: ${itemGap!},
    icon: '${itemIcon!}',
    orient: '${itemOrient!}',
    inactiveColor: '${itemInactiveColor!}',
    data: ${optionData!}.indicatorData,
    bottom: 5,
  },
  series: [{
    name: '雷达图',
    type: 'radar',
    symbol: '${symbolIcon!}',
    symbolSize: '${symbolIconSize!}',
    color: colorValue,
    data: seriesData,
  }]
};