/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CommonVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List triggers = lcdpComponent.getTriggers();
        lcdpComponent.registerTemplatePath("template/elementui/element/Common/common.ftl");
        lcdpComponent.addRenderParam("triggers", (Object)triggers);
        lcdpComponent.addRenderParam("id", (Object)lcdpComponent.getInstanceKey());
        String[] nameParts = lcdpComponent.getName().split("\\.");
        String label = nameParts[nameParts.length - 1].replaceFirst("^JXD", "");
        lcdpComponent.addRenderParam("label", (Object)label.replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase());
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        Map dataItemMap = (Map)lcdpComponent.getProps().get("dataItemMap");
        if (ToolUtil.isNotEmpty((Object)dataItemMap)) {
            for (String key : dataItemMap.keySet()) {
                String valueData = "";
                if ("value".equals(key)) {
                    ComponentData componentData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, null);
                    valueData = componentData.getRenderValue();
                    String componentAttr = RenderVModelUtil.getComponentAttr((LcdpComponent)lcdpComponent, (Ctx)ctx, null);
                    if (!ToolUtil.isNotEmpty((Object)valueData)) continue;
                    lcdpComponent.addAttr(componentAttr, valueData);
                    continue;
                }
                valueData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)(key.substring(0, 1).toUpperCase() + key.substring(1)), Collections.singletonList(key), null).getRenderValue();
                if (!ToolUtil.isNotEmpty((Object)valueData)) continue;
                lcdpComponent.addAttr(":" + key, valueData);
            }
        }
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormMounted(lcdpComponent, ctx);
    }
}

