/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.reference.ColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElHSquareList.value")
@Scope(value="prototype")
public class HSquareListValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public String setValue(List<String> list) throws LcdpException {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "value": 
                case "data": {
                    this.getValueAndData(dataItems, data, dataItem);
                    break;
                }
                case "item": {
                    this.getItemValue(dataItems, data);
                    break;
                }
                default: {
                    this.getListData(dataItems, data);
                    break;
                }
            }
        } else {
            this.getListData(dataItems, data);
        }
        return data;
    }

    public ComponentData getDefaultValueByDataItem(List<String> list) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> list) throws LcdpException {
        return null;
    }

    private void getListData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> listDataItem = new ArrayList<String>();
        listDataItem.add("value");
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 2) {
            this.dealTemplateCondition(dataItems.get(1), data);
        } else if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 1 && !"value".equals(dataItems.get(0))) {
            this.dealTemplateCondition(dataItems.get(0), data);
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value")));
        }
    }

    private void dealTemplateCondition(String dataItem, ComponentData data) {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
        if (cols != null) {
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItem)) continue;
                data.setRenderValue(this.lcdpComponent.getInstanceKey() + "Item." + colObj.getString("field"));
                data.setDataType(((JSONObject)col).getString("dataType"));
                break;
            }
        }
    }

    private void getValueAndData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String suffix = "data".equals(dataItem) ? "DataChecked" : CodeSuffix._DATA.getType();
        String dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)suffix, Collections.singletonList(dataItem));
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            if (cols != null) {
                for (Object col : cols) {
                    JSONObject colObj = (JSONObject)col;
                    if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                    data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + colObj.getString("field") + "));return result;}()");
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getItemValue(List<String> dataItems, ComponentData data) throws LcdpException {
        String dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"Item", Collections.singletonList("item"));
        dataValue = ComponentDataUtil.dealPrefixThis((String)dataValue);
        if (dataItems.size() == 2) {
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            if (cols != null) {
                for (Object col : cols) {
                    JSONObject colObj = (JSONObject)col;
                    if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                    data.setRenderValue(dataValue + "." + colObj.getString("field"));
                    data.setDataType(((JSONObject)col).getString("dataType"));
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    public String getDefaultValue() {
        return "[]";
    }

    public Map<String, String> getComponentColMapping() {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
        List colsList = cols.toJavaList(ColsAnalysis.class);
        HashMap<String, String> map = new HashMap<String, String>(16);
        colsList.forEach(col -> map.put(col.getId(), col.getField()));
        return map;
    }

    public List<ComponentData> getClearValue(List<String> list) throws LcdpException {
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.ARRAY_OBJECT, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        ComponentData data = new ComponentData();
        data.setDataType(eventParamConfig.getDataType());
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        Map<String, String> componentColMapping = this.getComponentColMapping();
        String renderValue = (String)eventParamConfig.getEventParamData().get(0);
        if (eventParamConfig.getEventParamData().size() > 1) {
            String colField = (String)eventParamConfig.getEventParamData().get(1);
            if (ToolUtil.isNotEmpty((Object)colField)) {
                if ("uniqueIndex".equals(colField)) {
                    data.setRenderValue("function(){\nreturn typeof " + eventParamConfig.getInstanceKey() + "Index !== 'undefined' ?" + eventParamConfig.getInstanceKey() + "Index : data.index;}()");
                } else {
                    data.setRenderValue("function(){\nreturn typeof " + eventParamConfig.getInstanceKey() + "Item !== 'undefined' ?" + eventParamConfig.getInstanceKey() + "Item." + colField + " : data." + colField + ";}()");
                }
            }
        } else if (ToolUtil.isNotEmpty(eventParamConfig.getEventParamData().get(0))) {
            data.setRenderValue(eventParamConfig.getInstanceKey() + "Item");
        }
        return data;
    }

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }
}

